-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 定义模块需要的通用常量和方法
local prbs_test_def = {}
prbs_test_def.cmd = {
    GET_STATE = 0,
    CONFIG = 1,
    CLEAR_STATISTICS = 2,
    GET_RESULT = 3,
    CLOSE = 4
}

prbs_test_def.get_state_result = {
    PENDING = 0,
    TX_ENABLED = 1,
    RX_ENABLED = 2,
    TXRX_ENABLED = 3
}

prbs_test_def.config_item = {
    START_TX = 0,
    START_RX = 1,
    START_TXRX = 2
}

prbs_test_def.config_result = {
    SUCCESS = 0,
    FAIL = 1,
    UNSUPPORT = 2
}

prbs_test_def.common_result = {
    SUCCESS = 0,
    FAILED = 1,
}

prbs_test_def.support_type = {
    NOT_SUPPORT = 0,    -- 不支持
    CMIS_DEFINE = 1     -- 支持CMIS定义
}

prbs_test_def.prbs_state = {
    PENDING = 'Pending',
    RUNNING = 'Running',
    UNKNOWN = 'Unknown'
}

return prbs_test_def