-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local log = require 'mc.logging'
local bs = require 'mc.bitstring'
local card_comm = require 'device.class.network_card_adapter.card_comm'

local card_device_asset_data = {}

local function register_asset_listen_callback(device_obj, resource_obj)
    device_obj:listen('Name', function(_, value)
        resource_obj.AssetName = value
    end)

    device_obj:listen('FirmwareVersion', function(_, value)
        resource_obj.InventoryFirmwareVersion = value
    end)

    device_obj:listen('Manufacturer', function(_, value)
        resource_obj.InventoryManufacturer = value
    end)

    device_obj:listen('Slot', function(_, value)
        resource_obj.Slot = tostring(value)
    end)
end

function card_device_asset_data.init_asset_data(resource_obj)
    local device_obj = nil
    if card_comm.is_virtual_port(device_obj.Type) then
        return
    end

    local data_obj = {
        Name = device_obj.Name,
        SerialNumber = '',
        FirmwareVersion = device_obj.FirmwareVersion,
        PCBVersion = '.A',
        Manufacturer = device_obj.Manufacturer,
        SlotNumber = tostring(device_obj.Slot),
    }
    card_comm.set_card_init_asset_data(data_obj, resource_obj)
    register_asset_listen_callback(device_obj, resource_obj)
end

return card_device_asset_data