-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local c_object = require 'mc.orm.object'

local orm_classes = {}

function orm_classes.init(db)
    orm_classes.NetworkAdapter = c_object('NetworkAdapter')
    orm_classes.NetworkPort = c_object('NetworkPort')
    orm_classes.VLAN = c_object('VLAN')
    orm_classes.IPv4Address = c_object('IPv4Address')
    orm_classes.IPv6Address = c_object('IPv6Address')
    orm_classes.VLANIPv4Address = c_object('VLANIPv4Address')
    orm_classes.VLANIPv6Address = c_object('VLANIPv6Address')
    orm_classes.OpticalModule = c_object('OpticalModule')
    orm_classes.OpticalModuleChannel = c_object('OpticalModuleChannel')
    orm_classes.NcsiNCInfo = c_object('NcsiNCInfo')
    orm_classes.NcsiNCPortInfo = c_object('NcsiNCPortInfo')
    orm_classes.PortUsageHistory = c_object('PortUsageHistory')
    orm_classes.NetworkBridge = c_object('NetworkBridge')
    orm_classes.NetworkBridgePort = c_object('NetworkBridgePort')
    orm_classes.NetworkBonding = c_object('NetworkBonding')
    orm_classes.NetworkBondingPort = c_object('NetworkBondingPort')
    orm_classes.NCSIChannelMgmt = c_object('NCSIChannelMgmt')
end

return orm_classes
