-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local VLAN = {}

---@class VLAN.AutoConnectOnBoot
---@field AutoConnectOnBoot boolean
local TAutoConnectOnBoot = {}
TAutoConnectOnBoot.__index = TAutoConnectOnBoot
TAutoConnectOnBoot.group = {}

local function TAutoConnectOnBoot_from_obj(obj)
    return setmetatable(obj, TAutoConnectOnBoot)
end

function TAutoConnectOnBoot.new(AutoConnectOnBoot)
    return TAutoConnectOnBoot_from_obj({AutoConnectOnBoot = AutoConnectOnBoot})
end
---@param obj VLAN.AutoConnectOnBoot
function TAutoConnectOnBoot:init_from_obj(obj)
    self.AutoConnectOnBoot = obj.AutoConnectOnBoot
end

function TAutoConnectOnBoot:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAutoConnectOnBoot.group)
end

TAutoConnectOnBoot.from_obj = TAutoConnectOnBoot_from_obj

TAutoConnectOnBoot.proto_property = {'AutoConnectOnBoot'}

TAutoConnectOnBoot.default = {false}

TAutoConnectOnBoot.struct = {{name = 'AutoConnectOnBoot', is_array = false, struct = nil}}

function TAutoConnectOnBoot:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AutoConnectOnBoot', self.AutoConnectOnBoot, 'bool', true, errs, need_convert)

    TAutoConnectOnBoot:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAutoConnectOnBoot.proto_property, errs, need_convert)
    return self
end

function TAutoConnectOnBoot:unpack(_)
    return self.AutoConnectOnBoot
end

VLAN.AutoConnectOnBoot = TAutoConnectOnBoot

---@class VLAN.VLANPriority
---@field VLANPriority integer
local TVLANPriority = {}
TVLANPriority.__index = TVLANPriority
TVLANPriority.group = {}

local function TVLANPriority_from_obj(obj)
    return setmetatable(obj, TVLANPriority)
end

function TVLANPriority.new(VLANPriority)
    return TVLANPriority_from_obj({VLANPriority = VLANPriority})
end
---@param obj VLAN.VLANPriority
function TVLANPriority:init_from_obj(obj)
    self.VLANPriority = obj.VLANPriority
end

function TVLANPriority:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVLANPriority.group)
end

TVLANPriority.from_obj = TVLANPriority_from_obj

TVLANPriority.proto_property = {'VLANPriority'}

TVLANPriority.default = {0}

TVLANPriority.struct = {{name = 'VLANPriority', is_array = false, struct = nil}}

function TVLANPriority:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VLANPriority', self.VLANPriority, 'uint8', true, errs, need_convert)

    TVLANPriority:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVLANPriority.proto_property, errs, need_convert)
    return self
end

function TVLANPriority:unpack(_)
    return self.VLANPriority
end

VLAN.VLANPriority = TVLANPriority

---@class VLAN.VLANEnabled
---@field VLANEnabled boolean
local TVLANEnabled = {}
TVLANEnabled.__index = TVLANEnabled
TVLANEnabled.group = {}

local function TVLANEnabled_from_obj(obj)
    return setmetatable(obj, TVLANEnabled)
end

function TVLANEnabled.new(VLANEnabled)
    return TVLANEnabled_from_obj({VLANEnabled = VLANEnabled})
end
---@param obj VLAN.VLANEnabled
function TVLANEnabled:init_from_obj(obj)
    self.VLANEnabled = obj.VLANEnabled
end

function TVLANEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVLANEnabled.group)
end

TVLANEnabled.from_obj = TVLANEnabled_from_obj

TVLANEnabled.proto_property = {'VLANEnabled'}

TVLANEnabled.default = {false}

TVLANEnabled.struct = {{name = 'VLANEnabled', is_array = false, struct = nil}}

function TVLANEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VLANEnabled', self.VLANEnabled, 'bool', true, errs, need_convert)

    TVLANEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVLANEnabled.proto_property, errs, need_convert)
    return self
end

function TVLANEnabled:unpack(_)
    return self.VLANEnabled
end

VLAN.VLANEnabled = TVLANEnabled

---@class VLAN.VLANId
---@field VLANId integer
local TVLANId = {}
TVLANId.__index = TVLANId
TVLANId.group = {}

local function TVLANId_from_obj(obj)
    return setmetatable(obj, TVLANId)
end

function TVLANId.new(VLANId)
    return TVLANId_from_obj({VLANId = VLANId})
end
---@param obj VLAN.VLANId
function TVLANId:init_from_obj(obj)
    self.VLANId = obj.VLANId
end

function TVLANId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVLANId.group)
end

TVLANId.from_obj = TVLANId_from_obj

TVLANId.proto_property = {'VLANId'}

TVLANId.default = {0}

TVLANId.struct = {{name = 'VLANId', is_array = false, struct = nil}}

function TVLANId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'VLANId', self.VLANId, 'uint16', true, errs, need_convert)

    TVLANId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVLANId.proto_property, errs, need_convert)
    return self
end

function TVLANId:unpack(_)
    return self.VLANId
end

VLAN.VLANId = TVLANId

---@class VLAN.DeleteVLANRsp
---@field TaskId integer
local TDeleteVLANRsp = {}
TDeleteVLANRsp.__index = TDeleteVLANRsp
TDeleteVLANRsp.group = {}

local function TDeleteVLANRsp_from_obj(obj)
    return setmetatable(obj, TDeleteVLANRsp)
end

function TDeleteVLANRsp.new(TaskId)
    return TDeleteVLANRsp_from_obj({TaskId = TaskId})
end
---@param obj VLAN.DeleteVLANRsp
function TDeleteVLANRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TDeleteVLANRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteVLANRsp.group)
end

TDeleteVLANRsp.from_obj = TDeleteVLANRsp_from_obj

TDeleteVLANRsp.proto_property = {'TaskId'}

TDeleteVLANRsp.default = {0}

TDeleteVLANRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TDeleteVLANRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TDeleteVLANRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteVLANRsp.proto_property, errs, need_convert)
    return self
end

function TDeleteVLANRsp:unpack(_)
    return self.TaskId
end

VLAN.DeleteVLANRsp = TDeleteVLANRsp

---@class VLAN.DeleteVLANReq
local TDeleteVLANReq = {}
TDeleteVLANReq.__index = TDeleteVLANReq
TDeleteVLANReq.group = {}

local function TDeleteVLANReq_from_obj(obj)
    return setmetatable(obj, TDeleteVLANReq)
end

function TDeleteVLANReq.new()
    return TDeleteVLANReq_from_obj({})
end
---@param obj VLAN.DeleteVLANReq
function TDeleteVLANReq:init_from_obj(obj)

end

function TDeleteVLANReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteVLANReq.group)
end

TDeleteVLANReq.from_obj = TDeleteVLANReq_from_obj

TDeleteVLANReq.proto_property = {}

TDeleteVLANReq.default = {}

TDeleteVLANReq.struct = {}

function TDeleteVLANReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TDeleteVLANReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteVLANReq.proto_property, errs, need_convert)
    return self
end

function TDeleteVLANReq:unpack(_)
end

VLAN.DeleteVLANReq = TDeleteVLANReq

---@class VLAN.ConfigureVLANRsp
---@field TaskId integer
local TConfigureVLANRsp = {}
TConfigureVLANRsp.__index = TConfigureVLANRsp
TConfigureVLANRsp.group = {}

local function TConfigureVLANRsp_from_obj(obj)
    return setmetatable(obj, TConfigureVLANRsp)
end

function TConfigureVLANRsp.new(TaskId)
    return TConfigureVLANRsp_from_obj({TaskId = TaskId})
end
---@param obj VLAN.ConfigureVLANRsp
function TConfigureVLANRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TConfigureVLANRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConfigureVLANRsp.group)
end

TConfigureVLANRsp.from_obj = TConfigureVLANRsp_from_obj

TConfigureVLANRsp.proto_property = {'TaskId'}

TConfigureVLANRsp.default = {0}

TConfigureVLANRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TConfigureVLANRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TConfigureVLANRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConfigureVLANRsp.proto_property, errs, need_convert)
    return self
end

function TConfigureVLANRsp:unpack(_)
    return self.TaskId
end

VLAN.ConfigureVLANRsp = TConfigureVLANRsp

---@class VLAN.Object
---@field key string
---@field value string
local TObject = {}
TObject.__index = TObject
TObject.group = {}

local function TObject_from_obj(obj)
    return setmetatable(obj, TObject)
end

function TObject.new(dict)
    return TObject_from_obj(dict)
end

---@param obj VLAN.Object
function TObject:init_from_obj(obj)
    self = obj
end

function TObject:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TObject.group)
end

TObject.from_obj = TObject_from_obj

TObject.proto_property = {}

TObject.default = {}

TObject.struct = {}

function TObject:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TObject:remove_error_props(errs, self)
    return self
end

function TObject:unpack(_)
    return self
end

VLAN.Object = TObject

---@class VLAN.ConfigureVLANReq
---@field Request VLAN.Object
local TConfigureVLANReq = {}
TConfigureVLANReq.__index = TConfigureVLANReq
TConfigureVLANReq.group = {}

local function TConfigureVLANReq_from_obj(obj)
    return setmetatable(obj, TConfigureVLANReq)
end

function TConfigureVLANReq.new(Request)
    return TConfigureVLANReq_from_obj({Request = Request})
end
---@param obj VLAN.ConfigureVLANReq
function TConfigureVLANReq:init_from_obj(obj)
    self.Request = obj.Request
end

function TConfigureVLANReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConfigureVLANReq.group)
end

TConfigureVLANReq.from_obj = TConfigureVLANReq_from_obj

TConfigureVLANReq.proto_property = {'Request'}

TConfigureVLANReq.default = {VLAN.Object.default}

TConfigureVLANReq.struct = {{name = 'Request', is_array = false, struct = VLAN.Object.struct}}

function TConfigureVLANReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    VLAN.Object.new(self.Request):validate(prefix, errs, need_convert)

    TConfigureVLANReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConfigureVLANReq.proto_property, errs, need_convert)
    return self
end

function TConfigureVLANReq:unpack(_)
    return self.Request
end

VLAN.ConfigureVLANReq = TConfigureVLANReq

VLAN.interface = mdb.register_interface('bmc.kepler.Systems.NetworkPort.VLAN', {
    VLANId = {'q', nil, true, nil, false},
    VLANEnabled = {'b', nil, true, nil, false},
    VLANPriority = {'y', nil, true, nil, false},
    AutoConnectOnBoot = {'b', nil, true, nil, false}
}, {
    ConfigureVLAN = {'a{ss}a{ss}', 'u', TConfigureVLANReq, TConfigureVLANRsp},
    DeleteVLAN = {'a{ss}', 'u', TDeleteVLANReq, TDeleteVLANRsp}
}, {})

return VLAN
