-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Power = {}

---@class Power.PowerRXLowerThresholdWarning
---@field PowerRXLowerThresholdWarning number
local TPowerRXLowerThresholdWarning = {}
TPowerRXLowerThresholdWarning.__index = TPowerRXLowerThresholdWarning
TPowerRXLowerThresholdWarning.group = {}

local function TPowerRXLowerThresholdWarning_from_obj(obj)
    return setmetatable(obj, TPowerRXLowerThresholdWarning)
end

function TPowerRXLowerThresholdWarning.new(PowerRXLowerThresholdWarning)
    return
        TPowerRXLowerThresholdWarning_from_obj({PowerRXLowerThresholdWarning = PowerRXLowerThresholdWarning or 65535})
end
---@param obj Power.PowerRXLowerThresholdWarning
function TPowerRXLowerThresholdWarning:init_from_obj(obj)
    self.PowerRXLowerThresholdWarning = obj.PowerRXLowerThresholdWarning or 65535
end

function TPowerRXLowerThresholdWarning:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerRXLowerThresholdWarning.group)
end

TPowerRXLowerThresholdWarning.from_obj = TPowerRXLowerThresholdWarning_from_obj

TPowerRXLowerThresholdWarning.proto_property = {'PowerRXLowerThresholdWarning'}

TPowerRXLowerThresholdWarning.default = {0}

TPowerRXLowerThresholdWarning.struct = {{name = 'PowerRXLowerThresholdWarning', is_array = false, struct = nil}}

function TPowerRXLowerThresholdWarning:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerRXLowerThresholdWarning', self.PowerRXLowerThresholdWarning, 'double', true, errs,
        need_convert)

    TPowerRXLowerThresholdWarning:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerRXLowerThresholdWarning.proto_property, errs, need_convert)
    return self
end

function TPowerRXLowerThresholdWarning:unpack(_)
    return self.PowerRXLowerThresholdWarning
end

Power.PowerRXLowerThresholdWarning = TPowerRXLowerThresholdWarning

---@class Power.PowerRXUpperThresholdWarning
---@field PowerRXUpperThresholdWarning number
local TPowerRXUpperThresholdWarning = {}
TPowerRXUpperThresholdWarning.__index = TPowerRXUpperThresholdWarning
TPowerRXUpperThresholdWarning.group = {}

local function TPowerRXUpperThresholdWarning_from_obj(obj)
    return setmetatable(obj, TPowerRXUpperThresholdWarning)
end

function TPowerRXUpperThresholdWarning.new(PowerRXUpperThresholdWarning)
    return
        TPowerRXUpperThresholdWarning_from_obj({PowerRXUpperThresholdWarning = PowerRXUpperThresholdWarning or 65535})
end
---@param obj Power.PowerRXUpperThresholdWarning
function TPowerRXUpperThresholdWarning:init_from_obj(obj)
    self.PowerRXUpperThresholdWarning = obj.PowerRXUpperThresholdWarning or 65535
end

function TPowerRXUpperThresholdWarning:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerRXUpperThresholdWarning.group)
end

TPowerRXUpperThresholdWarning.from_obj = TPowerRXUpperThresholdWarning_from_obj

TPowerRXUpperThresholdWarning.proto_property = {'PowerRXUpperThresholdWarning'}

TPowerRXUpperThresholdWarning.default = {0}

TPowerRXUpperThresholdWarning.struct = {{name = 'PowerRXUpperThresholdWarning', is_array = false, struct = nil}}

function TPowerRXUpperThresholdWarning:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerRXUpperThresholdWarning', self.PowerRXUpperThresholdWarning, 'double', true, errs,
        need_convert)

    TPowerRXUpperThresholdWarning:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerRXUpperThresholdWarning.proto_property, errs, need_convert)
    return self
end

function TPowerRXUpperThresholdWarning:unpack(_)
    return self.PowerRXUpperThresholdWarning
end

Power.PowerRXUpperThresholdWarning = TPowerRXUpperThresholdWarning

---@class Power.PowerTXLowerThresholdWarning
---@field PowerTXLowerThresholdWarning number
local TPowerTXLowerThresholdWarning = {}
TPowerTXLowerThresholdWarning.__index = TPowerTXLowerThresholdWarning
TPowerTXLowerThresholdWarning.group = {}

local function TPowerTXLowerThresholdWarning_from_obj(obj)
    return setmetatable(obj, TPowerTXLowerThresholdWarning)
end

function TPowerTXLowerThresholdWarning.new(PowerTXLowerThresholdWarning)
    return
        TPowerTXLowerThresholdWarning_from_obj({PowerTXLowerThresholdWarning = PowerTXLowerThresholdWarning or 65535})
end
---@param obj Power.PowerTXLowerThresholdWarning
function TPowerTXLowerThresholdWarning:init_from_obj(obj)
    self.PowerTXLowerThresholdWarning = obj.PowerTXLowerThresholdWarning or 65535
end

function TPowerTXLowerThresholdWarning:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerTXLowerThresholdWarning.group)
end

TPowerTXLowerThresholdWarning.from_obj = TPowerTXLowerThresholdWarning_from_obj

TPowerTXLowerThresholdWarning.proto_property = {'PowerTXLowerThresholdWarning'}

TPowerTXLowerThresholdWarning.default = {0}

TPowerTXLowerThresholdWarning.struct = {{name = 'PowerTXLowerThresholdWarning', is_array = false, struct = nil}}

function TPowerTXLowerThresholdWarning:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerTXLowerThresholdWarning', self.PowerTXLowerThresholdWarning, 'double', true, errs,
        need_convert)

    TPowerTXLowerThresholdWarning:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerTXLowerThresholdWarning.proto_property, errs, need_convert)
    return self
end

function TPowerTXLowerThresholdWarning:unpack(_)
    return self.PowerTXLowerThresholdWarning
end

Power.PowerTXLowerThresholdWarning = TPowerTXLowerThresholdWarning

---@class Power.PowerTXUpperThresholdWarning
---@field PowerTXUpperThresholdWarning number
local TPowerTXUpperThresholdWarning = {}
TPowerTXUpperThresholdWarning.__index = TPowerTXUpperThresholdWarning
TPowerTXUpperThresholdWarning.group = {}

local function TPowerTXUpperThresholdWarning_from_obj(obj)
    return setmetatable(obj, TPowerTXUpperThresholdWarning)
end

function TPowerTXUpperThresholdWarning.new(PowerTXUpperThresholdWarning)
    return
        TPowerTXUpperThresholdWarning_from_obj({PowerTXUpperThresholdWarning = PowerTXUpperThresholdWarning or 65535})
end
---@param obj Power.PowerTXUpperThresholdWarning
function TPowerTXUpperThresholdWarning:init_from_obj(obj)
    self.PowerTXUpperThresholdWarning = obj.PowerTXUpperThresholdWarning or 65535
end

function TPowerTXUpperThresholdWarning:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerTXUpperThresholdWarning.group)
end

TPowerTXUpperThresholdWarning.from_obj = TPowerTXUpperThresholdWarning_from_obj

TPowerTXUpperThresholdWarning.proto_property = {'PowerTXUpperThresholdWarning'}

TPowerTXUpperThresholdWarning.default = {0}

TPowerTXUpperThresholdWarning.struct = {{name = 'PowerTXUpperThresholdWarning', is_array = false, struct = nil}}

function TPowerTXUpperThresholdWarning:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerTXUpperThresholdWarning', self.PowerTXUpperThresholdWarning, 'double', true, errs,
        need_convert)

    TPowerTXUpperThresholdWarning:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerTXUpperThresholdWarning.proto_property, errs, need_convert)
    return self
end

function TPowerTXUpperThresholdWarning:unpack(_)
    return self.PowerTXUpperThresholdWarning
end

Power.PowerTXUpperThresholdWarning = TPowerTXUpperThresholdWarning

---@class Power.TXUpperThresholdCritical
---@field TXUpperThresholdCritical number
local TTXUpperThresholdCritical = {}
TTXUpperThresholdCritical.__index = TTXUpperThresholdCritical
TTXUpperThresholdCritical.group = {}

local function TTXUpperThresholdCritical_from_obj(obj)
    return setmetatable(obj, TTXUpperThresholdCritical)
end

function TTXUpperThresholdCritical.new(TXUpperThresholdCritical)
    return TTXUpperThresholdCritical_from_obj({TXUpperThresholdCritical = TXUpperThresholdCritical or 65535})
end
---@param obj Power.TXUpperThresholdCritical
function TTXUpperThresholdCritical:init_from_obj(obj)
    self.TXUpperThresholdCritical = obj.TXUpperThresholdCritical or 65535
end

function TTXUpperThresholdCritical:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXUpperThresholdCritical.group)
end

TTXUpperThresholdCritical.from_obj = TTXUpperThresholdCritical_from_obj

TTXUpperThresholdCritical.proto_property = {'TXUpperThresholdCritical'}

TTXUpperThresholdCritical.default = {0}

TTXUpperThresholdCritical.struct = {{name = 'TXUpperThresholdCritical', is_array = false, struct = nil}}

function TTXUpperThresholdCritical:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TXUpperThresholdCritical', self.TXUpperThresholdCritical, 'double', true, errs,
        need_convert)

    TTXUpperThresholdCritical:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXUpperThresholdCritical.proto_property, errs, need_convert)
    return self
end

function TTXUpperThresholdCritical:unpack(_)
    return self.TXUpperThresholdCritical
end

Power.TXUpperThresholdCritical = TTXUpperThresholdCritical

---@class Power.TXLowerThresholdCritical
---@field TXLowerThresholdCritical number
local TTXLowerThresholdCritical = {}
TTXLowerThresholdCritical.__index = TTXLowerThresholdCritical
TTXLowerThresholdCritical.group = {}

local function TTXLowerThresholdCritical_from_obj(obj)
    return setmetatable(obj, TTXLowerThresholdCritical)
end

function TTXLowerThresholdCritical.new(TXLowerThresholdCritical)
    return TTXLowerThresholdCritical_from_obj({TXLowerThresholdCritical = TXLowerThresholdCritical or 65535})
end
---@param obj Power.TXLowerThresholdCritical
function TTXLowerThresholdCritical:init_from_obj(obj)
    self.TXLowerThresholdCritical = obj.TXLowerThresholdCritical or 65535
end

function TTXLowerThresholdCritical:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXLowerThresholdCritical.group)
end

TTXLowerThresholdCritical.from_obj = TTXLowerThresholdCritical_from_obj

TTXLowerThresholdCritical.proto_property = {'TXLowerThresholdCritical'}

TTXLowerThresholdCritical.default = {0}

TTXLowerThresholdCritical.struct = {{name = 'TXLowerThresholdCritical', is_array = false, struct = nil}}

function TTXLowerThresholdCritical:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TXLowerThresholdCritical', self.TXLowerThresholdCritical, 'double', true, errs,
        need_convert)

    TTXLowerThresholdCritical:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXLowerThresholdCritical.proto_property, errs, need_convert)
    return self
end

function TTXLowerThresholdCritical:unpack(_)
    return self.TXLowerThresholdCritical
end

Power.TXLowerThresholdCritical = TTXLowerThresholdCritical

---@class Power.TXOutputPowerStatus
---@field TXOutputPowerStatus integer
local TTXOutputPowerStatus = {}
TTXOutputPowerStatus.__index = TTXOutputPowerStatus
TTXOutputPowerStatus.group = {}

local function TTXOutputPowerStatus_from_obj(obj)
    return setmetatable(obj, TTXOutputPowerStatus)
end

function TTXOutputPowerStatus.new(TXOutputPowerStatus)
    return TTXOutputPowerStatus_from_obj({TXOutputPowerStatus = TXOutputPowerStatus})
end
---@param obj Power.TXOutputPowerStatus
function TTXOutputPowerStatus:init_from_obj(obj)
    self.TXOutputPowerStatus = obj.TXOutputPowerStatus
end

function TTXOutputPowerStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXOutputPowerStatus.group)
end

TTXOutputPowerStatus.from_obj = TTXOutputPowerStatus_from_obj

TTXOutputPowerStatus.proto_property = {'TXOutputPowerStatus'}

TTXOutputPowerStatus.default = {0}

TTXOutputPowerStatus.struct = {{name = 'TXOutputPowerStatus', is_array = false, struct = nil}}

function TTXOutputPowerStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TXOutputPowerStatus', self.TXOutputPowerStatus, 'uint32', true, errs, need_convert)

    TTXOutputPowerStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXOutputPowerStatus.proto_property, errs, need_convert)
    return self
end

function TTXOutputPowerStatus:unpack(_)
    return self.TXOutputPowerStatus
end

Power.TXOutputPowerStatus = TTXOutputPowerStatus

---@class Power.TXOutputPowerMilliWatts
---@field TXOutputPowerMilliWatts number[]
local TTXOutputPowerMilliWatts = {}
TTXOutputPowerMilliWatts.__index = TTXOutputPowerMilliWatts
TTXOutputPowerMilliWatts.group = {}

local function TTXOutputPowerMilliWatts_from_obj(obj)
    return setmetatable(obj, TTXOutputPowerMilliWatts)
end

function TTXOutputPowerMilliWatts.new(TXOutputPowerMilliWatts)
    return TTXOutputPowerMilliWatts_from_obj({TXOutputPowerMilliWatts = TXOutputPowerMilliWatts})
end
---@param obj Power.TXOutputPowerMilliWatts
function TTXOutputPowerMilliWatts:init_from_obj(obj)
    self.TXOutputPowerMilliWatts = obj.TXOutputPowerMilliWatts
end

function TTXOutputPowerMilliWatts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTXOutputPowerMilliWatts.group)
end

TTXOutputPowerMilliWatts.from_obj = TTXOutputPowerMilliWatts_from_obj

TTXOutputPowerMilliWatts.proto_property = {'TXOutputPowerMilliWatts'}

TTXOutputPowerMilliWatts.default = {{}}

TTXOutputPowerMilliWatts.struct = {{name = 'TXOutputPowerMilliWatts', is_array = true, struct = nil}}

function TTXOutputPowerMilliWatts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'TXOutputPowerMilliWatts', self.TXOutputPowerMilliWatts, 'double', true, errs,
        need_convert)

    TTXOutputPowerMilliWatts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTXOutputPowerMilliWatts.proto_property, errs, need_convert)
    return self
end

function TTXOutputPowerMilliWatts:unpack(_)
    return self.TXOutputPowerMilliWatts
end

Power.TXOutputPowerMilliWatts = TTXOutputPowerMilliWatts

---@class Power.RXUpperThresholdCritical
---@field RXUpperThresholdCritical number
local TRXUpperThresholdCritical = {}
TRXUpperThresholdCritical.__index = TRXUpperThresholdCritical
TRXUpperThresholdCritical.group = {}

local function TRXUpperThresholdCritical_from_obj(obj)
    return setmetatable(obj, TRXUpperThresholdCritical)
end

function TRXUpperThresholdCritical.new(RXUpperThresholdCritical)
    return TRXUpperThresholdCritical_from_obj({RXUpperThresholdCritical = RXUpperThresholdCritical or 65535})
end
---@param obj Power.RXUpperThresholdCritical
function TRXUpperThresholdCritical:init_from_obj(obj)
    self.RXUpperThresholdCritical = obj.RXUpperThresholdCritical or 65535
end

function TRXUpperThresholdCritical:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRXUpperThresholdCritical.group)
end

TRXUpperThresholdCritical.from_obj = TRXUpperThresholdCritical_from_obj

TRXUpperThresholdCritical.proto_property = {'RXUpperThresholdCritical'}

TRXUpperThresholdCritical.default = {0}

TRXUpperThresholdCritical.struct = {{name = 'RXUpperThresholdCritical', is_array = false, struct = nil}}

function TRXUpperThresholdCritical:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RXUpperThresholdCritical', self.RXUpperThresholdCritical, 'double', true, errs,
        need_convert)

    TRXUpperThresholdCritical:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRXUpperThresholdCritical.proto_property, errs, need_convert)
    return self
end

function TRXUpperThresholdCritical:unpack(_)
    return self.RXUpperThresholdCritical
end

Power.RXUpperThresholdCritical = TRXUpperThresholdCritical

---@class Power.RXLowerThresholdCritical
---@field RXLowerThresholdCritical number
local TRXLowerThresholdCritical = {}
TRXLowerThresholdCritical.__index = TRXLowerThresholdCritical
TRXLowerThresholdCritical.group = {}

local function TRXLowerThresholdCritical_from_obj(obj)
    return setmetatable(obj, TRXLowerThresholdCritical)
end

function TRXLowerThresholdCritical.new(RXLowerThresholdCritical)
    return TRXLowerThresholdCritical_from_obj({RXLowerThresholdCritical = RXLowerThresholdCritical or 65535})
end
---@param obj Power.RXLowerThresholdCritical
function TRXLowerThresholdCritical:init_from_obj(obj)
    self.RXLowerThresholdCritical = obj.RXLowerThresholdCritical or 65535
end

function TRXLowerThresholdCritical:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRXLowerThresholdCritical.group)
end

TRXLowerThresholdCritical.from_obj = TRXLowerThresholdCritical_from_obj

TRXLowerThresholdCritical.proto_property = {'RXLowerThresholdCritical'}

TRXLowerThresholdCritical.default = {0}

TRXLowerThresholdCritical.struct = {{name = 'RXLowerThresholdCritical', is_array = false, struct = nil}}

function TRXLowerThresholdCritical:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RXLowerThresholdCritical', self.RXLowerThresholdCritical, 'double', true, errs,
        need_convert)

    TRXLowerThresholdCritical:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRXLowerThresholdCritical.proto_property, errs, need_convert)
    return self
end

function TRXLowerThresholdCritical:unpack(_)
    return self.RXLowerThresholdCritical
end

Power.RXLowerThresholdCritical = TRXLowerThresholdCritical

---@class Power.RXInputPowerStatus
---@field RXInputPowerStatus integer
local TRXInputPowerStatus = {}
TRXInputPowerStatus.__index = TRXInputPowerStatus
TRXInputPowerStatus.group = {}

local function TRXInputPowerStatus_from_obj(obj)
    return setmetatable(obj, TRXInputPowerStatus)
end

function TRXInputPowerStatus.new(RXInputPowerStatus)
    return TRXInputPowerStatus_from_obj({RXInputPowerStatus = RXInputPowerStatus})
end
---@param obj Power.RXInputPowerStatus
function TRXInputPowerStatus:init_from_obj(obj)
    self.RXInputPowerStatus = obj.RXInputPowerStatus
end

function TRXInputPowerStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRXInputPowerStatus.group)
end

TRXInputPowerStatus.from_obj = TRXInputPowerStatus_from_obj

TRXInputPowerStatus.proto_property = {'RXInputPowerStatus'}

TRXInputPowerStatus.default = {0}

TRXInputPowerStatus.struct = {{name = 'RXInputPowerStatus', is_array = false, struct = nil}}

function TRXInputPowerStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RXInputPowerStatus', self.RXInputPowerStatus, 'uint32', true, errs, need_convert)

    TRXInputPowerStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRXInputPowerStatus.proto_property, errs, need_convert)
    return self
end

function TRXInputPowerStatus:unpack(_)
    return self.RXInputPowerStatus
end

Power.RXInputPowerStatus = TRXInputPowerStatus

---@class Power.RXInputPowerMilliWatts
---@field RXInputPowerMilliWatts number[]
local TRXInputPowerMilliWatts = {}
TRXInputPowerMilliWatts.__index = TRXInputPowerMilliWatts
TRXInputPowerMilliWatts.group = {}

local function TRXInputPowerMilliWatts_from_obj(obj)
    return setmetatable(obj, TRXInputPowerMilliWatts)
end

function TRXInputPowerMilliWatts.new(RXInputPowerMilliWatts)
    return TRXInputPowerMilliWatts_from_obj({RXInputPowerMilliWatts = RXInputPowerMilliWatts})
end
---@param obj Power.RXInputPowerMilliWatts
function TRXInputPowerMilliWatts:init_from_obj(obj)
    self.RXInputPowerMilliWatts = obj.RXInputPowerMilliWatts
end

function TRXInputPowerMilliWatts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRXInputPowerMilliWatts.group)
end

TRXInputPowerMilliWatts.from_obj = TRXInputPowerMilliWatts_from_obj

TRXInputPowerMilliWatts.proto_property = {'RXInputPowerMilliWatts'}

TRXInputPowerMilliWatts.default = {{}}

TRXInputPowerMilliWatts.struct = {{name = 'RXInputPowerMilliWatts', is_array = true, struct = nil}}

function TRXInputPowerMilliWatts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'RXInputPowerMilliWatts', self.RXInputPowerMilliWatts, 'double', true, errs,
        need_convert)

    TRXInputPowerMilliWatts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRXInputPowerMilliWatts.proto_property, errs, need_convert)
    return self
end

function TRXInputPowerMilliWatts:unpack(_)
    return self.RXInputPowerMilliWatts
end

Power.RXInputPowerMilliWatts = TRXInputPowerMilliWatts

Power.interface = mdb.register_interface('bmc.kepler.Systems.OpticalModule.Power', {
    RXInputPowerMilliWatts = {'ad', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    RXInputPowerStatus = {'u', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    RXLowerThresholdCritical = {'d', nil, true, 65535, false},
    RXUpperThresholdCritical = {'d', nil, true, 65535, false},
    TXOutputPowerMilliWatts = {'ad', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    TXOutputPowerStatus = {'u', {'VOLATILE', 'EMIT_CHANGE'}, true, nil, false},
    TXLowerThresholdCritical = {'d', nil, true, 65535, false},
    TXUpperThresholdCritical = {'d', nil, true, 65535, false},
    PowerTXUpperThresholdWarning = {'d', nil, true, 65535, false},
    PowerTXLowerThresholdWarning = {'d', nil, true, 65535, false},
    PowerRXUpperThresholdWarning = {'d', nil, true, 65535, false},
    PowerRXLowerThresholdWarning = {'d', nil, true, 65535, false}
}, {}, {})

return Power
