-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local NetworkBondings = {}

---@class NetworkBondings.SetLinkMonitorPeriodMSRsp
---@field TaskId integer
local TSetLinkMonitorPeriodMSRsp = {}
TSetLinkMonitorPeriodMSRsp.__index = TSetLinkMonitorPeriodMSRsp
TSetLinkMonitorPeriodMSRsp.group = {}

local function TSetLinkMonitorPeriodMSRsp_from_obj(obj)
    return setmetatable(obj, TSetLinkMonitorPeriodMSRsp)
end

function TSetLinkMonitorPeriodMSRsp.new(TaskId)
    return TSetLinkMonitorPeriodMSRsp_from_obj({TaskId = TaskId})
end
---@param obj NetworkBondings.SetLinkMonitorPeriodMSRsp
function TSetLinkMonitorPeriodMSRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TSetLinkMonitorPeriodMSRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLinkMonitorPeriodMSRsp.group)
end

TSetLinkMonitorPeriodMSRsp.from_obj = TSetLinkMonitorPeriodMSRsp_from_obj

TSetLinkMonitorPeriodMSRsp.proto_property = {'TaskId'}

TSetLinkMonitorPeriodMSRsp.default = {0}

TSetLinkMonitorPeriodMSRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TSetLinkMonitorPeriodMSRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TSetLinkMonitorPeriodMSRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLinkMonitorPeriodMSRsp.proto_property, errs, need_convert)
    return self
end

function TSetLinkMonitorPeriodMSRsp:unpack(_)
    return self.TaskId
end

NetworkBondings.SetLinkMonitorPeriodMSRsp = TSetLinkMonitorPeriodMSRsp

---@class NetworkBondings.SetLinkMonitorPeriodMSReq
---@field Id string
---@field LinkMonitorPeriodMS integer
local TSetLinkMonitorPeriodMSReq = {}
TSetLinkMonitorPeriodMSReq.__index = TSetLinkMonitorPeriodMSReq
TSetLinkMonitorPeriodMSReq.group = {}

local function TSetLinkMonitorPeriodMSReq_from_obj(obj)
    return setmetatable(obj, TSetLinkMonitorPeriodMSReq)
end

function TSetLinkMonitorPeriodMSReq.new(Id, LinkMonitorPeriodMS)
    return TSetLinkMonitorPeriodMSReq_from_obj({Id = Id, LinkMonitorPeriodMS = LinkMonitorPeriodMS})
end
---@param obj NetworkBondings.SetLinkMonitorPeriodMSReq
function TSetLinkMonitorPeriodMSReq:init_from_obj(obj)
    self.Id = obj.Id
    self.LinkMonitorPeriodMS = obj.LinkMonitorPeriodMS
end

function TSetLinkMonitorPeriodMSReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLinkMonitorPeriodMSReq.group)
end

TSetLinkMonitorPeriodMSReq.from_obj = TSetLinkMonitorPeriodMSReq_from_obj

TSetLinkMonitorPeriodMSReq.proto_property = {'Id', 'LinkMonitorPeriodMS'}

TSetLinkMonitorPeriodMSReq.default = {'', 0}

TSetLinkMonitorPeriodMSReq.struct = {
    {name = 'Id', is_array = false, struct = nil}, {name = 'LinkMonitorPeriodMS', is_array = false, struct = nil}
}

function TSetLinkMonitorPeriodMSReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'LinkMonitorPeriodMS', self.LinkMonitorPeriodMS, 'uint32', false, errs, need_convert)

    if self.LinkMonitorPeriodMS ~= nil then
        validate.ranges(prefix .. 'LinkMonitorPeriodMS', self.LinkMonitorPeriodMS, 0, 999999999, errs, need_convert)
    end

    TSetLinkMonitorPeriodMSReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLinkMonitorPeriodMSReq.proto_property, errs, need_convert)
    return self
end

function TSetLinkMonitorPeriodMSReq:unpack(_)
    return self.Id, self.LinkMonitorPeriodMS
end

NetworkBondings.SetLinkMonitorPeriodMSReq = TSetLinkMonitorPeriodMSReq

---@class NetworkBondings.DeleteBondRsp
---@field TaskId integer
local TDeleteBondRsp = {}
TDeleteBondRsp.__index = TDeleteBondRsp
TDeleteBondRsp.group = {}

local function TDeleteBondRsp_from_obj(obj)
    return setmetatable(obj, TDeleteBondRsp)
end

function TDeleteBondRsp.new(TaskId)
    return TDeleteBondRsp_from_obj({TaskId = TaskId})
end
---@param obj NetworkBondings.DeleteBondRsp
function TDeleteBondRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TDeleteBondRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteBondRsp.group)
end

TDeleteBondRsp.from_obj = TDeleteBondRsp_from_obj

TDeleteBondRsp.proto_property = {'TaskId'}

TDeleteBondRsp.default = {0}

TDeleteBondRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TDeleteBondRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TDeleteBondRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteBondRsp.proto_property, errs, need_convert)
    return self
end

function TDeleteBondRsp:unpack(_)
    return self.TaskId
end

NetworkBondings.DeleteBondRsp = TDeleteBondRsp

---@class NetworkBondings.DeleteBondReq
---@field Id string
local TDeleteBondReq = {}
TDeleteBondReq.__index = TDeleteBondReq
TDeleteBondReq.group = {}

local function TDeleteBondReq_from_obj(obj)
    return setmetatable(obj, TDeleteBondReq)
end

function TDeleteBondReq.new(Id)
    return TDeleteBondReq_from_obj({Id = Id})
end
---@param obj NetworkBondings.DeleteBondReq
function TDeleteBondReq:init_from_obj(obj)
    self.Id = obj.Id
end

function TDeleteBondReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteBondReq.group)
end

TDeleteBondReq.from_obj = TDeleteBondReq_from_obj

TDeleteBondReq.proto_property = {'Id'}

TDeleteBondReq.default = {''}

TDeleteBondReq.struct = {{name = 'Id', is_array = false, struct = nil}}

function TDeleteBondReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Id', self.Id, 'string', false, errs, need_convert)

    TDeleteBondReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteBondReq.proto_property, errs, need_convert)
    return self
end

function TDeleteBondReq:unpack(_)
    return self.Id
end

NetworkBondings.DeleteBondReq = TDeleteBondReq

---@class NetworkBondings.CreateBondRsp
---@field TaskId integer
local TCreateBondRsp = {}
TCreateBondRsp.__index = TCreateBondRsp
TCreateBondRsp.group = {}

local function TCreateBondRsp_from_obj(obj)
    return setmetatable(obj, TCreateBondRsp)
end

function TCreateBondRsp.new(TaskId)
    return TCreateBondRsp_from_obj({TaskId = TaskId})
end
---@param obj NetworkBondings.CreateBondRsp
function TCreateBondRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TCreateBondRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCreateBondRsp.group)
end

TCreateBondRsp.from_obj = TCreateBondRsp_from_obj

TCreateBondRsp.proto_property = {'TaskId'}

TCreateBondRsp.default = {0}

TCreateBondRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TCreateBondRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TCreateBondRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCreateBondRsp.proto_property, errs, need_convert)
    return self
end

function TCreateBondRsp:unpack(_)
    return self.TaskId
end

NetworkBondings.CreateBondRsp = TCreateBondRsp

---@class NetworkBondings.Object
---@field key string
---@field value string
local TObject = {}
TObject.__index = TObject
TObject.group = {}

local function TObject_from_obj(obj)
    return setmetatable(obj, TObject)
end

function TObject.new(dict)
    return TObject_from_obj(dict)
end

---@param obj NetworkBondings.Object
function TObject:init_from_obj(obj)
    self = obj
end

function TObject:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TObject.group)
end

TObject.from_obj = TObject_from_obj

TObject.proto_property = {}

TObject.default = {}

TObject.struct = {}

function TObject:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TObject:remove_error_props(errs, self)
    return self
end

function TObject:unpack(_)
    return self
end

NetworkBondings.Object = TObject

---@class NetworkBondings.CreateBondReq
---@field Request NetworkBondings.Object
local TCreateBondReq = {}
TCreateBondReq.__index = TCreateBondReq
TCreateBondReq.group = {}

local function TCreateBondReq_from_obj(obj)
    return setmetatable(obj, TCreateBondReq)
end

function TCreateBondReq.new(Request)
    return TCreateBondReq_from_obj({Request = Request})
end
---@param obj NetworkBondings.CreateBondReq
function TCreateBondReq:init_from_obj(obj)
    self.Request = obj.Request
end

function TCreateBondReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCreateBondReq.group)
end

TCreateBondReq.from_obj = TCreateBondReq_from_obj

TCreateBondReq.proto_property = {'Request'}

TCreateBondReq.default = {NetworkBondings.Object.default}

TCreateBondReq.struct = {{name = 'Request', is_array = false, struct = NetworkBondings.Object.struct}}

function TCreateBondReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    NetworkBondings.Object.new(self.Request):validate(prefix, errs, need_convert)

    TCreateBondReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCreateBondReq.proto_property, errs, need_convert)
    return self
end

function TCreateBondReq:unpack(_)
    return self.Request
end

NetworkBondings.CreateBondReq = TCreateBondReq

NetworkBondings.interface = mdb.register_interface('bmc.kepler.Systems.NetworkBondings', {}, {
    CreateBond = {'a{ss}a{ss}', 'u', TCreateBondReq, TCreateBondRsp},
    DeleteBond = {'a{ss}s', 'u', TDeleteBondReq, TDeleteBondRsp},
    SetLinkMonitorPeriodMS = {'a{ss}su', 'u', TSetLinkMonitorPeriodMSReq, TSetLinkMonitorPeriodMSRsp}
}, {})

return NetworkBondings
