-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local NetworkAdapters = {}

---@class NetworkAdapters.SetBandwidthThresholdRsp
---@field Result integer
local TSetBandwidthThresholdRsp = {}
TSetBandwidthThresholdRsp.__index = TSetBandwidthThresholdRsp
TSetBandwidthThresholdRsp.group = {}

local function TSetBandwidthThresholdRsp_from_obj(obj)
    return setmetatable(obj, TSetBandwidthThresholdRsp)
end

function TSetBandwidthThresholdRsp.new(Result)
    return TSetBandwidthThresholdRsp_from_obj({Result = Result})
end
---@param obj NetworkAdapters.SetBandwidthThresholdRsp
function TSetBandwidthThresholdRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TSetBandwidthThresholdRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBandwidthThresholdRsp.group)
end

TSetBandwidthThresholdRsp.from_obj = TSetBandwidthThresholdRsp_from_obj

TSetBandwidthThresholdRsp.proto_property = {'Result'}

TSetBandwidthThresholdRsp.default = {0}

TSetBandwidthThresholdRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TSetBandwidthThresholdRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs, need_convert)

    TSetBandwidthThresholdRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBandwidthThresholdRsp.proto_property, errs, need_convert)
    return self
end

function TSetBandwidthThresholdRsp:unpack(_)
    return self.Result
end

NetworkAdapters.SetBandwidthThresholdRsp = TSetBandwidthThresholdRsp

---@class NetworkAdapters.SetBandwidthThresholdReq
---@field BandwidthThresholdPercent integer
local TSetBandwidthThresholdReq = {}
TSetBandwidthThresholdReq.__index = TSetBandwidthThresholdReq
TSetBandwidthThresholdReq.group = {}

local function TSetBandwidthThresholdReq_from_obj(obj)
    return setmetatable(obj, TSetBandwidthThresholdReq)
end

function TSetBandwidthThresholdReq.new(BandwidthThresholdPercent)
    return TSetBandwidthThresholdReq_from_obj({BandwidthThresholdPercent = BandwidthThresholdPercent})
end
---@param obj NetworkAdapters.SetBandwidthThresholdReq
function TSetBandwidthThresholdReq:init_from_obj(obj)
    self.BandwidthThresholdPercent = obj.BandwidthThresholdPercent
end

function TSetBandwidthThresholdReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBandwidthThresholdReq.group)
end

TSetBandwidthThresholdReq.from_obj = TSetBandwidthThresholdReq_from_obj

TSetBandwidthThresholdReq.proto_property = {'BandwidthThresholdPercent'}

TSetBandwidthThresholdReq.default = {0}

TSetBandwidthThresholdReq.struct = {{name = 'BandwidthThresholdPercent', is_array = false, struct = nil}}

function TSetBandwidthThresholdReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BandwidthThresholdPercent', self.BandwidthThresholdPercent, 'uint8', false, errs,
        need_convert)

    TSetBandwidthThresholdReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBandwidthThresholdReq.proto_property, errs, need_convert)
    return self
end

function TSetBandwidthThresholdReq:unpack(_)
    return self.BandwidthThresholdPercent
end

NetworkAdapters.SetBandwidthThresholdReq = TSetBandwidthThresholdReq

---@class NetworkAdapters.ClearBandwidthHistoryRsp
local TClearBandwidthHistoryRsp = {}
TClearBandwidthHistoryRsp.__index = TClearBandwidthHistoryRsp
TClearBandwidthHistoryRsp.group = {}

local function TClearBandwidthHistoryRsp_from_obj(obj)
    return setmetatable(obj, TClearBandwidthHistoryRsp)
end

function TClearBandwidthHistoryRsp.new()
    return TClearBandwidthHistoryRsp_from_obj({})
end
---@param obj NetworkAdapters.ClearBandwidthHistoryRsp
function TClearBandwidthHistoryRsp:init_from_obj(obj)

end

function TClearBandwidthHistoryRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TClearBandwidthHistoryRsp.group)
end

TClearBandwidthHistoryRsp.from_obj = TClearBandwidthHistoryRsp_from_obj

TClearBandwidthHistoryRsp.proto_property = {}

TClearBandwidthHistoryRsp.default = {}

TClearBandwidthHistoryRsp.struct = {}

function TClearBandwidthHistoryRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TClearBandwidthHistoryRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TClearBandwidthHistoryRsp.proto_property, errs, need_convert)
    return self
end

function TClearBandwidthHistoryRsp:unpack(_)
end

NetworkAdapters.ClearBandwidthHistoryRsp = TClearBandwidthHistoryRsp

---@class NetworkAdapters.ClearBandwidthHistoryReq
---@field BWUWaveTitle string
local TClearBandwidthHistoryReq = {}
TClearBandwidthHistoryReq.__index = TClearBandwidthHistoryReq
TClearBandwidthHistoryReq.group = {}

local function TClearBandwidthHistoryReq_from_obj(obj)
    return setmetatable(obj, TClearBandwidthHistoryReq)
end

function TClearBandwidthHistoryReq.new(BWUWaveTitle)
    return TClearBandwidthHistoryReq_from_obj({BWUWaveTitle = BWUWaveTitle})
end
---@param obj NetworkAdapters.ClearBandwidthHistoryReq
function TClearBandwidthHistoryReq:init_from_obj(obj)
    self.BWUWaveTitle = obj.BWUWaveTitle
end

function TClearBandwidthHistoryReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TClearBandwidthHistoryReq.group)
end

TClearBandwidthHistoryReq.from_obj = TClearBandwidthHistoryReq_from_obj

TClearBandwidthHistoryReq.proto_property = {'BWUWaveTitle'}

TClearBandwidthHistoryReq.default = {''}

TClearBandwidthHistoryReq.struct = {{name = 'BWUWaveTitle', is_array = false, struct = nil}}

function TClearBandwidthHistoryReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BWUWaveTitle', self.BWUWaveTitle, 'string', false, errs, need_convert)

    TClearBandwidthHistoryReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TClearBandwidthHistoryReq.proto_property, errs, need_convert)
    return self
end

function TClearBandwidthHistoryReq:unpack(_)
    return self.BWUWaveTitle
end

NetworkAdapters.ClearBandwidthHistoryReq = TClearBandwidthHistoryReq

---@class NetworkAdapters.GetBandwidthHistoryRsp
---@field History string
local TGetBandwidthHistoryRsp = {}
TGetBandwidthHistoryRsp.__index = TGetBandwidthHistoryRsp
TGetBandwidthHistoryRsp.group = {}

local function TGetBandwidthHistoryRsp_from_obj(obj)
    return setmetatable(obj, TGetBandwidthHistoryRsp)
end

function TGetBandwidthHistoryRsp.new(History)
    return TGetBandwidthHistoryRsp_from_obj({History = History})
end
---@param obj NetworkAdapters.GetBandwidthHistoryRsp
function TGetBandwidthHistoryRsp:init_from_obj(obj)
    self.History = obj.History
end

function TGetBandwidthHistoryRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetBandwidthHistoryRsp.group)
end

TGetBandwidthHistoryRsp.from_obj = TGetBandwidthHistoryRsp_from_obj

TGetBandwidthHistoryRsp.proto_property = {'History'}

TGetBandwidthHistoryRsp.default = {''}

TGetBandwidthHistoryRsp.struct = {{name = 'History', is_array = false, struct = nil}}

function TGetBandwidthHistoryRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'History', self.History, 'string', false, errs, need_convert)

    TGetBandwidthHistoryRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetBandwidthHistoryRsp.proto_property, errs, need_convert)
    return self
end

function TGetBandwidthHistoryRsp:unpack(_)
    return self.History
end

NetworkAdapters.GetBandwidthHistoryRsp = TGetBandwidthHistoryRsp

---@class NetworkAdapters.GetBandwidthHistoryReq
local TGetBandwidthHistoryReq = {}
TGetBandwidthHistoryReq.__index = TGetBandwidthHistoryReq
TGetBandwidthHistoryReq.group = {}

local function TGetBandwidthHistoryReq_from_obj(obj)
    return setmetatable(obj, TGetBandwidthHistoryReq)
end

function TGetBandwidthHistoryReq.new()
    return TGetBandwidthHistoryReq_from_obj({})
end
---@param obj NetworkAdapters.GetBandwidthHistoryReq
function TGetBandwidthHistoryReq:init_from_obj(obj)

end

function TGetBandwidthHistoryReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetBandwidthHistoryReq.group)
end

TGetBandwidthHistoryReq.from_obj = TGetBandwidthHistoryReq_from_obj

TGetBandwidthHistoryReq.proto_property = {}

TGetBandwidthHistoryReq.default = {}

TGetBandwidthHistoryReq.struct = {}

function TGetBandwidthHistoryReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetBandwidthHistoryReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetBandwidthHistoryReq.proto_property, errs, need_convert)
    return self
end

function TGetBandwidthHistoryReq:unpack(_)
end

NetworkAdapters.GetBandwidthHistoryReq = TGetBandwidthHistoryReq

---@class NetworkAdapters.GetNetworkPortNumRsp
---@field NetworkPortNum integer
local TGetNetworkPortNumRsp = {}
TGetNetworkPortNumRsp.__index = TGetNetworkPortNumRsp
TGetNetworkPortNumRsp.group = {}

local function TGetNetworkPortNumRsp_from_obj(obj)
    return setmetatable(obj, TGetNetworkPortNumRsp)
end

function TGetNetworkPortNumRsp.new(NetworkPortNum)
    return TGetNetworkPortNumRsp_from_obj({NetworkPortNum = NetworkPortNum})
end
---@param obj NetworkAdapters.GetNetworkPortNumRsp
function TGetNetworkPortNumRsp:init_from_obj(obj)
    self.NetworkPortNum = obj.NetworkPortNum
end

function TGetNetworkPortNumRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetNetworkPortNumRsp.group)
end

TGetNetworkPortNumRsp.from_obj = TGetNetworkPortNumRsp_from_obj

TGetNetworkPortNumRsp.proto_property = {'NetworkPortNum'}

TGetNetworkPortNumRsp.default = {0}

TGetNetworkPortNumRsp.struct = {{name = 'NetworkPortNum', is_array = false, struct = nil}}

function TGetNetworkPortNumRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NetworkPortNum', self.NetworkPortNum, 'uint8', false, errs, need_convert)

    TGetNetworkPortNumRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetNetworkPortNumRsp.proto_property, errs, need_convert)
    return self
end

function TGetNetworkPortNumRsp:unpack(_)
    return self.NetworkPortNum
end

NetworkAdapters.GetNetworkPortNumRsp = TGetNetworkPortNumRsp

---@class NetworkAdapters.GetNetworkPortNumReq
local TGetNetworkPortNumReq = {}
TGetNetworkPortNumReq.__index = TGetNetworkPortNumReq
TGetNetworkPortNumReq.group = {}

local function TGetNetworkPortNumReq_from_obj(obj)
    return setmetatable(obj, TGetNetworkPortNumReq)
end

function TGetNetworkPortNumReq.new()
    return TGetNetworkPortNumReq_from_obj({})
end
---@param obj NetworkAdapters.GetNetworkPortNumReq
function TGetNetworkPortNumReq:init_from_obj(obj)

end

function TGetNetworkPortNumReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetNetworkPortNumReq.group)
end

TGetNetworkPortNumReq.from_obj = TGetNetworkPortNumReq_from_obj

TGetNetworkPortNumReq.proto_property = {}

TGetNetworkPortNumReq.default = {}

TGetNetworkPortNumReq.struct = {}

function TGetNetworkPortNumReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetNetworkPortNumReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetNetworkPortNumReq.proto_property, errs, need_convert)
    return self
end

function TGetNetworkPortNumReq:unpack(_)
end

NetworkAdapters.GetNetworkPortNumReq = TGetNetworkPortNumReq

---@class NetworkAdapters.GetNetworkAdapterNumRsp
---@field NetworkAdapterNum integer
local TGetNetworkAdapterNumRsp = {}
TGetNetworkAdapterNumRsp.__index = TGetNetworkAdapterNumRsp
TGetNetworkAdapterNumRsp.group = {}

local function TGetNetworkAdapterNumRsp_from_obj(obj)
    return setmetatable(obj, TGetNetworkAdapterNumRsp)
end

function TGetNetworkAdapterNumRsp.new(NetworkAdapterNum)
    return TGetNetworkAdapterNumRsp_from_obj({NetworkAdapterNum = NetworkAdapterNum})
end
---@param obj NetworkAdapters.GetNetworkAdapterNumRsp
function TGetNetworkAdapterNumRsp:init_from_obj(obj)
    self.NetworkAdapterNum = obj.NetworkAdapterNum
end

function TGetNetworkAdapterNumRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetNetworkAdapterNumRsp.group)
end

TGetNetworkAdapterNumRsp.from_obj = TGetNetworkAdapterNumRsp_from_obj

TGetNetworkAdapterNumRsp.proto_property = {'NetworkAdapterNum'}

TGetNetworkAdapterNumRsp.default = {0}

TGetNetworkAdapterNumRsp.struct = {{name = 'NetworkAdapterNum', is_array = false, struct = nil}}

function TGetNetworkAdapterNumRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NetworkAdapterNum', self.NetworkAdapterNum, 'uint8', false, errs, need_convert)

    TGetNetworkAdapterNumRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetNetworkAdapterNumRsp.proto_property, errs, need_convert)
    return self
end

function TGetNetworkAdapterNumRsp:unpack(_)
    return self.NetworkAdapterNum
end

NetworkAdapters.GetNetworkAdapterNumRsp = TGetNetworkAdapterNumRsp

---@class NetworkAdapters.GetNetworkAdapterNumReq
local TGetNetworkAdapterNumReq = {}
TGetNetworkAdapterNumReq.__index = TGetNetworkAdapterNumReq
TGetNetworkAdapterNumReq.group = {}

local function TGetNetworkAdapterNumReq_from_obj(obj)
    return setmetatable(obj, TGetNetworkAdapterNumReq)
end

function TGetNetworkAdapterNumReq.new()
    return TGetNetworkAdapterNumReq_from_obj({})
end
---@param obj NetworkAdapters.GetNetworkAdapterNumReq
function TGetNetworkAdapterNumReq:init_from_obj(obj)

end

function TGetNetworkAdapterNumReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetNetworkAdapterNumReq.group)
end

TGetNetworkAdapterNumReq.from_obj = TGetNetworkAdapterNumReq_from_obj

TGetNetworkAdapterNumReq.proto_property = {}

TGetNetworkAdapterNumReq.default = {}

TGetNetworkAdapterNumReq.struct = {}

function TGetNetworkAdapterNumReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetNetworkAdapterNumReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetNetworkAdapterNumReq.proto_property, errs, need_convert)
    return self
end

function TGetNetworkAdapterNumReq:unpack(_)
end

NetworkAdapters.GetNetworkAdapterNumReq = TGetNetworkAdapterNumReq

---@class NetworkAdapters.GetPortSpeedRsp
---@field Status integer
---@field Speed integer
local TGetPortSpeedRsp = {}
TGetPortSpeedRsp.__index = TGetPortSpeedRsp
TGetPortSpeedRsp.group = {}

local function TGetPortSpeedRsp_from_obj(obj)
    return setmetatable(obj, TGetPortSpeedRsp)
end

function TGetPortSpeedRsp.new(Status, Speed)
    return TGetPortSpeedRsp_from_obj({Status = Status, Speed = Speed})
end
---@param obj NetworkAdapters.GetPortSpeedRsp
function TGetPortSpeedRsp:init_from_obj(obj)
    self.Status = obj.Status
    self.Speed = obj.Speed
end

function TGetPortSpeedRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPortSpeedRsp.group)
end

TGetPortSpeedRsp.from_obj = TGetPortSpeedRsp_from_obj

TGetPortSpeedRsp.proto_property = {'Status', 'Speed'}

TGetPortSpeedRsp.default = {0, 0}

TGetPortSpeedRsp.struct = {
    {name = 'Status', is_array = false, struct = nil}, {name = 'Speed', is_array = false, struct = nil}
}

function TGetPortSpeedRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Speed', self.Speed, 'uint32', false, errs, need_convert)

    TGetPortSpeedRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPortSpeedRsp.proto_property, errs, need_convert)
    return self
end

function TGetPortSpeedRsp:unpack(_)
    return self.Status, self.Speed
end

NetworkAdapters.GetPortSpeedRsp = TGetPortSpeedRsp

---@class NetworkAdapters.GetPortSpeedReq
---@field Type integer
---@field Slot integer
---@field PortID integer
local TGetPortSpeedReq = {}
TGetPortSpeedReq.__index = TGetPortSpeedReq
TGetPortSpeedReq.group = {}

local function TGetPortSpeedReq_from_obj(obj)
    return setmetatable(obj, TGetPortSpeedReq)
end

function TGetPortSpeedReq.new(Type, Slot, PortID)
    return TGetPortSpeedReq_from_obj({Type = Type, Slot = Slot, PortID = PortID})
end
---@param obj NetworkAdapters.GetPortSpeedReq
function TGetPortSpeedReq:init_from_obj(obj)
    self.Type = obj.Type
    self.Slot = obj.Slot
    self.PortID = obj.PortID
end

function TGetPortSpeedReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPortSpeedReq.group)
end

TGetPortSpeedReq.from_obj = TGetPortSpeedReq_from_obj

TGetPortSpeedReq.proto_property = {'Type', 'Slot', 'PortID'}

TGetPortSpeedReq.default = {0, 0, 0}

TGetPortSpeedReq.struct = {
    {name = 'Type', is_array = false, struct = nil}, {name = 'Slot', is_array = false, struct = nil},
    {name = 'PortID', is_array = false, struct = nil}
}

function TGetPortSpeedReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Slot', self.Slot, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PortID', self.PortID, 'uint8', false, errs, need_convert)

    TGetPortSpeedReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPortSpeedReq.proto_property, errs, need_convert)
    return self
end

function TGetPortSpeedReq:unpack(_)
    return self.Type, self.Slot, self.PortID
end

NetworkAdapters.GetPortSpeedReq = TGetPortSpeedReq

---@class NetworkAdapters.GetNetCardPortNumRsp
---@field NetcardExist integer
---@field PortNum integer
local TGetNetCardPortNumRsp = {}
TGetNetCardPortNumRsp.__index = TGetNetCardPortNumRsp
TGetNetCardPortNumRsp.group = {}

local function TGetNetCardPortNumRsp_from_obj(obj)
    return setmetatable(obj, TGetNetCardPortNumRsp)
end

function TGetNetCardPortNumRsp.new(NetcardExist, PortNum)
    return TGetNetCardPortNumRsp_from_obj({NetcardExist = NetcardExist, PortNum = PortNum})
end
---@param obj NetworkAdapters.GetNetCardPortNumRsp
function TGetNetCardPortNumRsp:init_from_obj(obj)
    self.NetcardExist = obj.NetcardExist
    self.PortNum = obj.PortNum
end

function TGetNetCardPortNumRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetNetCardPortNumRsp.group)
end

TGetNetCardPortNumRsp.from_obj = TGetNetCardPortNumRsp_from_obj

TGetNetCardPortNumRsp.proto_property = {'NetcardExist', 'PortNum'}

TGetNetCardPortNumRsp.default = {0, 0}

TGetNetCardPortNumRsp.struct = {
    {name = 'NetcardExist', is_array = false, struct = nil}, {name = 'PortNum', is_array = false, struct = nil}
}

function TGetNetCardPortNumRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NetcardExist', self.NetcardExist, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'PortNum', self.PortNum, 'uint8', false, errs, need_convert)

    TGetNetCardPortNumRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetNetCardPortNumRsp.proto_property, errs, need_convert)
    return self
end

function TGetNetCardPortNumRsp:unpack(_)
    return self.NetcardExist, self.PortNum
end

NetworkAdapters.GetNetCardPortNumRsp = TGetNetCardPortNumRsp

---@class NetworkAdapters.GetNetCardPortNumReq
---@field Type integer
---@field SystemID integer
---@field SlotID integer
local TGetNetCardPortNumReq = {}
TGetNetCardPortNumReq.__index = TGetNetCardPortNumReq
TGetNetCardPortNumReq.group = {}

local function TGetNetCardPortNumReq_from_obj(obj)
    return setmetatable(obj, TGetNetCardPortNumReq)
end

function TGetNetCardPortNumReq.new(Type, SystemID, SlotID)
    return TGetNetCardPortNumReq_from_obj({Type = Type, SystemID = SystemID, SlotID = SlotID})
end
---@param obj NetworkAdapters.GetNetCardPortNumReq
function TGetNetCardPortNumReq:init_from_obj(obj)
    self.Type = obj.Type
    self.SystemID = obj.SystemID
    self.SlotID = obj.SlotID
end

function TGetNetCardPortNumReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetNetCardPortNumReq.group)
end

TGetNetCardPortNumReq.from_obj = TGetNetCardPortNumReq_from_obj

TGetNetCardPortNumReq.proto_property = {'Type', 'SystemID', 'SlotID'}

TGetNetCardPortNumReq.default = {0, 0, 0}

TGetNetCardPortNumReq.struct = {
    {name = 'Type', is_array = false, struct = nil}, {name = 'SystemID', is_array = false, struct = nil},
    {name = 'SlotID', is_array = false, struct = nil}
}

function TGetNetCardPortNumReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SystemID', self.SystemID, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'SlotID', self.SlotID, 'uint8', false, errs, need_convert)

    TGetNetCardPortNumReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetNetCardPortNumReq.proto_property, errs, need_convert)
    return self
end

function TGetNetCardPortNumReq:unpack(_)
    return self.Type, self.SystemID, self.SlotID
end

NetworkAdapters.GetNetCardPortNumReq = TGetNetCardPortNumReq

NetworkAdapters.interface = mdb.register_interface('bmc.kepler.Systems.NetworkAdapters', {}, {
    GetNetCardPortNum = {'a{ss}yyy', 'yy', TGetNetCardPortNumReq, TGetNetCardPortNumRsp},
    GetPortSpeed = {'a{ss}yyy', 'yu', TGetPortSpeedReq, TGetPortSpeedRsp},
    GetNetworkAdapterNum = {'a{ss}', 'y', TGetNetworkAdapterNumReq, TGetNetworkAdapterNumRsp},
    GetNetworkPortNum = {'a{ss}', 'y', TGetNetworkPortNumReq, TGetNetworkPortNumRsp},
    GetBandwidthHistory = {'a{ss}', 's', TGetBandwidthHistoryReq, TGetBandwidthHistoryRsp},
    ClearBandwidthHistory = {'a{ss}s', '', TClearBandwidthHistoryReq, TClearBandwidthHistoryRsp},
    SetBandwidthThreshold = {'a{ss}y', 'i', TSetBandwidthThresholdReq, TSetBandwidthThresholdRsp}
}, {})

return NetworkAdapters
