-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local NCSI = {}

---@class NCSI.SendCmdOverMCTPRsp
---@field Data string
local TSendCmdOverMCTPRsp = {}
TSendCmdOverMCTPRsp.__index = TSendCmdOverMCTPRsp
TSendCmdOverMCTPRsp.group = {}

local function TSendCmdOverMCTPRsp_from_obj(obj)
    return setmetatable(obj, TSendCmdOverMCTPRsp)
end

function TSendCmdOverMCTPRsp.new(Data)
    return TSendCmdOverMCTPRsp_from_obj({Data = Data})
end
---@param obj NCSI.SendCmdOverMCTPRsp
function TSendCmdOverMCTPRsp:init_from_obj(obj)
    self.Data = obj.Data
end

function TSendCmdOverMCTPRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSendCmdOverMCTPRsp.group)
end

TSendCmdOverMCTPRsp.from_obj = TSendCmdOverMCTPRsp_from_obj

TSendCmdOverMCTPRsp.proto_property = {'Data'}

TSendCmdOverMCTPRsp.default = {''}

TSendCmdOverMCTPRsp.struct = {{name = 'Data', is_array = false, struct = nil}}

function TSendCmdOverMCTPRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TSendCmdOverMCTPRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSendCmdOverMCTPRsp.proto_property, errs, need_convert)
    return self
end

function TSendCmdOverMCTPRsp:unpack(_)
    return self.Data
end

NCSI.SendCmdOverMCTPRsp = TSendCmdOverMCTPRsp

---@class NCSI.SendCmdOverMCTPReq
---@field NodeId string
---@field Command integer
---@field Payload string
local TSendCmdOverMCTPReq = {}
TSendCmdOverMCTPReq.__index = TSendCmdOverMCTPReq
TSendCmdOverMCTPReq.group = {}

local function TSendCmdOverMCTPReq_from_obj(obj)
    return setmetatable(obj, TSendCmdOverMCTPReq)
end

function TSendCmdOverMCTPReq.new(NodeId, Command, Payload)
    return TSendCmdOverMCTPReq_from_obj({NodeId = NodeId, Command = Command, Payload = Payload})
end
---@param obj NCSI.SendCmdOverMCTPReq
function TSendCmdOverMCTPReq:init_from_obj(obj)
    self.NodeId = obj.NodeId
    self.Command = obj.Command
    self.Payload = obj.Payload
end

function TSendCmdOverMCTPReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSendCmdOverMCTPReq.group)
end

TSendCmdOverMCTPReq.from_obj = TSendCmdOverMCTPReq_from_obj

TSendCmdOverMCTPReq.proto_property = {'NodeId', 'Command', 'Payload'}

TSendCmdOverMCTPReq.default = {'', 0, ''}

TSendCmdOverMCTPReq.struct = {
    {name = 'NodeId', is_array = false, struct = nil}, {name = 'Command', is_array = false, struct = nil},
    {name = 'Payload', is_array = false, struct = nil}
}

function TSendCmdOverMCTPReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NodeId', self.NodeId, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Command', self.Command, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Payload', self.Payload, 'string', false, errs, need_convert)

    TSendCmdOverMCTPReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSendCmdOverMCTPReq.proto_property, errs, need_convert)
    return self
end

function TSendCmdOverMCTPReq:unpack(_)
    return self.NodeId, self.Command, self.Payload
end

NCSI.SendCmdOverMCTPReq = TSendCmdOverMCTPReq

NCSI.interface = mdb.register_interface('bmc.kepler.Debug.Systems.NCSI', {}, {
    SendCmdOverMCTP = {'a{ss}sys', 's', TSendCmdOverMCTPReq, TSendCmdOverMCTPRsp}
}, {})

return NCSI
