-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local ContainedPort = {}

---@class ContainedPort.NodeId
---@field NodeId string
local TNodeId = {}
TNodeId.__index = TNodeId
TNodeId.group = {}

local function TNodeId_from_obj(obj)
    return setmetatable(obj, TNodeId)
end

function TNodeId.new(NodeId)
    return TNodeId_from_obj({NodeId = NodeId})
end
---@param obj ContainedPort.NodeId
function TNodeId:init_from_obj(obj)
    self.NodeId = obj.NodeId
end

function TNodeId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNodeId.group)
end

TNodeId.from_obj = TNodeId_from_obj

TNodeId.proto_property = {'NodeId'}

TNodeId.default = {''}

TNodeId.struct = {{name = 'NodeId', is_array = false, struct = nil}}

function TNodeId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'NodeId', self.NodeId, 'string', true, errs, need_convert)

    TNodeId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNodeId.proto_property, errs, need_convert)
    return self
end

function TNodeId:unpack(_)
    return self.NodeId
end

ContainedPort.NodeId = TNodeId

ContainedPort.interface = mdb.register_interface('bmc.kepler.Systems.ContainedPort',
    {NodeId = {'s', nil, true, nil, false}}, {}, {})

return ContainedPort
