--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetNetworkAdapterModelByOCPCard = {}

---@class NetworkAdapterIpmiCmds.GetNetworkAdapterModelByOCPCardReq
---@field ManufacturerId integer
---@field Length integer
---@field Data string
local TGetNetworkAdapterModelByOCPCardReq = {}
TGetNetworkAdapterModelByOCPCardReq.__index = TGetNetworkAdapterModelByOCPCardReq
TGetNetworkAdapterModelByOCPCardReq.group = {}

local function TGetNetworkAdapterModelByOCPCardReq_from_obj(obj)
    return setmetatable(obj, TGetNetworkAdapterModelByOCPCardReq)
end

function TGetNetworkAdapterModelByOCPCardReq.new(ManufacturerId, Length, Data)
    return TGetNetworkAdapterModelByOCPCardReq_from_obj({ManufacturerId = ManufacturerId, Length = Length, Data = Data})
end
---@param obj NetworkAdapterIpmiCmds.GetNetworkAdapterModelByOCPCardReq
function TGetNetworkAdapterModelByOCPCardReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Length = obj.Length
    self.Data = obj.Data
end

function TGetNetworkAdapterModelByOCPCardReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetNetworkAdapterModelByOCPCardReq.group)
end

TGetNetworkAdapterModelByOCPCardReq.from_obj = TGetNetworkAdapterModelByOCPCardReq_from_obj

TGetNetworkAdapterModelByOCPCardReq.proto_property = {'ManufacturerId', 'Length', 'Data'}

TGetNetworkAdapterModelByOCPCardReq.default = {0, 0, ''}

TGetNetworkAdapterModelByOCPCardReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetNetworkAdapterModelByOCPCardReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetNetworkAdapterModelByOCPCardReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetNetworkAdapterModelByOCPCardReq.proto_property, errs, need_convert)
    return self
end

function TGetNetworkAdapterModelByOCPCardReq:unpack(_)
    return self.ManufacturerId, self.Length, self.Data
end

GetNetworkAdapterModelByOCPCard.GetNetworkAdapterModelByOCPCardReq = TGetNetworkAdapterModelByOCPCardReq

---@class NetworkAdapterIpmiCmds.GetNetworkAdapterModelByOCPCardRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Data string
local TGetNetworkAdapterModelByOCPCardRsp = {}
TGetNetworkAdapterModelByOCPCardRsp.__index = TGetNetworkAdapterModelByOCPCardRsp
TGetNetworkAdapterModelByOCPCardRsp.group = {}

local function TGetNetworkAdapterModelByOCPCardRsp_from_obj(obj)
    return setmetatable(obj, TGetNetworkAdapterModelByOCPCardRsp)
end

function TGetNetworkAdapterModelByOCPCardRsp.new(CompletionCode, ManufactureId, Data)
    return TGetNetworkAdapterModelByOCPCardRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Data = Data
    })
end
---@param obj NetworkAdapterIpmiCmds.GetNetworkAdapterModelByOCPCardRsp
function TGetNetworkAdapterModelByOCPCardRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Data = obj.Data
end

function TGetNetworkAdapterModelByOCPCardRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetNetworkAdapterModelByOCPCardRsp.group)
end

TGetNetworkAdapterModelByOCPCardRsp.from_obj = TGetNetworkAdapterModelByOCPCardRsp_from_obj

TGetNetworkAdapterModelByOCPCardRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Data'}

TGetNetworkAdapterModelByOCPCardRsp.default = {0, 0, ''}

TGetNetworkAdapterModelByOCPCardRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetNetworkAdapterModelByOCPCardRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetNetworkAdapterModelByOCPCardRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetNetworkAdapterModelByOCPCardRsp.proto_property, errs, need_convert)
    return self
end

function TGetNetworkAdapterModelByOCPCardRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Data
end

GetNetworkAdapterModelByOCPCard.GetNetworkAdapterModelByOCPCardRsp = TGetNetworkAdapterModelByOCPCardRsp

return GetNetworkAdapterModelByOCPCard
