--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetNetworkAdapterModelByLOM = {}

---@class NetworkAdapterIpmiCmds.GetNetworkAdapterModelByLOMReq
---@field ManufacturerId integer
---@field Length integer
---@field Data string
local TGetNetworkAdapterModelByLOMReq = {}
TGetNetworkAdapterModelByLOMReq.__index = TGetNetworkAdapterModelByLOMReq
TGetNetworkAdapterModelByLOMReq.group = {}

local function TGetNetworkAdapterModelByLOMReq_from_obj(obj)
    return setmetatable(obj, TGetNetworkAdapterModelByLOMReq)
end

function TGetNetworkAdapterModelByLOMReq.new(ManufacturerId, Length, Data)
    return TGetNetworkAdapterModelByLOMReq_from_obj({ManufacturerId = ManufacturerId, Length = Length, Data = Data})
end
---@param obj NetworkAdapterIpmiCmds.GetNetworkAdapterModelByLOMReq
function TGetNetworkAdapterModelByLOMReq:init_from_obj(obj)
    self.ManufacturerId = obj.ManufacturerId
    self.Length = obj.Length
    self.Data = obj.Data
end

function TGetNetworkAdapterModelByLOMReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetNetworkAdapterModelByLOMReq.group)
end

TGetNetworkAdapterModelByLOMReq.from_obj = TGetNetworkAdapterModelByLOMReq_from_obj

TGetNetworkAdapterModelByLOMReq.proto_property = {'ManufacturerId', 'Length', 'Data'}

TGetNetworkAdapterModelByLOMReq.default = {0, 0, ''}

TGetNetworkAdapterModelByLOMReq.struct = {
    {name = 'ManufacturerId', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetNetworkAdapterModelByLOMReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufacturerId', self.ManufacturerId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetNetworkAdapterModelByLOMReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetNetworkAdapterModelByLOMReq.proto_property, errs, need_convert)
    return self
end

function TGetNetworkAdapterModelByLOMReq:unpack(_)
    return self.ManufacturerId, self.Length, self.Data
end

GetNetworkAdapterModelByLOM.GetNetworkAdapterModelByLOMReq = TGetNetworkAdapterModelByLOMReq

---@class NetworkAdapterIpmiCmds.GetNetworkAdapterModelByLOMRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Data string
local TGetNetworkAdapterModelByLOMRsp = {}
TGetNetworkAdapterModelByLOMRsp.__index = TGetNetworkAdapterModelByLOMRsp
TGetNetworkAdapterModelByLOMRsp.group = {}

local function TGetNetworkAdapterModelByLOMRsp_from_obj(obj)
    return setmetatable(obj, TGetNetworkAdapterModelByLOMRsp)
end

function TGetNetworkAdapterModelByLOMRsp.new(CompletionCode, ManufactureId, Data)
    return TGetNetworkAdapterModelByLOMRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Data = Data
    })
end
---@param obj NetworkAdapterIpmiCmds.GetNetworkAdapterModelByLOMRsp
function TGetNetworkAdapterModelByLOMRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Data = obj.Data
end

function TGetNetworkAdapterModelByLOMRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetNetworkAdapterModelByLOMRsp.group)
end

TGetNetworkAdapterModelByLOMRsp.from_obj = TGetNetworkAdapterModelByLOMRsp_from_obj

TGetNetworkAdapterModelByLOMRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Data'}

TGetNetworkAdapterModelByLOMRsp.default = {0, 0, ''}

TGetNetworkAdapterModelByLOMRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Data', is_array = false, struct = nil}
}

function TGetNetworkAdapterModelByLOMRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Data', self.Data, 'string', false, errs, need_convert)

    TGetNetworkAdapterModelByLOMRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetNetworkAdapterModelByLOMRsp.proto_property, errs, need_convert)
    return self
end

function TGetNetworkAdapterModelByLOMRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Data
end

GetNetworkAdapterModelByLOM.GetNetworkAdapterModelByLOMRsp = TGetNetworkAdapterModelByLOMRsp

return GetNetworkAdapterModelByLOM
