-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MVLANs = {}

---@class MVLANs.NetworkPortObjectName
---@field NetworkPortObjectName string
local TNetworkPortObjectName = {}
TNetworkPortObjectName.__index = TNetworkPortObjectName
TNetworkPortObjectName.group = {}

local function TNetworkPortObjectName_from_obj(obj)
    return setmetatable(obj, TNetworkPortObjectName)
end

function TNetworkPortObjectName.new(NetworkPortObjectName)
    return TNetworkPortObjectName_from_obj({NetworkPortObjectName = NetworkPortObjectName or [=[]=]})
end
---@param obj MVLANs.NetworkPortObjectName
function TNetworkPortObjectName:init_from_obj(obj)
    self.NetworkPortObjectName = obj.NetworkPortObjectName or [=[]=]
end

function TNetworkPortObjectName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNetworkPortObjectName.group)
end

TNetworkPortObjectName.from_obj = TNetworkPortObjectName_from_obj

TNetworkPortObjectName.proto_property = {'NetworkPortObjectName'}

TNetworkPortObjectName.default = {''}

TNetworkPortObjectName.struct = {{name = 'NetworkPortObjectName', is_array = false, struct = nil}}

function TNetworkPortObjectName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'NetworkPortObjectName', self.NetworkPortObjectName, 'string', false, errs, need_convert)

    TNetworkPortObjectName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNetworkPortObjectName.proto_property, errs, need_convert)
    return self
end

function TNetworkPortObjectName:unpack(_)
    return self.NetworkPortObjectName
end

MVLANs.NetworkPortObjectName = TNetworkPortObjectName

return MVLANs
