-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MNetworkBondingPort = {}

---@class MNetworkBondingPort.Name
---@field Name string
local TName = {}
TName.__index = TName
TName.group = {}

local function TName_from_obj(obj)
    return setmetatable(obj, TName)
end

function TName.new(Name)
    return TName_from_obj({Name = Name})
end
---@param obj MNetworkBondingPort.Name
function TName:init_from_obj(obj)
    self.Name = obj.Name
end

function TName:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TName.group)
end

TName.from_obj = TName_from_obj

TName.proto_property = {'Name'}

TName.default = {''}

TName.struct = {{name = 'Name', is_array = false, struct = nil}}

function TName:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Name', self.Name, 'string', false, errs, need_convert)

    TName:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TName.proto_property, errs, need_convert)
    return self
end

function TName:unpack(_)
    return self.Name
end

MNetworkBondingPort.Name = TName

---@class MNetworkBondingPort.Id
---@field Id integer
local TId = {}
TId.__index = TId
TId.group = {}

local function TId_from_obj(obj)
    return setmetatable(obj, TId)
end

function TId.new(Id)
    return TId_from_obj({Id = Id})
end
---@param obj MNetworkBondingPort.Id
function TId:init_from_obj(obj)
    self.Id = obj.Id
end

function TId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TId.group)
end

TId.from_obj = TId_from_obj

TId.proto_property = {'Id'}

TId.default = {0}

TId.struct = {{name = 'Id', is_array = false, struct = nil}}

function TId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'uint8', false, errs, need_convert)

    TId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TId.proto_property, errs, need_convert)
    return self
end

function TId:unpack(_)
    return self.Id
end

MNetworkBondingPort.Id = TId

---@class MNetworkBondingPort.TeamId
---@field TeamId string
local TTeamId = {}
TTeamId.__index = TTeamId
TTeamId.group = {}

local function TTeamId_from_obj(obj)
    return setmetatable(obj, TTeamId)
end

function TTeamId.new(TeamId)
    return TTeamId_from_obj({TeamId = TeamId})
end
---@param obj MNetworkBondingPort.TeamId
function TTeamId:init_from_obj(obj)
    self.TeamId = obj.TeamId
end

function TTeamId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TTeamId.group)
end

TTeamId.from_obj = TTeamId_from_obj

TTeamId.proto_property = {'TeamId'}

TTeamId.default = {''}

TTeamId.struct = {{name = 'TeamId', is_array = false, struct = nil}}

function TTeamId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'TeamId', self.TeamId, 'string', false, errs, need_convert)

    TTeamId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TTeamId.proto_property, errs, need_convert)
    return self
end

function TTeamId:unpack(_)
    return self.TeamId
end

MNetworkBondingPort.TeamId = TTeamId

return MNetworkBondingPort
