-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class compute.SetCPUPredictiveFaultRsp
---@field Code integer
local TSetCPUPredictiveFaultRsp = {}
TSetCPUPredictiveFaultRsp.__index = TSetCPUPredictiveFaultRsp
TSetCPUPredictiveFaultRsp.group = {}

local function TSetCPUPredictiveFaultRsp_from_obj(obj)
    return setmetatable(obj, TSetCPUPredictiveFaultRsp)
end

function TSetCPUPredictiveFaultRsp.new(Code)
    return TSetCPUPredictiveFaultRsp_from_obj({Code = Code})
end
---@param obj compute.SetCPUPredictiveFaultRsp
function TSetCPUPredictiveFaultRsp:init_from_obj(obj)
    self.Code = obj.Code
end

function TSetCPUPredictiveFaultRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCPUPredictiveFaultRsp.group)
end

TSetCPUPredictiveFaultRsp.from_obj = TSetCPUPredictiveFaultRsp_from_obj

TSetCPUPredictiveFaultRsp.proto_property = {'Code'}

TSetCPUPredictiveFaultRsp.default = {0}

TSetCPUPredictiveFaultRsp.struct = {{name = 'Code', is_array = false, struct = nil}}

function TSetCPUPredictiveFaultRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Code', self.Code, 'uint8', false, errs)

    TSetCPUPredictiveFaultRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCPUPredictiveFaultRsp.proto_property, errs)
    return self
end

function TSetCPUPredictiveFaultRsp:unpack(_)
    return self.Code
end

msg.SetCPUPredictiveFaultRsp = TSetCPUPredictiveFaultRsp

---@class compute.SetCPUPredictiveFaultReq
---@field SystemId integer
---@field LogicalId integer
---@field State integer
local TSetCPUPredictiveFaultReq = {}
TSetCPUPredictiveFaultReq.__index = TSetCPUPredictiveFaultReq
TSetCPUPredictiveFaultReq.group = {}

local function TSetCPUPredictiveFaultReq_from_obj(obj)
    return setmetatable(obj, TSetCPUPredictiveFaultReq)
end

function TSetCPUPredictiveFaultReq.new(SystemId, LogicalId, State)
    return TSetCPUPredictiveFaultReq_from_obj({
        SystemId = SystemId,
        LogicalId = LogicalId,
        State = State
    })
end
---@param obj compute.SetCPUPredictiveFaultReq
function TSetCPUPredictiveFaultReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.LogicalId = obj.LogicalId
    self.State = obj.State
end

function TSetCPUPredictiveFaultReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCPUPredictiveFaultReq.group)
end

TSetCPUPredictiveFaultReq.from_obj = TSetCPUPredictiveFaultReq_from_obj

TSetCPUPredictiveFaultReq.proto_property = {'SystemId', 'LogicalId', 'State'}

TSetCPUPredictiveFaultReq.default = {0, 0, 0}

TSetCPUPredictiveFaultReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'LogicalId', is_array = false, struct = nil},
    {name = 'State', is_array = false, struct = nil}
}

function TSetCPUPredictiveFaultReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'uint8', false, errs)
    validate.Required(prefix .. 'LogicalId', self.LogicalId, 'uint8', false, errs)
    validate.Required(prefix .. 'State', self.State, 'uint8', false, errs)

    TSetCPUPredictiveFaultReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCPUPredictiveFaultReq.proto_property, errs)
    return self
end

function TSetCPUPredictiveFaultReq:unpack(_)
    return self.SystemId, self.LogicalId, self.State
end

msg.SetCPUPredictiveFaultReq = TSetCPUPredictiveFaultReq

---@class compute.SetCPUDiagnosticFaultRsp
---@field Code integer
local TSetCPUDiagnosticFaultRsp = {}
TSetCPUDiagnosticFaultRsp.__index = TSetCPUDiagnosticFaultRsp
TSetCPUDiagnosticFaultRsp.group = {}

local function TSetCPUDiagnosticFaultRsp_from_obj(obj)
    return setmetatable(obj, TSetCPUDiagnosticFaultRsp)
end

function TSetCPUDiagnosticFaultRsp.new(Code)
    return TSetCPUDiagnosticFaultRsp_from_obj({Code = Code})
end
---@param obj compute.SetCPUDiagnosticFaultRsp
function TSetCPUDiagnosticFaultRsp:init_from_obj(obj)
    self.Code = obj.Code
end

function TSetCPUDiagnosticFaultRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCPUDiagnosticFaultRsp.group)
end

TSetCPUDiagnosticFaultRsp.from_obj = TSetCPUDiagnosticFaultRsp_from_obj

TSetCPUDiagnosticFaultRsp.proto_property = {'Code'}

TSetCPUDiagnosticFaultRsp.default = {0}

TSetCPUDiagnosticFaultRsp.struct = {{name = 'Code', is_array = false, struct = nil}}

function TSetCPUDiagnosticFaultRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Code', self.Code, 'uint8', false, errs)

    TSetCPUDiagnosticFaultRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCPUDiagnosticFaultRsp.proto_property, errs)
    return self
end

function TSetCPUDiagnosticFaultRsp:unpack(_)
    return self.Code
end

msg.SetCPUDiagnosticFaultRsp = TSetCPUDiagnosticFaultRsp

---@class compute.SetCPUDiagnosticFaultReq
---@field SystemId integer
---@field LogicalId integer
---@field State integer
local TSetCPUDiagnosticFaultReq = {}
TSetCPUDiagnosticFaultReq.__index = TSetCPUDiagnosticFaultReq
TSetCPUDiagnosticFaultReq.group = {}

local function TSetCPUDiagnosticFaultReq_from_obj(obj)
    return setmetatable(obj, TSetCPUDiagnosticFaultReq)
end

function TSetCPUDiagnosticFaultReq.new(SystemId, LogicalId, State)
    return TSetCPUDiagnosticFaultReq_from_obj({
        SystemId = SystemId,
        LogicalId = LogicalId,
        State = State
    })
end
---@param obj compute.SetCPUDiagnosticFaultReq
function TSetCPUDiagnosticFaultReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.LogicalId = obj.LogicalId
    self.State = obj.State
end

function TSetCPUDiagnosticFaultReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCPUDiagnosticFaultReq.group)
end

TSetCPUDiagnosticFaultReq.from_obj = TSetCPUDiagnosticFaultReq_from_obj

TSetCPUDiagnosticFaultReq.proto_property = {'SystemId', 'LogicalId', 'State'}

TSetCPUDiagnosticFaultReq.default = {0, 0, 0}

TSetCPUDiagnosticFaultReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'LogicalId', is_array = false, struct = nil},
    {name = 'State', is_array = false, struct = nil}
}

function TSetCPUDiagnosticFaultReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'uint8', false, errs)
    validate.Required(prefix .. 'LogicalId', self.LogicalId, 'uint8', false, errs)
    validate.Required(prefix .. 'State', self.State, 'uint8', false, errs)

    TSetCPUDiagnosticFaultReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCPUDiagnosticFaultReq.proto_property, errs)
    return self
end

function TSetCPUDiagnosticFaultReq:unpack(_)
    return self.SystemId, self.LogicalId, self.State
end

msg.SetCPUDiagnosticFaultReq = TSetCPUDiagnosticFaultReq

---@class compute.GetProcessorInfoRsp
---@field PhysicalId integer
---@field LogicalId integer
---@field Presence boolean
---@field InstructionSet string
---@field Architecture string
---@field Manufacturer string
---@field MaxSpeedMHz integer
---@field CurrentSpeedMHz integer
---@field Model string
---@field PartNumber string
---@field ProcessorID integer
---@field ProcessorType string
---@field SN string
---@field SocketDesignation string
---@field TotalCores integer
---@field TotalEnabledCores integer
---@field TotalThreads integer
---@field L1Cache integer
---@field L2Cache integer
---@field L3Cache integer
---@field Characteristics string
local TGetProcessorInfoRsp = {}
TGetProcessorInfoRsp.__index = TGetProcessorInfoRsp
TGetProcessorInfoRsp.group = {}

local function TGetProcessorInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetProcessorInfoRsp)
end

function TGetProcessorInfoRsp.new(PhysicalId, LogicalId, Presence, InstructionSet, Architecture,
    Manufacturer, MaxSpeedMHz, CurrentSpeedMHz, Model, PartNumber, ProcessorID, ProcessorType, SN,
    SocketDesignation, TotalCores, TotalEnabledCores, TotalThreads, L1Cache, L2Cache, L3Cache,
    Characteristics)
    return TGetProcessorInfoRsp_from_obj({
        PhysicalId = PhysicalId,
        LogicalId = LogicalId,
        Presence = Presence,
        InstructionSet = InstructionSet,
        Architecture = Architecture,
        Manufacturer = Manufacturer,
        MaxSpeedMHz = MaxSpeedMHz,
        CurrentSpeedMHz = CurrentSpeedMHz,
        Model = Model,
        PartNumber = PartNumber,
        ProcessorID = ProcessorID,
        ProcessorType = ProcessorType,
        SN = SN,
        SocketDesignation = SocketDesignation,
        TotalCores = TotalCores,
        TotalEnabledCores = TotalEnabledCores,
        TotalThreads = TotalThreads,
        L1Cache = L1Cache,
        L2Cache = L2Cache,
        L3Cache = L3Cache,
        Characteristics = Characteristics
    })
end
---@param obj compute.GetProcessorInfoRsp
function TGetProcessorInfoRsp:init_from_obj(obj)
    self.PhysicalId = obj.PhysicalId
    self.LogicalId = obj.LogicalId
    self.Presence = obj.Presence
    self.InstructionSet = obj.InstructionSet
    self.Architecture = obj.Architecture
    self.Manufacturer = obj.Manufacturer
    self.MaxSpeedMHz = obj.MaxSpeedMHz
    self.CurrentSpeedMHz = obj.CurrentSpeedMHz
    self.Model = obj.Model
    self.PartNumber = obj.PartNumber
    self.ProcessorID = obj.ProcessorID
    self.ProcessorType = obj.ProcessorType
    self.SN = obj.SN
    self.SocketDesignation = obj.SocketDesignation
    self.TotalCores = obj.TotalCores
    self.TotalEnabledCores = obj.TotalEnabledCores
    self.TotalThreads = obj.TotalThreads
    self.L1Cache = obj.L1Cache
    self.L2Cache = obj.L2Cache
    self.L3Cache = obj.L3Cache
    self.Characteristics = obj.Characteristics
end

function TGetProcessorInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetProcessorInfoRsp.group)
end

TGetProcessorInfoRsp.from_obj = TGetProcessorInfoRsp_from_obj

TGetProcessorInfoRsp.proto_property = {
    'PhysicalId', 'LogicalId', 'Presence', 'InstructionSet', 'Architecture', 'Manufacturer',
    'MaxSpeedMHz', 'CurrentSpeedMHz', 'Model', 'PartNumber', 'ProcessorID', 'ProcessorType', 'SN',
    'SocketDesignation', 'TotalCores', 'TotalEnabledCores', 'TotalThreads', 'L1Cache', 'L2Cache',
    'L3Cache', 'Characteristics'
}

TGetProcessorInfoRsp.default = {
    0, 0, false, '', '', '', 0, 0, '', '', 0, '', '', '', 0, 0, 0, 0, 0, 0, ''
}

TGetProcessorInfoRsp.struct = {
    {name = 'PhysicalId', is_array = false, struct = nil},
    {name = 'LogicalId', is_array = false, struct = nil},
    {name = 'Presence', is_array = false, struct = nil},
    {name = 'InstructionSet', is_array = false, struct = nil},
    {name = 'Architecture', is_array = false, struct = nil},
    {name = 'Manufacturer', is_array = false, struct = nil},
    {name = 'MaxSpeedMHz', is_array = false, struct = nil},
    {name = 'CurrentSpeedMHz', is_array = false, struct = nil},
    {name = 'Model', is_array = false, struct = nil},
    {name = 'PartNumber', is_array = false, struct = nil},
    {name = 'ProcessorID', is_array = false, struct = nil},
    {name = 'ProcessorType', is_array = false, struct = nil},
    {name = 'SN', is_array = false, struct = nil},
    {name = 'SocketDesignation', is_array = false, struct = nil},
    {name = 'TotalCores', is_array = false, struct = nil},
    {name = 'TotalEnabledCores', is_array = false, struct = nil},
    {name = 'TotalThreads', is_array = false, struct = nil},
    {name = 'L1Cache', is_array = false, struct = nil},
    {name = 'L2Cache', is_array = false, struct = nil},
    {name = 'L3Cache', is_array = false, struct = nil},
    {name = 'Characteristics', is_array = false, struct = nil}
}

function TGetProcessorInfoRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'PhysicalId', self.PhysicalId, 'uint8', false, errs)
    validate.Required(prefix .. 'LogicalId', self.LogicalId, 'uint8', false, errs)
    validate.Required(prefix .. 'Presence', self.Presence, 'bool', false, errs)
    validate.Required(prefix .. 'InstructionSet', self.InstructionSet, 'string', false, errs)
    validate.Required(prefix .. 'Architecture', self.Architecture, 'string', false, errs)
    validate.Required(prefix .. 'Manufacturer', self.Manufacturer, 'string', false, errs)
    validate.Required(prefix .. 'MaxSpeedMHz', self.MaxSpeedMHz, 'uint32', false, errs)
    validate.Required(prefix .. 'CurrentSpeedMHz', self.CurrentSpeedMHz, 'uint32', false, errs)
    validate.Required(prefix .. 'Model', self.Model, 'string', false, errs)
    validate.Required(prefix .. 'PartNumber', self.PartNumber, 'string', false, errs)
    validate.Required(prefix .. 'ProcessorID', self.ProcessorID, 'uint64', false, errs)
    validate.Required(prefix .. 'ProcessorType', self.ProcessorType, 'string', false, errs)
    validate.Required(prefix .. 'SN', self.SN, 'string', false, errs)
    validate.Required(prefix .. 'SocketDesignation', self.SocketDesignation, 'string', false, errs)
    validate.Required(prefix .. 'TotalCores', self.TotalCores, 'uint32', false, errs)
    validate.Required(prefix .. 'TotalEnabledCores', self.TotalEnabledCores, 'uint32', false, errs)
    validate.Required(prefix .. 'TotalThreads', self.TotalThreads, 'uint32', false, errs)
    validate.Required(prefix .. 'L1Cache', self.L1Cache, 'uint32', false, errs)
    validate.Required(prefix .. 'L2Cache', self.L2Cache, 'uint32', false, errs)
    validate.Required(prefix .. 'L3Cache', self.L3Cache, 'uint32', false, errs)
    validate.Required(prefix .. 'Characteristics', self.Characteristics, 'string', false, errs)

    TGetProcessorInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetProcessorInfoRsp.proto_property, errs)
    return self
end

function TGetProcessorInfoRsp:unpack(_)
    return self.PhysicalId, self.LogicalId, self.Presence, self.InstructionSet, self.Architecture,
        self.Manufacturer, self.MaxSpeedMHz, self.CurrentSpeedMHz, self.Model, self.PartNumber,
        self.ProcessorID, self.ProcessorType, self.SN, self.SocketDesignation, self.TotalCores,
        self.TotalEnabledCores, self.TotalThreads, self.L1Cache, self.L2Cache, self.L3Cache,
        self.Characteristics
end

msg.GetProcessorInfoRsp = TGetProcessorInfoRsp

---@class compute.GetProcessorInfoReq
---@field PhysicalId integer
local TGetProcessorInfoReq = {}
TGetProcessorInfoReq.__index = TGetProcessorInfoReq
TGetProcessorInfoReq.group = {}

local function TGetProcessorInfoReq_from_obj(obj)
    return setmetatable(obj, TGetProcessorInfoReq)
end

function TGetProcessorInfoReq.new(PhysicalId)
    return TGetProcessorInfoReq_from_obj({PhysicalId = PhysicalId})
end
---@param obj compute.GetProcessorInfoReq
function TGetProcessorInfoReq:init_from_obj(obj)
    self.PhysicalId = obj.PhysicalId
end

function TGetProcessorInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetProcessorInfoReq.group)
end

TGetProcessorInfoReq.from_obj = TGetProcessorInfoReq_from_obj

TGetProcessorInfoReq.proto_property = {'PhysicalId'}

TGetProcessorInfoReq.default = {0}

TGetProcessorInfoReq.struct = {{name = 'PhysicalId', is_array = false, struct = nil}}

function TGetProcessorInfoReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'PhysicalId', self.PhysicalId, 'uint8', false, errs)

    TGetProcessorInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetProcessorInfoReq.proto_property, errs)
    return self
end

function TGetProcessorInfoReq:unpack(_)
    return self.PhysicalId
end

msg.GetProcessorInfoReq = TGetProcessorInfoReq

---@class compute.GetProcessorNumRsp
---@field MaxNum integer
---@field CurrentNum integer
local TGetProcessorNumRsp = {}
TGetProcessorNumRsp.__index = TGetProcessorNumRsp
TGetProcessorNumRsp.group = {}

local function TGetProcessorNumRsp_from_obj(obj)
    return setmetatable(obj, TGetProcessorNumRsp)
end

function TGetProcessorNumRsp.new(MaxNum, CurrentNum)
    return TGetProcessorNumRsp_from_obj({MaxNum = MaxNum, CurrentNum = CurrentNum})
end
---@param obj compute.GetProcessorNumRsp
function TGetProcessorNumRsp:init_from_obj(obj)
    self.MaxNum = obj.MaxNum
    self.CurrentNum = obj.CurrentNum
end

function TGetProcessorNumRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetProcessorNumRsp.group)
end

TGetProcessorNumRsp.from_obj = TGetProcessorNumRsp_from_obj

TGetProcessorNumRsp.proto_property = {'MaxNum', 'CurrentNum'}

TGetProcessorNumRsp.default = {0, 0}

TGetProcessorNumRsp.struct = {
    {name = 'MaxNum', is_array = false, struct = nil},
    {name = 'CurrentNum', is_array = false, struct = nil}
}

function TGetProcessorNumRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'MaxNum', self.MaxNum, 'uint32', false, errs)
    validate.Required(prefix .. 'CurrentNum', self.CurrentNum, 'uint32', false, errs)

    TGetProcessorNumRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetProcessorNumRsp.proto_property, errs)
    return self
end

function TGetProcessorNumRsp:unpack(_)
    return self.MaxNum, self.CurrentNum
end

msg.GetProcessorNumRsp = TGetProcessorNumRsp

---@class compute.GetProcessorNumReq
---@field ProcessorId integer
local TGetProcessorNumReq = {}
TGetProcessorNumReq.__index = TGetProcessorNumReq
TGetProcessorNumReq.group = {}

local function TGetProcessorNumReq_from_obj(obj)
    return setmetatable(obj, TGetProcessorNumReq)
end

function TGetProcessorNumReq.new(ProcessorId)
    return TGetProcessorNumReq_from_obj({ProcessorId = ProcessorId})
end
---@param obj compute.GetProcessorNumReq
function TGetProcessorNumReq:init_from_obj(obj)
    self.ProcessorId = obj.ProcessorId
end

function TGetProcessorNumReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetProcessorNumReq.group)
end

TGetProcessorNumReq.from_obj = TGetProcessorNumReq_from_obj

TGetProcessorNumReq.proto_property = {'ProcessorId'}

TGetProcessorNumReq.default = {0}

TGetProcessorNumReq.struct = {{name = 'ProcessorId', is_array = false, struct = nil}}

function TGetProcessorNumReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'ProcessorId', self.ProcessorId, 'uint8', false, errs)

    TGetProcessorNumReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetProcessorNumReq.proto_property, errs)
    return self
end

function TGetProcessorNumReq:unpack(_)
    return self.ProcessorId
end

msg.GetProcessorNumReq = TGetProcessorNumReq

---@class compute.SetMemoryPredictiveFaultRsp
---@field Code integer
local TSetMemoryPredictiveFaultRsp = {}
TSetMemoryPredictiveFaultRsp.__index = TSetMemoryPredictiveFaultRsp
TSetMemoryPredictiveFaultRsp.group = {}

local function TSetMemoryPredictiveFaultRsp_from_obj(obj)
    return setmetatable(obj, TSetMemoryPredictiveFaultRsp)
end

function TSetMemoryPredictiveFaultRsp.new(Code)
    return TSetMemoryPredictiveFaultRsp_from_obj({Code = Code})
end
---@param obj compute.SetMemoryPredictiveFaultRsp
function TSetMemoryPredictiveFaultRsp:init_from_obj(obj)
    self.Code = obj.Code
end

function TSetMemoryPredictiveFaultRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetMemoryPredictiveFaultRsp.group)
end

TSetMemoryPredictiveFaultRsp.from_obj = TSetMemoryPredictiveFaultRsp_from_obj

TSetMemoryPredictiveFaultRsp.proto_property = {'Code'}

TSetMemoryPredictiveFaultRsp.default = {0}

TSetMemoryPredictiveFaultRsp.struct = {{name = 'Code', is_array = false, struct = nil}}

function TSetMemoryPredictiveFaultRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Code', self.Code, 'uint8', false, errs)

    TSetMemoryPredictiveFaultRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetMemoryPredictiveFaultRsp.proto_property, errs)
    return self
end

function TSetMemoryPredictiveFaultRsp:unpack(_)
    return self.Code
end

msg.SetMemoryPredictiveFaultRsp = TSetMemoryPredictiveFaultRsp

---@class compute.SetMemoryPredictiveFaultReq
---@field SystemId integer
---@field CpuId integer
---@field NodeId integer
---@field LogicalChannelId integer
---@field DimmId integer
---@field State integer
local TSetMemoryPredictiveFaultReq = {}
TSetMemoryPredictiveFaultReq.__index = TSetMemoryPredictiveFaultReq
TSetMemoryPredictiveFaultReq.group = {}

local function TSetMemoryPredictiveFaultReq_from_obj(obj)
    return setmetatable(obj, TSetMemoryPredictiveFaultReq)
end

function TSetMemoryPredictiveFaultReq.new(SystemId, CpuId, NodeId, LogicalChannelId, DimmId, State)
    return TSetMemoryPredictiveFaultReq_from_obj({
        SystemId = SystemId,
        CpuId = CpuId,
        NodeId = NodeId,
        LogicalChannelId = LogicalChannelId,
        DimmId = DimmId,
        State = State
    })
end
---@param obj compute.SetMemoryPredictiveFaultReq
function TSetMemoryPredictiveFaultReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.CpuId = obj.CpuId
    self.NodeId = obj.NodeId
    self.LogicalChannelId = obj.LogicalChannelId
    self.DimmId = obj.DimmId
    self.State = obj.State
end

function TSetMemoryPredictiveFaultReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetMemoryPredictiveFaultReq.group)
end

TSetMemoryPredictiveFaultReq.from_obj = TSetMemoryPredictiveFaultReq_from_obj

TSetMemoryPredictiveFaultReq.proto_property = {
    'SystemId', 'CpuId', 'NodeId', 'LogicalChannelId', 'DimmId', 'State'
}

TSetMemoryPredictiveFaultReq.default = {0, 0, 0, 0, 0, 0}

TSetMemoryPredictiveFaultReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'CpuId', is_array = false, struct = nil},
    {name = 'NodeId', is_array = false, struct = nil},
    {name = 'LogicalChannelId', is_array = false, struct = nil},
    {name = 'DimmId', is_array = false, struct = nil},
    {name = 'State', is_array = false, struct = nil}
}

function TSetMemoryPredictiveFaultReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'uint8', false, errs)
    validate.Required(prefix .. 'CpuId', self.CpuId, 'uint8', false, errs)
    validate.Required(prefix .. 'NodeId', self.NodeId, 'uint8', false, errs)
    validate.Required(prefix .. 'LogicalChannelId', self.LogicalChannelId, 'uint8', false, errs)
    validate.Required(prefix .. 'DimmId', self.DimmId, 'uint8', false, errs)
    validate.Required(prefix .. 'State', self.State, 'uint8', false, errs)

    TSetMemoryPredictiveFaultReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetMemoryPredictiveFaultReq.proto_property, errs)
    return self
end

function TSetMemoryPredictiveFaultReq:unpack(_)
    return self.SystemId, self.CpuId, self.NodeId, self.LogicalChannelId, self.DimmId, self.State
end

msg.SetMemoryPredictiveFaultReq = TSetMemoryPredictiveFaultReq

---@class compute.SetMemoryDiagnosticFaultRsp
---@field Code integer
local TSetMemoryDiagnosticFaultRsp = {}
TSetMemoryDiagnosticFaultRsp.__index = TSetMemoryDiagnosticFaultRsp
TSetMemoryDiagnosticFaultRsp.group = {}

local function TSetMemoryDiagnosticFaultRsp_from_obj(obj)
    return setmetatable(obj, TSetMemoryDiagnosticFaultRsp)
end

function TSetMemoryDiagnosticFaultRsp.new(Code)
    return TSetMemoryDiagnosticFaultRsp_from_obj({Code = Code})
end
---@param obj compute.SetMemoryDiagnosticFaultRsp
function TSetMemoryDiagnosticFaultRsp:init_from_obj(obj)
    self.Code = obj.Code
end

function TSetMemoryDiagnosticFaultRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetMemoryDiagnosticFaultRsp.group)
end

TSetMemoryDiagnosticFaultRsp.from_obj = TSetMemoryDiagnosticFaultRsp_from_obj

TSetMemoryDiagnosticFaultRsp.proto_property = {'Code'}

TSetMemoryDiagnosticFaultRsp.default = {0}

TSetMemoryDiagnosticFaultRsp.struct = {{name = 'Code', is_array = false, struct = nil}}

function TSetMemoryDiagnosticFaultRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Code', self.Code, 'uint8', false, errs)

    TSetMemoryDiagnosticFaultRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetMemoryDiagnosticFaultRsp.proto_property, errs)
    return self
end

function TSetMemoryDiagnosticFaultRsp:unpack(_)
    return self.Code
end

msg.SetMemoryDiagnosticFaultRsp = TSetMemoryDiagnosticFaultRsp

---@class compute.SetMemoryDiagnosticFaultReq
---@field SystemId integer
---@field CpuId integer
---@field NodeId integer
---@field LogicalChannelId integer
---@field DimmId integer
---@field State integer
local TSetMemoryDiagnosticFaultReq = {}
TSetMemoryDiagnosticFaultReq.__index = TSetMemoryDiagnosticFaultReq
TSetMemoryDiagnosticFaultReq.group = {}

local function TSetMemoryDiagnosticFaultReq_from_obj(obj)
    return setmetatable(obj, TSetMemoryDiagnosticFaultReq)
end

function TSetMemoryDiagnosticFaultReq.new(SystemId, CpuId, NodeId, LogicalChannelId, DimmId, State)
    return TSetMemoryDiagnosticFaultReq_from_obj({
        SystemId = SystemId,
        CpuId = CpuId,
        NodeId = NodeId,
        LogicalChannelId = LogicalChannelId,
        DimmId = DimmId,
        State = State
    })
end
---@param obj compute.SetMemoryDiagnosticFaultReq
function TSetMemoryDiagnosticFaultReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.CpuId = obj.CpuId
    self.NodeId = obj.NodeId
    self.LogicalChannelId = obj.LogicalChannelId
    self.DimmId = obj.DimmId
    self.State = obj.State
end

function TSetMemoryDiagnosticFaultReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetMemoryDiagnosticFaultReq.group)
end

TSetMemoryDiagnosticFaultReq.from_obj = TSetMemoryDiagnosticFaultReq_from_obj

TSetMemoryDiagnosticFaultReq.proto_property = {
    'SystemId', 'CpuId', 'NodeId', 'LogicalChannelId', 'DimmId', 'State'
}

TSetMemoryDiagnosticFaultReq.default = {0, 0, 0, 0, 0, 0}

TSetMemoryDiagnosticFaultReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'CpuId', is_array = false, struct = nil},
    {name = 'NodeId', is_array = false, struct = nil},
    {name = 'LogicalChannelId', is_array = false, struct = nil},
    {name = 'DimmId', is_array = false, struct = nil},
    {name = 'State', is_array = false, struct = nil}
}

function TSetMemoryDiagnosticFaultReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'uint8', false, errs)
    validate.Required(prefix .. 'CpuId', self.CpuId, 'uint8', false, errs)
    validate.Required(prefix .. 'NodeId', self.NodeId, 'uint8', false, errs)
    validate.Required(prefix .. 'LogicalChannelId', self.LogicalChannelId, 'uint8', false, errs)
    validate.Required(prefix .. 'DimmId', self.DimmId, 'uint8', false, errs)
    validate.Required(prefix .. 'State', self.State, 'uint8', false, errs)

    TSetMemoryDiagnosticFaultReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetMemoryDiagnosticFaultReq.proto_property, errs)
    return self
end

function TSetMemoryDiagnosticFaultReq:unpack(_)
    return self.SystemId, self.CpuId, self.NodeId, self.LogicalChannelId, self.DimmId, self.State
end

msg.SetMemoryDiagnosticFaultReq = TSetMemoryDiagnosticFaultReq

---@class compute.GetMemoryInfoRsp
---@field Name string
---@field DimmName string
---@field Presence boolean
---@field CpuId integer
---@field NodeId integer
---@field ChannelId integer
---@field DimmId integer
---@field AllowedSpeedsMHz integer
---@field BaseModuleType string
---@field CapacityMiB integer
---@field DataWidthBits integer
---@field FirmwareRevision string
---@field Manufacturer string
---@field MemoryDeviceType string
---@field MemorySubsystemControllerManufacturerID string
---@field MemorySubsystemControllerProductID string
---@field MemoryType string
---@field OperatingSpeedMhz integer
---@field PartNumber string
---@field RankCount integer
---@field SerialNumber string
---@field MinVoltageMillivolt integer
---@field Position string
local TGetMemoryInfoRsp = {}
TGetMemoryInfoRsp.__index = TGetMemoryInfoRsp
TGetMemoryInfoRsp.group = {}

local function TGetMemoryInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetMemoryInfoRsp)
end

function TGetMemoryInfoRsp.new(Name, DimmName, Presence, CpuId, NodeId, ChannelId, DimmId,
    AllowedSpeedsMHz, BaseModuleType, CapacityMiB, DataWidthBits, FirmwareRevision, Manufacturer,
    MemoryDeviceType, MemorySubsystemControllerManufacturerID, MemorySubsystemControllerProductID,
    MemoryType, OperatingSpeedMhz, PartNumber, RankCount, SerialNumber, MinVoltageMillivolt,
    Position)
    return TGetMemoryInfoRsp_from_obj({
        Name = Name,
        DimmName = DimmName,
        Presence = Presence,
        CpuId = CpuId,
        NodeId = NodeId,
        ChannelId = ChannelId,
        DimmId = DimmId,
        AllowedSpeedsMHz = AllowedSpeedsMHz,
        BaseModuleType = BaseModuleType,
        CapacityMiB = CapacityMiB,
        DataWidthBits = DataWidthBits,
        FirmwareRevision = FirmwareRevision,
        Manufacturer = Manufacturer,
        MemoryDeviceType = MemoryDeviceType,
        MemorySubsystemControllerManufacturerID = MemorySubsystemControllerManufacturerID,
        MemorySubsystemControllerProductID = MemorySubsystemControllerProductID,
        MemoryType = MemoryType,
        OperatingSpeedMhz = OperatingSpeedMhz,
        PartNumber = PartNumber,
        RankCount = RankCount,
        SerialNumber = SerialNumber,
        MinVoltageMillivolt = MinVoltageMillivolt,
        Position = Position
    })
end
---@param obj compute.GetMemoryInfoRsp
function TGetMemoryInfoRsp:init_from_obj(obj)
    self.Name = obj.Name
    self.DimmName = obj.DimmName
    self.Presence = obj.Presence
    self.CpuId = obj.CpuId
    self.NodeId = obj.NodeId
    self.ChannelId = obj.ChannelId
    self.DimmId = obj.DimmId
    self.AllowedSpeedsMHz = obj.AllowedSpeedsMHz
    self.BaseModuleType = obj.BaseModuleType
    self.CapacityMiB = obj.CapacityMiB
    self.DataWidthBits = obj.DataWidthBits
    self.FirmwareRevision = obj.FirmwareRevision
    self.Manufacturer = obj.Manufacturer
    self.MemoryDeviceType = obj.MemoryDeviceType
    self.MemorySubsystemControllerManufacturerID = obj.MemorySubsystemControllerManufacturerID
    self.MemorySubsystemControllerProductID = obj.MemorySubsystemControllerProductID
    self.MemoryType = obj.MemoryType
    self.OperatingSpeedMhz = obj.OperatingSpeedMhz
    self.PartNumber = obj.PartNumber
    self.RankCount = obj.RankCount
    self.SerialNumber = obj.SerialNumber
    self.MinVoltageMillivolt = obj.MinVoltageMillivolt
    self.Position = obj.Position
end

function TGetMemoryInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetMemoryInfoRsp.group)
end

TGetMemoryInfoRsp.from_obj = TGetMemoryInfoRsp_from_obj

TGetMemoryInfoRsp.proto_property = {
    'Name', 'DimmName', 'Presence', 'CpuId', 'NodeId', 'ChannelId', 'DimmId', 'AllowedSpeedsMHz',
    'BaseModuleType', 'CapacityMiB', 'DataWidthBits', 'FirmwareRevision', 'Manufacturer',
    'MemoryDeviceType', 'MemorySubsystemControllerManufacturerID',
    'MemorySubsystemControllerProductID', 'MemoryType', 'OperatingSpeedMhz', 'PartNumber',
    'RankCount', 'SerialNumber', 'MinVoltageMillivolt', 'Position'
}

TGetMemoryInfoRsp.default = {
    '', '', false, 0, 0, 0, 0, 0, '', 0, 0, '', '', '', '', '', '', 0, '', 0, '', 0, ''
}

TGetMemoryInfoRsp.struct = {
    {name = 'Name', is_array = false, struct = nil},
    {name = 'DimmName', is_array = false, struct = nil},
    {name = 'Presence', is_array = false, struct = nil},
    {name = 'CpuId', is_array = false, struct = nil},
    {name = 'NodeId', is_array = false, struct = nil},
    {name = 'ChannelId', is_array = false, struct = nil},
    {name = 'DimmId', is_array = false, struct = nil},
    {name = 'AllowedSpeedsMHz', is_array = false, struct = nil},
    {name = 'BaseModuleType', is_array = false, struct = nil},
    {name = 'CapacityMiB', is_array = false, struct = nil},
    {name = 'DataWidthBits', is_array = false, struct = nil},
    {name = 'FirmwareRevision', is_array = false, struct = nil},
    {name = 'Manufacturer', is_array = false, struct = nil},
    {name = 'MemoryDeviceType', is_array = false, struct = nil},
    {name = 'MemorySubsystemControllerManufacturerID', is_array = false, struct = nil},
    {name = 'MemorySubsystemControllerProductID', is_array = false, struct = nil},
    {name = 'MemoryType', is_array = false, struct = nil},
    {name = 'OperatingSpeedMhz', is_array = false, struct = nil},
    {name = 'PartNumber', is_array = false, struct = nil},
    {name = 'RankCount', is_array = false, struct = nil},
    {name = 'SerialNumber', is_array = false, struct = nil},
    {name = 'MinVoltageMillivolt', is_array = false, struct = nil},
    {name = 'Position', is_array = false, struct = nil}
}

function TGetMemoryInfoRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Name', self.Name, 'string', false, errs)
    validate.Required(prefix .. 'DimmName', self.DimmName, 'string', false, errs)
    validate.Required(prefix .. 'Presence', self.Presence, 'bool', false, errs)
    validate.Required(prefix .. 'CpuId', self.CpuId, 'uint8', false, errs)
    validate.Required(prefix .. 'NodeId', self.NodeId, 'uint8', false, errs)
    validate.Required(prefix .. 'ChannelId', self.ChannelId, 'uint8', false, errs)
    validate.Required(prefix .. 'DimmId', self.DimmId, 'uint8', false, errs)
    validate.Required(prefix .. 'AllowedSpeedsMHz', self.AllowedSpeedsMHz, 'uint32', false, errs)
    validate.Required(prefix .. 'BaseModuleType', self.BaseModuleType, 'string', false, errs)
    validate.Required(prefix .. 'CapacityMiB', self.CapacityMiB, 'uint32', false, errs)
    validate.Required(prefix .. 'DataWidthBits', self.DataWidthBits, 'uint32', false, errs)
    validate.Required(prefix .. 'FirmwareRevision', self.FirmwareRevision, 'string', false, errs)
    validate.Required(prefix .. 'Manufacturer', self.Manufacturer, 'string', false, errs)
    validate.Required(prefix .. 'MemoryDeviceType', self.MemoryDeviceType, 'string', false, errs)
    validate.Required(prefix .. 'MemorySubsystemControllerManufacturerID',
        self.MemorySubsystemControllerManufacturerID, 'string', false, errs)
    validate.Required(prefix .. 'MemorySubsystemControllerProductID',
        self.MemorySubsystemControllerProductID, 'string', false, errs)
    validate.Required(prefix .. 'MemoryType', self.MemoryType, 'string', false, errs)
    validate.Required(prefix .. 'OperatingSpeedMhz', self.OperatingSpeedMhz, 'uint32', false, errs)
    validate.Required(prefix .. 'PartNumber', self.PartNumber, 'string', false, errs)
    validate.Required(prefix .. 'RankCount', self.RankCount, 'uint32', false, errs)
    validate.Required(prefix .. 'SerialNumber', self.SerialNumber, 'string', false, errs)
    validate.Required(prefix .. 'MinVoltageMillivolt', self.MinVoltageMillivolt, 'uint32', false,
        errs)
    validate.Required(prefix .. 'Position', self.Position, 'string', false, errs)

    TGetMemoryInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetMemoryInfoRsp.proto_property, errs)
    return self
end

function TGetMemoryInfoRsp:unpack(_)
    return self.Name, self.DimmName, self.Presence, self.CpuId, self.NodeId, self.ChannelId,
        self.DimmId, self.AllowedSpeedsMHz, self.BaseModuleType, self.CapacityMiB,
        self.DataWidthBits, self.FirmwareRevision, self.Manufacturer, self.MemoryDeviceType,
        self.MemorySubsystemControllerManufacturerID, self.MemorySubsystemControllerProductID,
        self.MemoryType, self.OperatingSpeedMhz, self.PartNumber, self.RankCount, self.SerialNumber,
        self.MinVoltageMillivolt, self.Position
end

msg.GetMemoryInfoRsp = TGetMemoryInfoRsp

---@class compute.GetMemoryInfoReq
---@field MemoryName string
local TGetMemoryInfoReq = {}
TGetMemoryInfoReq.__index = TGetMemoryInfoReq
TGetMemoryInfoReq.group = {}

local function TGetMemoryInfoReq_from_obj(obj)
    return setmetatable(obj, TGetMemoryInfoReq)
end

function TGetMemoryInfoReq.new(MemoryName)
    return TGetMemoryInfoReq_from_obj({MemoryName = MemoryName})
end
---@param obj compute.GetMemoryInfoReq
function TGetMemoryInfoReq:init_from_obj(obj)
    self.MemoryName = obj.MemoryName
end

function TGetMemoryInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetMemoryInfoReq.group)
end

TGetMemoryInfoReq.from_obj = TGetMemoryInfoReq_from_obj

TGetMemoryInfoReq.proto_property = {'MemoryName'}

TGetMemoryInfoReq.default = {''}

TGetMemoryInfoReq.struct = {{name = 'MemoryName', is_array = false, struct = nil}}

function TGetMemoryInfoReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'MemoryName', self.MemoryName, 'string', false, errs)

    TGetMemoryInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetMemoryInfoReq.proto_property, errs)
    return self
end

function TGetMemoryInfoReq:unpack(_)
    return self.MemoryName
end

msg.GetMemoryInfoReq = TGetMemoryInfoReq

---@class compute.GetMemoryNumRsp
---@field MaxNum integer
---@field CurrentNum integer
local TGetMemoryNumRsp = {}
TGetMemoryNumRsp.__index = TGetMemoryNumRsp
TGetMemoryNumRsp.group = {}

local function TGetMemoryNumRsp_from_obj(obj)
    return setmetatable(obj, TGetMemoryNumRsp)
end

function TGetMemoryNumRsp.new(MaxNum, CurrentNum)
    return TGetMemoryNumRsp_from_obj({MaxNum = MaxNum, CurrentNum = CurrentNum})
end
---@param obj compute.GetMemoryNumRsp
function TGetMemoryNumRsp:init_from_obj(obj)
    self.MaxNum = obj.MaxNum
    self.CurrentNum = obj.CurrentNum
end

function TGetMemoryNumRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetMemoryNumRsp.group)
end

TGetMemoryNumRsp.from_obj = TGetMemoryNumRsp_from_obj

TGetMemoryNumRsp.proto_property = {'MaxNum', 'CurrentNum'}

TGetMemoryNumRsp.default = {0, 0}

TGetMemoryNumRsp.struct = {
    {name = 'MaxNum', is_array = false, struct = nil},
    {name = 'CurrentNum', is_array = false, struct = nil}
}

function TGetMemoryNumRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'MaxNum', self.MaxNum, 'uint32', false, errs)
    validate.Required(prefix .. 'CurrentNum', self.CurrentNum, 'uint32', false, errs)

    TGetMemoryNumRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetMemoryNumRsp.proto_property, errs)
    return self
end

function TGetMemoryNumRsp:unpack(_)
    return self.MaxNum, self.CurrentNum
end

msg.GetMemoryNumRsp = TGetMemoryNumRsp

---@class compute.GetMemoryNumReq
---@field MemoryId integer
local TGetMemoryNumReq = {}
TGetMemoryNumReq.__index = TGetMemoryNumReq
TGetMemoryNumReq.group = {}

local function TGetMemoryNumReq_from_obj(obj)
    return setmetatable(obj, TGetMemoryNumReq)
end

function TGetMemoryNumReq.new(MemoryId)
    return TGetMemoryNumReq_from_obj({MemoryId = MemoryId})
end
---@param obj compute.GetMemoryNumReq
function TGetMemoryNumReq:init_from_obj(obj)
    self.MemoryId = obj.MemoryId
end

function TGetMemoryNumReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetMemoryNumReq.group)
end

TGetMemoryNumReq.from_obj = TGetMemoryNumReq_from_obj

TGetMemoryNumReq.proto_property = {'MemoryId'}

TGetMemoryNumReq.default = {0}

TGetMemoryNumReq.struct = {{name = 'MemoryId', is_array = false, struct = nil}}

function TGetMemoryNumReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'MemoryId', self.MemoryId, 'uint8', false, errs)

    TGetMemoryNumReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetMemoryNumReq.proto_property, errs)
    return self
end

function TGetMemoryNumReq:unpack(_)
    return self.MemoryId
end

msg.GetMemoryNumReq = TGetMemoryNumReq

---@class compute.SetMemoryChannelDiagnosticFaultRsp
---@field Code integer
local TSetMemoryChannelDiagnosticFaultRsp = {}
TSetMemoryChannelDiagnosticFaultRsp.__index = TSetMemoryChannelDiagnosticFaultRsp
TSetMemoryChannelDiagnosticFaultRsp.group = {}

local function TSetMemoryChannelDiagnosticFaultRsp_from_obj(obj)
    return setmetatable(obj, TSetMemoryChannelDiagnosticFaultRsp)
end

function TSetMemoryChannelDiagnosticFaultRsp.new(Code)
    return TSetMemoryChannelDiagnosticFaultRsp_from_obj({Code = Code})
end
---@param obj compute.SetMemoryChannelDiagnosticFaultRsp
function TSetMemoryChannelDiagnosticFaultRsp:init_from_obj(obj)
    self.Code = obj.Code
end

function TSetMemoryChannelDiagnosticFaultRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetMemoryChannelDiagnosticFaultRsp.group)
end

TSetMemoryChannelDiagnosticFaultRsp.from_obj = TSetMemoryChannelDiagnosticFaultRsp_from_obj

TSetMemoryChannelDiagnosticFaultRsp.proto_property = {'Code'}

TSetMemoryChannelDiagnosticFaultRsp.default = {0}

TSetMemoryChannelDiagnosticFaultRsp.struct = {{name = 'Code', is_array = false, struct = nil}}

function TSetMemoryChannelDiagnosticFaultRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Code', self.Code, 'uint8', false, errs)

    TSetMemoryChannelDiagnosticFaultRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetMemoryChannelDiagnosticFaultRsp.proto_property, errs)
    return self
end

function TSetMemoryChannelDiagnosticFaultRsp:unpack(_)
    return self.Code
end

msg.SetMemoryChannelDiagnosticFaultRsp = TSetMemoryChannelDiagnosticFaultRsp

---@class compute.SetMemoryChannelDiagnosticFaultReq
---@field SystemId integer
---@field LogicalCpuId integer
---@field LogicalChannelId integer
---@field State integer
local TSetMemoryChannelDiagnosticFaultReq = {}
TSetMemoryChannelDiagnosticFaultReq.__index = TSetMemoryChannelDiagnosticFaultReq
TSetMemoryChannelDiagnosticFaultReq.group = {}

local function TSetMemoryChannelDiagnosticFaultReq_from_obj(obj)
    return setmetatable(obj, TSetMemoryChannelDiagnosticFaultReq)
end

function TSetMemoryChannelDiagnosticFaultReq.new(SystemId, LogicalCpuId, LogicalChannelId, State)
    return TSetMemoryChannelDiagnosticFaultReq_from_obj({
        SystemId = SystemId,
        LogicalCpuId = LogicalCpuId,
        LogicalChannelId = LogicalChannelId,
        State = State
    })
end
---@param obj compute.SetMemoryChannelDiagnosticFaultReq
function TSetMemoryChannelDiagnosticFaultReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.LogicalCpuId = obj.LogicalCpuId
    self.LogicalChannelId = obj.LogicalChannelId
    self.State = obj.State
end

function TSetMemoryChannelDiagnosticFaultReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetMemoryChannelDiagnosticFaultReq.group)
end

TSetMemoryChannelDiagnosticFaultReq.from_obj = TSetMemoryChannelDiagnosticFaultReq_from_obj

TSetMemoryChannelDiagnosticFaultReq.proto_property = {
    'SystemId', 'LogicalCpuId', 'LogicalChannelId', 'State'
}

TSetMemoryChannelDiagnosticFaultReq.default = {0, 0, 0, 0}

TSetMemoryChannelDiagnosticFaultReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'LogicalCpuId', is_array = false, struct = nil},
    {name = 'LogicalChannelId', is_array = false, struct = nil},
    {name = 'State', is_array = false, struct = nil}
}

function TSetMemoryChannelDiagnosticFaultReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'uint8', false, errs)
    validate.Required(prefix .. 'LogicalCpuId', self.LogicalCpuId, 'uint8', false, errs)
    validate.Required(prefix .. 'LogicalChannelId', self.LogicalChannelId, 'uint8', false, errs)
    validate.Required(prefix .. 'State', self.State, 'uint8', false, errs)

    TSetMemoryChannelDiagnosticFaultReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetMemoryChannelDiagnosticFaultReq.proto_property, errs)
    return self
end

function TSetMemoryChannelDiagnosticFaultReq:unpack(_)
    return self.SystemId, self.LogicalCpuId, self.LogicalChannelId, self.State
end

msg.SetMemoryChannelDiagnosticFaultReq = TSetMemoryChannelDiagnosticFaultReq

---@class compute.GetEidPhyaddrRsp
---@field Eid integer
---@field Phyaddr integer
local TGetEidPhyaddrRsp = {}
TGetEidPhyaddrRsp.__index = TGetEidPhyaddrRsp
TGetEidPhyaddrRsp.group = {}

local function TGetEidPhyaddrRsp_from_obj(obj)
    return setmetatable(obj, TGetEidPhyaddrRsp)
end

function TGetEidPhyaddrRsp.new(Eid, Phyaddr)
    return TGetEidPhyaddrRsp_from_obj({Eid = Eid, Phyaddr = Phyaddr})
end
---@param obj compute.GetEidPhyaddrRsp
function TGetEidPhyaddrRsp:init_from_obj(obj)
    self.Eid = obj.Eid
    self.Phyaddr = obj.Phyaddr
end

function TGetEidPhyaddrRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetEidPhyaddrRsp.group)
end

TGetEidPhyaddrRsp.from_obj = TGetEidPhyaddrRsp_from_obj

TGetEidPhyaddrRsp.proto_property = {'Eid', 'Phyaddr'}

TGetEidPhyaddrRsp.default = {0, 0}

TGetEidPhyaddrRsp.struct = {
    {name = 'Eid', is_array = false, struct = nil},
    {name = 'Phyaddr', is_array = false, struct = nil}
}

function TGetEidPhyaddrRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Eid', self.Eid, 'uint8', false, errs)
    validate.Required(prefix .. 'Phyaddr', self.Phyaddr, 'uint32', false, errs)

    TGetEidPhyaddrRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetEidPhyaddrRsp.proto_property, errs)
    return self
end

function TGetEidPhyaddrRsp:unpack(_)
    return self.Eid, self.Phyaddr
end

msg.GetEidPhyaddrRsp = TGetEidPhyaddrRsp

---@class compute.GetEidPhyaddrReq
---@field SystemId integer
---@field SocketId integer
---@field Segment integer
---@field BusNum integer
---@field DevNum integer
---@field FunNum integer
local TGetEidPhyaddrReq = {}
TGetEidPhyaddrReq.__index = TGetEidPhyaddrReq
TGetEidPhyaddrReq.group = {}

local function TGetEidPhyaddrReq_from_obj(obj)
    return setmetatable(obj, TGetEidPhyaddrReq)
end

function TGetEidPhyaddrReq.new(SystemId, SocketId, Segment, BusNum, DevNum, FunNum)
    return TGetEidPhyaddrReq_from_obj({
        SystemId = SystemId,
        SocketId = SocketId,
        Segment = Segment,
        BusNum = BusNum,
        DevNum = DevNum,
        FunNum = FunNum
    })
end
---@param obj compute.GetEidPhyaddrReq
function TGetEidPhyaddrReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.SocketId = obj.SocketId
    self.Segment = obj.Segment
    self.BusNum = obj.BusNum
    self.DevNum = obj.DevNum
    self.FunNum = obj.FunNum
end

function TGetEidPhyaddrReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetEidPhyaddrReq.group)
end

TGetEidPhyaddrReq.from_obj = TGetEidPhyaddrReq_from_obj

TGetEidPhyaddrReq.proto_property = {'SystemId', 'SocketId', 'Segment', 'BusNum', 'DevNum', 'FunNum'}

TGetEidPhyaddrReq.default = {0, 0, 0, 0, 0, 0}

TGetEidPhyaddrReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'SocketId', is_array = false, struct = nil},
    {name = 'Segment', is_array = false, struct = nil},
    {name = 'BusNum', is_array = false, struct = nil},
    {name = 'DevNum', is_array = false, struct = nil},
    {name = 'FunNum', is_array = false, struct = nil}
}

function TGetEidPhyaddrReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'uint8', false, errs)
    validate.Required(prefix .. 'SocketId', self.SocketId, 'uint8', false, errs)
    validate.Required(prefix .. 'Segment', self.Segment, 'uint32', false, errs)
    validate.Required(prefix .. 'BusNum', self.BusNum, 'uint8', false, errs)
    validate.Required(prefix .. 'DevNum', self.DevNum, 'uint8', false, errs)
    validate.Required(prefix .. 'FunNum', self.FunNum, 'uint8', false, errs)

    TGetEidPhyaddrReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetEidPhyaddrReq.proto_property, errs)
    return self
end

function TGetEidPhyaddrReq:unpack(_)
    return self.SystemId, self.SocketId, self.Segment, self.BusNum, self.DevNum, self.FunNum
end

msg.GetEidPhyaddrReq = TGetEidPhyaddrReq

---@class compute.PcieCardChangeNotifyRsp
---@field Status integer
local TPcieCardChangeNotifyRsp = {}
TPcieCardChangeNotifyRsp.__index = TPcieCardChangeNotifyRsp
TPcieCardChangeNotifyRsp.group = {}

local function TPcieCardChangeNotifyRsp_from_obj(obj)
    return setmetatable(obj, TPcieCardChangeNotifyRsp)
end

function TPcieCardChangeNotifyRsp.new(Status)
    return TPcieCardChangeNotifyRsp_from_obj({Status = Status})
end
---@param obj compute.PcieCardChangeNotifyRsp
function TPcieCardChangeNotifyRsp:init_from_obj(obj)
    self.Status = obj.Status
end

function TPcieCardChangeNotifyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPcieCardChangeNotifyRsp.group)
end

TPcieCardChangeNotifyRsp.from_obj = TPcieCardChangeNotifyRsp_from_obj

TPcieCardChangeNotifyRsp.proto_property = {'Status'}

TPcieCardChangeNotifyRsp.default = {0}

TPcieCardChangeNotifyRsp.struct = {{name = 'Status', is_array = false, struct = nil}}

function TPcieCardChangeNotifyRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Status', self.Status, 'uint8', false, errs)

    TPcieCardChangeNotifyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPcieCardChangeNotifyRsp.proto_property, errs)
    return self
end

function TPcieCardChangeNotifyRsp:unpack(_)
    return self.Status
end

msg.PcieCardChangeNotifyRsp = TPcieCardChangeNotifyRsp

---@class compute.PcieCardChangeNotifyReq
---@field SystemId integer
local TPcieCardChangeNotifyReq = {}
TPcieCardChangeNotifyReq.__index = TPcieCardChangeNotifyReq
TPcieCardChangeNotifyReq.group = {}

local function TPcieCardChangeNotifyReq_from_obj(obj)
    return setmetatable(obj, TPcieCardChangeNotifyReq)
end

function TPcieCardChangeNotifyReq.new(SystemId)
    return TPcieCardChangeNotifyReq_from_obj({SystemId = SystemId})
end
---@param obj compute.PcieCardChangeNotifyReq
function TPcieCardChangeNotifyReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
end

function TPcieCardChangeNotifyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPcieCardChangeNotifyReq.group)
end

TPcieCardChangeNotifyReq.from_obj = TPcieCardChangeNotifyReq_from_obj

TPcieCardChangeNotifyReq.proto_property = {'SystemId'}

TPcieCardChangeNotifyReq.default = {0}

TPcieCardChangeNotifyReq.struct = {{name = 'SystemId', is_array = false, struct = nil}}

function TPcieCardChangeNotifyReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'uint8', false, errs)

    TPcieCardChangeNotifyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPcieCardChangeNotifyReq.proto_property, errs)
    return self
end

function TPcieCardChangeNotifyReq:unpack(_)
    return self.SystemId
end

msg.PcieCardChangeNotifyReq = TPcieCardChangeNotifyReq

---@class compute.GetPcieSubVidDidInfoRsp
---@field VendorId integer
---@field DeviceId integer
local TGetPcieSubVidDidInfoRsp = {}
TGetPcieSubVidDidInfoRsp.__index = TGetPcieSubVidDidInfoRsp
TGetPcieSubVidDidInfoRsp.group = {}

local function TGetPcieSubVidDidInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetPcieSubVidDidInfoRsp)
end

function TGetPcieSubVidDidInfoRsp.new(VendorId, DeviceId)
    return TGetPcieSubVidDidInfoRsp_from_obj({VendorId = VendorId, DeviceId = DeviceId})
end
---@param obj compute.GetPcieSubVidDidInfoRsp
function TGetPcieSubVidDidInfoRsp:init_from_obj(obj)
    self.VendorId = obj.VendorId
    self.DeviceId = obj.DeviceId
end

function TGetPcieSubVidDidInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPcieSubVidDidInfoRsp.group)
end

TGetPcieSubVidDidInfoRsp.from_obj = TGetPcieSubVidDidInfoRsp_from_obj

TGetPcieSubVidDidInfoRsp.proto_property = {'VendorId', 'DeviceId'}

TGetPcieSubVidDidInfoRsp.default = {0, 0}

TGetPcieSubVidDidInfoRsp.struct = {
    {name = 'VendorId', is_array = false, struct = nil},
    {name = 'DeviceId', is_array = false, struct = nil}
}

function TGetPcieSubVidDidInfoRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'VendorId', self.VendorId, 'uint16', false, errs)
    validate.Required(prefix .. 'DeviceId', self.DeviceId, 'uint16', false, errs)

    TGetPcieSubVidDidInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPcieSubVidDidInfoRsp.proto_property, errs)
    return self
end

function TGetPcieSubVidDidInfoRsp:unpack(_)
    return self.VendorId, self.DeviceId
end

msg.GetPcieSubVidDidInfoRsp = TGetPcieSubVidDidInfoRsp

---@class compute.GetPcieSubVidDidInfoReq
---@field SystemId integer
---@field IsLocal boolean
---@field CpuId integer
---@field Bus integer
---@field Device integer
---@field Function integer
local TGetPcieSubVidDidInfoReq = {}
TGetPcieSubVidDidInfoReq.__index = TGetPcieSubVidDidInfoReq
TGetPcieSubVidDidInfoReq.group = {}

local function TGetPcieSubVidDidInfoReq_from_obj(obj)
    return setmetatable(obj, TGetPcieSubVidDidInfoReq)
end

function TGetPcieSubVidDidInfoReq.new(SystemId, IsLocal, CpuId, Bus, Device, Function)
    return TGetPcieSubVidDidInfoReq_from_obj({
        SystemId = SystemId,
        IsLocal = IsLocal,
        CpuId = CpuId,
        Bus = Bus,
        Device = Device,
        Function = Function
    })
end
---@param obj compute.GetPcieSubVidDidInfoReq
function TGetPcieSubVidDidInfoReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.IsLocal = obj.IsLocal
    self.CpuId = obj.CpuId
    self.Bus = obj.Bus
    self.Device = obj.Device
    self.Function = obj.Function
end

function TGetPcieSubVidDidInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPcieSubVidDidInfoReq.group)
end

TGetPcieSubVidDidInfoReq.from_obj = TGetPcieSubVidDidInfoReq_from_obj

TGetPcieSubVidDidInfoReq.proto_property = {
    'SystemId', 'IsLocal', 'CpuId', 'Bus', 'Device', 'Function'
}

TGetPcieSubVidDidInfoReq.default = {0, false, 0, 0, 0, 0}

TGetPcieSubVidDidInfoReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'IsLocal', is_array = false, struct = nil},
    {name = 'CpuId', is_array = false, struct = nil},
    {name = 'Bus', is_array = false, struct = nil},
    {name = 'Device', is_array = false, struct = nil},
    {name = 'Function', is_array = false, struct = nil}
}

function TGetPcieSubVidDidInfoReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'uint8', false, errs)
    validate.Required(prefix .. 'IsLocal', self.IsLocal, 'bool', false, errs)
    validate.Required(prefix .. 'CpuId', self.CpuId, 'uint8', false, errs)
    validate.Required(prefix .. 'Bus', self.Bus, 'uint8', false, errs)
    validate.Required(prefix .. 'Device', self.Device, 'uint8', false, errs)
    validate.Required(prefix .. 'Function', self.Function, 'uint8', false, errs)

    TGetPcieSubVidDidInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPcieSubVidDidInfoReq.proto_property, errs)
    return self
end

function TGetPcieSubVidDidInfoReq:unpack(_)
    return self.SystemId, self.IsLocal, self.CpuId, self.Bus, self.Device, self.Function
end

msg.GetPcieSubVidDidInfoReq = TGetPcieSubVidDidInfoReq

---@class compute.GetPcieVidDidInfoRsp
---@field VendorId integer
---@field DeviceId integer
local TGetPcieVidDidInfoRsp = {}
TGetPcieVidDidInfoRsp.__index = TGetPcieVidDidInfoRsp
TGetPcieVidDidInfoRsp.group = {}

local function TGetPcieVidDidInfoRsp_from_obj(obj)
    return setmetatable(obj, TGetPcieVidDidInfoRsp)
end

function TGetPcieVidDidInfoRsp.new(VendorId, DeviceId)
    return TGetPcieVidDidInfoRsp_from_obj({VendorId = VendorId, DeviceId = DeviceId})
end
---@param obj compute.GetPcieVidDidInfoRsp
function TGetPcieVidDidInfoRsp:init_from_obj(obj)
    self.VendorId = obj.VendorId
    self.DeviceId = obj.DeviceId
end

function TGetPcieVidDidInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPcieVidDidInfoRsp.group)
end

TGetPcieVidDidInfoRsp.from_obj = TGetPcieVidDidInfoRsp_from_obj

TGetPcieVidDidInfoRsp.proto_property = {'VendorId', 'DeviceId'}

TGetPcieVidDidInfoRsp.default = {0, 0}

TGetPcieVidDidInfoRsp.struct = {
    {name = 'VendorId', is_array = false, struct = nil},
    {name = 'DeviceId', is_array = false, struct = nil}
}

function TGetPcieVidDidInfoRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'VendorId', self.VendorId, 'uint16', false, errs)
    validate.Required(prefix .. 'DeviceId', self.DeviceId, 'uint16', false, errs)

    TGetPcieVidDidInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPcieVidDidInfoRsp.proto_property, errs)
    return self
end

function TGetPcieVidDidInfoRsp:unpack(_)
    return self.VendorId, self.DeviceId
end

msg.GetPcieVidDidInfoRsp = TGetPcieVidDidInfoRsp

---@class compute.GetPcieVidDidInfoReq
---@field SystemId integer
---@field IsLocal boolean
---@field CpuId integer
---@field Bus integer
---@field Device integer
---@field Function integer
local TGetPcieVidDidInfoReq = {}
TGetPcieVidDidInfoReq.__index = TGetPcieVidDidInfoReq
TGetPcieVidDidInfoReq.group = {}

local function TGetPcieVidDidInfoReq_from_obj(obj)
    return setmetatable(obj, TGetPcieVidDidInfoReq)
end

function TGetPcieVidDidInfoReq.new(SystemId, IsLocal, CpuId, Bus, Device, Function)
    return TGetPcieVidDidInfoReq_from_obj({
        SystemId = SystemId,
        IsLocal = IsLocal,
        CpuId = CpuId,
        Bus = Bus,
        Device = Device,
        Function = Function
    })
end
---@param obj compute.GetPcieVidDidInfoReq
function TGetPcieVidDidInfoReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.IsLocal = obj.IsLocal
    self.CpuId = obj.CpuId
    self.Bus = obj.Bus
    self.Device = obj.Device
    self.Function = obj.Function
end

function TGetPcieVidDidInfoReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPcieVidDidInfoReq.group)
end

TGetPcieVidDidInfoReq.from_obj = TGetPcieVidDidInfoReq_from_obj

TGetPcieVidDidInfoReq.proto_property = {'SystemId', 'IsLocal', 'CpuId', 'Bus', 'Device', 'Function'}

TGetPcieVidDidInfoReq.default = {0, false, 0, 0, 0, 0}

TGetPcieVidDidInfoReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'IsLocal', is_array = false, struct = nil},
    {name = 'CpuId', is_array = false, struct = nil},
    {name = 'Bus', is_array = false, struct = nil},
    {name = 'Device', is_array = false, struct = nil},
    {name = 'Function', is_array = false, struct = nil}
}

function TGetPcieVidDidInfoReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'uint8', false, errs)
    validate.Required(prefix .. 'IsLocal', self.IsLocal, 'bool', false, errs)
    validate.Required(prefix .. 'CpuId', self.CpuId, 'uint8', false, errs)
    validate.Required(prefix .. 'Bus', self.Bus, 'uint8', false, errs)
    validate.Required(prefix .. 'Device', self.Device, 'uint8', false, errs)
    validate.Required(prefix .. 'Function', self.Function, 'uint8', false, errs)

    TGetPcieVidDidInfoReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPcieVidDidInfoReq.proto_property, errs)
    return self
end

function TGetPcieVidDidInfoReq:unpack(_)
    return self.SystemId, self.IsLocal, self.CpuId, self.Bus, self.Device, self.Function
end

msg.GetPcieVidDidInfoReq = TGetPcieVidDidInfoReq

local compute = {}

local Mdb = require 'mc.mdb'

---@class compute: Table
compute.compute = Mdb.register_interface('bmc.kepler.compute', {}, {
    GetPcieVidDidInfo = {'a{ss}ybyyyy', 'qq', msg.GetPcieVidDidInfoReq, msg.GetPcieVidDidInfoRsp},
    GetPcieSubVidDidInfo = {
        'a{ss}ybyyyy', 'qq', msg.GetPcieSubVidDidInfoReq, msg.GetPcieSubVidDidInfoRsp
    },
    PcieCardChangeNotify = {'a{ss}y', 'y', msg.PcieCardChangeNotifyReq, msg.PcieCardChangeNotifyRsp},
    GetEidPhyaddr = {'a{ss}yyuyyy', 'yu', msg.GetEidPhyaddrReq, msg.GetEidPhyaddrRsp},
    SetMemoryChannelDiagnosticFault = {
        'a{ss}yyyy', 'y', msg.SetMemoryChannelDiagnosticFaultReq,
        msg.SetMemoryChannelDiagnosticFaultRsp
    },
    GetMemoryNum = {'a{ss}y', 'uu', msg.GetMemoryNumReq, msg.GetMemoryNumRsp},
    GetMemoryInfo = {
        'a{ss}s', 'ssbyyyyusuussssssususus', msg.GetMemoryInfoReq, msg.GetMemoryInfoRsp
    },
    SetMemoryDiagnosticFault = {
        'a{ss}yyyyyy', 'y', msg.SetMemoryDiagnosticFaultReq, msg.SetMemoryDiagnosticFaultRsp
    },
    SetMemoryPredictiveFault = {
        'a{ss}yyyyyy', 'y', msg.SetMemoryPredictiveFaultReq, msg.SetMemoryPredictiveFaultRsp
    },
    GetProcessorNum = {'a{ss}y', 'uu', msg.GetProcessorNumReq, msg.GetProcessorNumRsp},
    GetProcessorInfo = {
        'a{ss}y', 'yybsssuusstsssuuuuuus', msg.GetProcessorInfoReq, msg.GetProcessorInfoRsp
    },
    SetCPUDiagnosticFault = {
        'a{ss}yyy', 'y', msg.SetCPUDiagnosticFaultReq, msg.SetCPUDiagnosticFaultRsp
    },
    SetCPUPredictiveFault = {
        'a{ss}yyy', 'y', msg.SetCPUPredictiveFaultReq, msg.SetCPUPredictiveFaultRsp
    }
}, {})
return compute
