-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class FirmwareInventory.DeleteRsp
local TDeleteRsp = {}
TDeleteRsp.__index = TDeleteRsp
TDeleteRsp.group = {}

local function TDeleteRsp_from_obj(obj)
    return setmetatable(obj, TDeleteRsp)
end

function TDeleteRsp.new()
    return TDeleteRsp_from_obj({})
end
---@param obj FirmwareInventory.DeleteRsp
function TDeleteRsp:init_from_obj(obj)

end

function TDeleteRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteRsp.group)
end

TDeleteRsp.from_obj = TDeleteRsp_from_obj

TDeleteRsp.proto_property = {}

TDeleteRsp.default = {}

TDeleteRsp.struct = {}

function TDeleteRsp:validate(prefix, errs)
    prefix = prefix or ''

    TDeleteRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteRsp.proto_property, errs)
    return self
end

function TDeleteRsp:unpack(_)
end

msg.DeleteRsp = TDeleteRsp

---@class FirmwareInventory.DeleteReq
---@field Id string
local TDeleteReq = {}
TDeleteReq.__index = TDeleteReq
TDeleteReq.group = {}

local function TDeleteReq_from_obj(obj)
    return setmetatable(obj, TDeleteReq)
end

function TDeleteReq.new(Id)
    return TDeleteReq_from_obj({Id = Id})
end
---@param obj FirmwareInventory.DeleteReq
function TDeleteReq:init_from_obj(obj)
    self.Id = obj.Id
end

function TDeleteReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteReq.group)
end

TDeleteReq.from_obj = TDeleteReq_from_obj

TDeleteReq.proto_property = {'Id'}

TDeleteReq.default = {''}

TDeleteReq.struct = {{name = 'Id', is_array = false, struct = nil}}

function TDeleteReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'string', false, errs)

    TDeleteReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteReq.proto_property, errs)
    return self
end

function TDeleteReq:unpack(_)
    return self.Id
end

msg.DeleteReq = TDeleteReq

---@class FirmwareInventory.AddRsp
local TAddRsp = {}
TAddRsp.__index = TAddRsp
TAddRsp.group = {}

local function TAddRsp_from_obj(obj)
    return setmetatable(obj, TAddRsp)
end

function TAddRsp.new()
    return TAddRsp_from_obj({})
end
---@param obj FirmwareInventory.AddRsp
function TAddRsp:init_from_obj(obj)

end

function TAddRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddRsp.group)
end

TAddRsp.from_obj = TAddRsp_from_obj

TAddRsp.proto_property = {}

TAddRsp.default = {}

TAddRsp.struct = {}

function TAddRsp:validate(prefix, errs)
    prefix = prefix or ''

    TAddRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddRsp.proto_property, errs)
    return self
end

function TAddRsp:unpack(_)
end

msg.AddRsp = TAddRsp

---@class FirmwareInventory.AddReq
---@field Id string
---@field Name string
---@field Version string
---@field BuildNum string
---@field ReleaseDate string
---@field LowestSupportedVersion string
---@field SoftwareId string
---@field Manufacturer string
---@field Updateable boolean
---@field Location string
---@field Capability integer
local TAddReq = {}
TAddReq.__index = TAddReq
TAddReq.group = {}

local function TAddReq_from_obj(obj)
    return setmetatable(obj, TAddReq)
end

function TAddReq.new(Id, Name, Version, BuildNum, ReleaseDate, LowestSupportedVersion, SoftwareId,
    Manufacturer, Updateable, Location, Capability)
    return TAddReq_from_obj({
        Id = Id,
        Name = Name,
        Version = Version,
        BuildNum = BuildNum,
        ReleaseDate = ReleaseDate,
        LowestSupportedVersion = LowestSupportedVersion,
        SoftwareId = SoftwareId,
        Manufacturer = Manufacturer,
        Updateable = Updateable,
        Location = Location,
        Capability = Capability
    })
end
---@param obj FirmwareInventory.AddReq
function TAddReq:init_from_obj(obj)
    self.Id = obj.Id
    self.Name = obj.Name
    self.Version = obj.Version
    self.BuildNum = obj.BuildNum
    self.ReleaseDate = obj.ReleaseDate
    self.LowestSupportedVersion = obj.LowestSupportedVersion
    self.SoftwareId = obj.SoftwareId
    self.Manufacturer = obj.Manufacturer
    self.Updateable = obj.Updateable
    self.Location = obj.Location
    self.Capability = obj.Capability
end

function TAddReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddReq.group)
end

TAddReq.from_obj = TAddReq_from_obj

TAddReq.proto_property = {
    'Id', 'Name', 'Version', 'BuildNum', 'ReleaseDate', 'LowestSupportedVersion', 'SoftwareId',
    'Manufacturer', 'Updateable', 'Location', 'Capability'
}

TAddReq.default = {'', '', '', '', '', '', '', '', false, '', 0}

TAddReq.struct = {
    {name = 'Id', is_array = false, struct = nil}, {name = 'Name', is_array = false, struct = nil},
    {name = 'Version', is_array = false, struct = nil},
    {name = 'BuildNum', is_array = false, struct = nil},
    {name = 'ReleaseDate', is_array = false, struct = nil},
    {name = 'LowestSupportedVersion', is_array = false, struct = nil},
    {name = 'SoftwareId', is_array = false, struct = nil},
    {name = 'Manufacturer', is_array = false, struct = nil},
    {name = 'Updateable', is_array = false, struct = nil},
    {name = 'Location', is_array = false, struct = nil},
    {name = 'Capability', is_array = false, struct = nil}
}

function TAddReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'string', false, errs)
    validate.Required(prefix .. 'Name', self.Name, 'string', false, errs)
    validate.Required(prefix .. 'Version', self.Version, 'string', false, errs)
    validate.Required(prefix .. 'BuildNum', self.BuildNum, 'string', false, errs)
    validate.Required(prefix .. 'ReleaseDate', self.ReleaseDate, 'string', false, errs)
    validate.Required(prefix .. 'LowestSupportedVersion', self.LowestSupportedVersion, 'string',
        false, errs)
    validate.Required(prefix .. 'SoftwareId', self.SoftwareId, 'string', false, errs)
    validate.Required(prefix .. 'Manufacturer', self.Manufacturer, 'string', false, errs)
    validate.Required(prefix .. 'Updateable', self.Updateable, 'bool', false, errs)
    validate.Required(prefix .. 'Location', self.Location, 'string', false, errs)
    validate.Required(prefix .. 'Capability', self.Capability, 'uint16', false, errs)

    TAddReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddReq.proto_property, errs)
    return self
end

function TAddReq:unpack(_)
    return self.Id, self.Name, self.Version, self.BuildNum, self.ReleaseDate,
        self.LowestSupportedVersion, self.SoftwareId, self.Manufacturer, self.Updateable,
        self.Location, self.Capability
end

msg.AddReq = TAddReq

local FirmwareInventory = {}

local Mdb = require 'mc.mdb'

---@class FirmwareInventory: Table
FirmwareInventory.FirmwareInventory = Mdb.register_interface(
    'bmc.kepler.UpdateService.FirmwareInventory', {}, {
        Add = {'a{ss}ssssssssbsq', '', msg.AddReq, msg.AddRsp},
        Delete = {'a{ss}s', '', msg.DeleteReq, msg.DeleteRsp}
    }, {})
return FirmwareInventory
