-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SystemsMsg = {}

---@class SystemsMsg.AddFruInvReq
---@field Id string
---@field Name string
local TAddFruInvReq = {}
TAddFruInvReq.__index = TAddFruInvReq
TAddFruInvReq.group = {}

local function TAddFruInvReq_from_obj(obj)
    return setmetatable(obj, TAddFruInvReq)
end

function TAddFruInvReq.new(Id, Name)
    return TAddFruInvReq_from_obj({Id = Id, Name = Name})
end
---@param obj SystemsMsg.AddFruInvReq
function TAddFruInvReq:init_from_obj(obj)
    self.Id = obj.Id
    self.Name = obj.Name
end

function TAddFruInvReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAddFruInvReq.group)
end

TAddFruInvReq.from_obj = TAddFruInvReq_from_obj

TAddFruInvReq.proto_property = {'Id', 'Name'}

TAddFruInvReq.default = {'', ''}

TAddFruInvReq.struct = {
    {name = 'Id', is_array = false, struct = nil}, {name = 'Name', is_array = false, struct = nil}
}

function TAddFruInvReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'string', false, errs)
    validate.Required(prefix .. 'Name', self.Name, 'string', false, errs)

    TAddFruInvReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAddFruInvReq.proto_property, errs)
    return self
end

function TAddFruInvReq:unpack(_)
    return self.Id, self.Name
end

SystemsMsg.AddFruInvReq = TAddFruInvReq

---@class SystemsMsg.DeleteFruInvReq
---@field Id string
local TDeleteFruInvReq = {}
TDeleteFruInvReq.__index = TDeleteFruInvReq
TDeleteFruInvReq.group = {}

local function TDeleteFruInvReq_from_obj(obj)
    return setmetatable(obj, TDeleteFruInvReq)
end

function TDeleteFruInvReq.new(Id)
    return TDeleteFruInvReq_from_obj({Id = Id})
end
---@param obj SystemsMsg.DeleteFruInvReq
function TDeleteFruInvReq:init_from_obj(obj)
    self.Id = obj.Id
end

function TDeleteFruInvReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteFruInvReq.group)
end

TDeleteFruInvReq.from_obj = TDeleteFruInvReq_from_obj

TDeleteFruInvReq.proto_property = {'Id'}

TDeleteFruInvReq.default = {''}

TDeleteFruInvReq.struct = {{name = 'Id', is_array = false, struct = nil}}

function TDeleteFruInvReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Id', self.Id, 'string', false, errs)

    TDeleteFruInvReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteFruInvReq.proto_property, errs)
    return self
end

function TDeleteFruInvReq:unpack(_)
    return self.Id
end

SystemsMsg.DeleteFruInvReq = TDeleteFruInvReq

return SystemsMsg
