-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local UnitsInterface = require 'mdb.bmc.kepler.Systems.Units.UnitsInterface'

local childs = {}
local Units = {childs = childs}

local Mdb = require 'mc.mdb'

local TExpBoard = Mdb.register_object('/bmc/kepler/Systems/:SystemID/Units/ExpBoard/:ID',
    {{name = 'Unit', interface = UnitsInterface.Unit}})
Units.ExpBoard = TExpBoard

function TExpBoard:ctor(SystemID, ID)
    self.path = '/bmc/kepler/Systems/' .. SystemID .. '/Units/ExpBoard/' .. ID .. ''
end

local TCpuBoard = Mdb.register_object('/bmc/kepler/Systems/:SystemID/Units/CpuBoard/:ID', {
    {name = 'Unit', interface = UnitsInterface.Unit},
    {name = 'ICpuBoard', interface = UnitsInterface.ICpuBoard}
})
Units.CpuBoard = TCpuBoard

function TCpuBoard:ctor(SystemID, ID)
    self.path = '/bmc/kepler/Systems/' .. SystemID .. '/Units/CpuBoard/' .. ID .. ''
end

local THddBackplane = Mdb.register_object('/bmc/kepler/Systems/:SystemID/Units/HddBackplane/:ID',
    {{name = 'Unit', interface = UnitsInterface.Unit}})
Units.HddBackplane = THddBackplane

function THddBackplane:ctor(SystemID, ID)
    self.path = '/bmc/kepler/Systems/' .. SystemID .. '/Units/HddBackplane/' .. ID .. ''
end

local TFanBoard = Mdb.register_object('/bmc/kepler/Systems/:SystemID/Units/FanBoard/:ID',
    {{name = 'Unit', interface = UnitsInterface.Unit}})
Units.FanBoard = TFanBoard

function TFanBoard:ctor(SystemID, ID)
    self.path = '/bmc/kepler/Systems/' .. SystemID .. '/Units/FanBoard/' .. ID .. ''
end

local TRiserCard = Mdb.register_object('/bmc/kepler/Systems/:SystemID/Units/RiserCard/:ID',
    {{name = 'Unit', interface = UnitsInterface.Unit}})
Units.RiserCard = TRiserCard

function TRiserCard:ctor(SystemID, ID)
    self.path = '/bmc/kepler/Systems/' .. SystemID .. '/Units/RiserCard/' .. ID .. ''
end

return Units
