-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local ThermalMgmt = {}

local Mdb = require 'mc.mdb'

---@class IFan: Table
---@field FanId integer
---@field Slot integer
---@field Type integer
---@field Model string
---@field Coefficient integer
---@field FanHealth integer
---@field FanEntity string
---@field FrontPresence integer
---@field RearPresence integer
---@field FrontSpeed integer
---@field RearSpeed integer
---@field FrontStatus integer
---@field RearStatus integer
---@field FrontRPM integer
---@field RearRPM integer
---@field HardwarePWM number
---@field PWMPercentage integer
---@field ExpectedPWM number
---@field FanAlarmLed integer
---@field BOM string
---@field SystemId integer
---@field MaxSupportedPWM integer
---@field IdentifySpeedLevel integer
---@field PartNumber string
---@field FrontMaxSpeed integer
---@field RearMaxSpeed integer
---@field IsTwins boolean
ThermalMgmt.IFan = Mdb.register_interface('bmc.kepler.Systems.Fan', {
    FanId = {'q', nil, false, nil},
    Slot = {'y', nil, false, nil},
    Type = {'y', nil, false, nil},
    Model = {'s', nil, false, nil},
    Coefficient = {'y', nil, false, nil},
    FanHealth = {'y', nil, false, nil},
    FanEntity = {'s', nil, false, nil},
    FrontPresence = {'y', nil, false, nil},
    RearPresence = {'y', nil, false, nil},
    FrontSpeed = {'q', nil, false, nil},
    RearSpeed = {'q', nil, false, nil},
    FrontStatus = {'y', nil, false, nil},
    RearStatus = {'y', nil, false, nil},
    FrontRPM = {'q', nil, false, nil},
    RearRPM = {'q', nil, false, nil},
    HardwarePWM = {'d', nil, false, nil},
    PWMPercentage = {'u', nil, false, nil},
    ExpectedPWM = {'d', nil, false, nil},
    FanAlarmLed = {'y', nil, false, nil},
    BOM = {'s', nil, false, nil},
    SystemId = {'y', nil, false, nil},
    MaxSupportedPWM = {'u', nil, false, nil},
    IdentifySpeedLevel = {'y', nil, false, nil},
    PartNumber = {'s', nil, false, nil},
    FrontMaxSpeed = {'u', nil, false, nil},
    RearMaxSpeed = {'u', nil, false, nil},
    IsTwins = {'b', nil, false, nil}
}, {}, {})

---@class IFanType: Table
---@field Name string
---@field Index integer
---@field IsDefaultType boolean
---@field IsTwins boolean
---@field FrontMaxSpeed integer
---@field RearMaxSpeed integer
---@field IdentifyRangeLow integer
---@field IdentifyRangeHigh integer
---@field MatchedCount integer
---@field PartNumber string
---@field BOM string
---@field SystemId integer
ThermalMgmt.IFanType = Mdb.register_interface('bmc.kepler.Systems.FanType', {
    Name = {'s', nil, false, nil},
    Index = {'y', nil, false, nil},
    IsDefaultType = {'b', nil, false, nil},
    IsTwins = {'b', nil, false, nil},
    FrontMaxSpeed = {'u', nil, false, nil},
    RearMaxSpeed = {'u', nil, false, nil},
    IdentifyRangeLow = {'u', nil, false, nil},
    IdentifyRangeHigh = {'u', nil, false, nil},
    MatchedCount = {'y', nil, false, nil},
    PartNumber = {'s', nil, false, nil},
    BOM = {'s', nil, false, nil},
    SystemId = {'y', nil, false, nil}
}, {}, {})

return ThermalMgmt
