-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local Volume = {}

local Mdb = require 'mc.mdb'

---@class Volume: Table
---@field Id integer
---@field VolumeName string
---@field OptimumIOSizeBytes integer
---@field DefaultReadPolicy integer
---@field DefaultWritePolicy integer
Volume.Volume = Mdb.register_interface('bmc.kepler.Systems.Storage.Volume', {
    Id = {'q', nil, true, nil},
    VolumeName = {'s', nil, true, nil},
    OptimumIOSizeBytes = {'u', nil, true, nil},
    DefaultReadPolicy = {'y', nil, true, nil},
    DefaultWritePolicy = {'y', nil, true, nil}
}, {}, {})
return Volume
