-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local Processor = {}

local Mdb = require 'mc.mdb'

---@class Processor: Table
---@field ProcessorType string
---@field SystemId integer
---@field Id integer
---@field Name string
---@field Presence boolean
---@field InstructionSet string
---@field Architecture string
---@field Manufacturer string
---@field Model string
---@field PartNumber string
---@field SN string
---@field FirmwareVersion string
---@field SocketDesignation string
---@field Container string
Processor.Processor = Mdb.register_interface('bmc.kepler.Systems.Processor', {
    ProcessorType = {'s', nil, true, nil},
    SystemId = {'y', nil, true, nil},
    Id = {'y', nil, true, nil},
    Name = {'s', nil, true, nil},
    Presence = {'b', nil, true, nil},
    InstructionSet = {'s', nil, true, nil},
    Architecture = {'s', nil, true, nil},
    Manufacturer = {'s', nil, true, nil},
    Model = {'s', nil, true, nil},
    PartNumber = {'s', nil, true, nil},
    SN = {'s', nil, true, nil},
    FirmwareVersion = {'s', nil, true, nil},
    SocketDesignation = {'s', nil, true, nil},
    Container = {'s', nil, true, nil}
}, {}, {})
return Processor
