-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local PCIeDevice = {}

local Mdb = require 'mc.mdb'

---@class IPCIeDeviceInfo: Table
---@field Manufacturer string
---@field CardDesc string
PCIeDevice.IPCIeDeviceInfo = Mdb.register_interface('bmc.mdb.Systems.PCIeDeviceInfo', {
    Manufacturer = {'s', nil, true, nil},
    CardDesc = {'s', nil, true, nil}
}, {}, {})

---@class IPcieAddrInfo: Table
---@field GroupID integer
---@field SlotID integer
---@field ComponentType integer
---@field ControllerIndex integer
---@field ControllerType integer
---@field SocketID integer
---@field Segment integer
---@field Bus integer
---@field Device integer
---@field Function integer
---@field VendorID integer
---@field DeviceID integer
PCIeDevice.IPcieAddrInfo = Mdb.register_interface('bmc.kepler.Systems.PcieAddrInfo', {
    GroupID = {'y', nil, false, nil},
    SlotID = {'y', nil, false, nil},
    ComponentType = {'y', nil, false, nil},
    ControllerIndex = {'y', nil, false, nil},
    ControllerType = {'y', nil, false, nil},
    SocketID = {'y', nil, false, nil},
    Segment = {'y', nil, false, nil},
    Bus = {'y', nil, false, nil},
    Device = {'y', nil, false, nil},
    Function = {'y', nil, false, nil},
    VendorID = {'q', nil, false, nil},
    DeviceID = {'q', nil, false, nil}
}, {}, {})

---@class BizTopoNode: Table
---@field SystemID integer
PCIeDevice.BizTopoNode = Mdb.register_interface('bmc.kepler.Systems.BizTopoNode',
    {SystemID = {'y', nil, true, nil}}, {}, {})

return PCIeDevice
