-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local MemoryChannel = {}

local Mdb = require 'mc.mdb'

---@class MemoryChannel: Table
---@field Name string
---@field LogicalCpuId integer
---@field PhysicalChannelId integer
---@field LogicalChannelId integer
---@field DiagnosticFault integer
---@field SystemId integer
MemoryChannel.MemoryChannel = Mdb.register_interface('bmc.kepler.Systems.MemoryChannel', {
    Name = {'s', nil, true, nil},
    LogicalCpuId = {'y', nil, true, nil},
    PhysicalChannelId = {'y', nil, true, nil},
    LogicalChannelId = {'y', nil, true, nil},
    DiagnosticFault = {'y', nil, true, 0},
    SystemId = {'y', nil, true, nil}
}, {}, {})
return MemoryChannel
