-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local Board = {}

local Mdb = require 'mc.mdb'

---@class Board: Table
---@field MfgDate string
---@field BoardManufacturer string
---@field BoardProductName string
---@field BoardSerialNumber string
---@field BoardPartNumber string
---@field BoardFRUFileID string
---@field BoardCustomInfo string
Board.Board = Mdb.register_interface('bmc.kepler.Systems.FruData.Board', {
    MfgDate = {'s', nil, true, nil},
    BoardManufacturer = {'s', nil, true, nil},
    BoardProductName = {'s', nil, true, nil},
    BoardSerialNumber = {'s', nil, true, nil},
    BoardPartNumber = {'s', nil, true, nil},
    BoardFRUFileID = {'s', nil, true, nil},
    BoardCustomInfo = {'s', nil, true, nil}
}, {}, {})
return Board
