-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local Fan = {}

local Mdb = require 'mc.mdb'

---@class Fan: Table
---@field FanId integer
---@field Slot integer
---@field Type integer
---@field Model string
---@field Coefficient integer
---@field FanHealth integer
---@field FanEntity string
---@field FrontPresence integer
---@field RearPresence integer
---@field FrontSpeed integer
---@field RearSpeed integer
---@field FrontStatus integer
---@field RearStatus integer
---@field FrontRPM integer
---@field RearRPM integer
---@field HardwarePWM number
---@field PWMPercentage integer
---@field ExpectedPWM number
---@field FanAlarmLed integer
---@field BOM string
---@field SystemId integer
---@field MaxSupportedPWM integer
---@field IdentifySpeedLevel integer
---@field PartNumber string
---@field FrontMaxSpeed integer
---@field RearMaxSpeed integer
---@field IsTwins boolean
Fan.Fan = Mdb.register_interface('bmc.kepler.Systems.Fan', {
    FanId = {'q', nil, true, nil},
    Slot = {'y', nil, true, nil},
    Type = {'y', nil, true, nil},
    Model = {'s', nil, true, nil},
    Coefficient = {'y', nil, true, nil},
    FanHealth = {'y', nil, true, nil},
    FanEntity = {'s', nil, true, nil},
    FrontPresence = {'y', nil, false, nil},
    RearPresence = {'y', nil, false, nil},
    FrontSpeed = {'q', nil, false, nil},
    RearSpeed = {'q', nil, false, nil},
    FrontStatus = {'y', nil, true, nil},
    RearStatus = {'y', nil, true, nil},
    FrontRPM = {'q', nil, true, nil},
    RearRPM = {'q', nil, true, nil},
    HardwarePWM = {'d', nil, false, nil},
    PWMPercentage = {'u', nil, true, nil},
    ExpectedPWM = {'d', nil, false, nil},
    FanAlarmLed = {'y', nil, true, nil},
    BOM = {'s', nil, true, nil},
    SystemId = {'y', nil, true, nil},
    MaxSupportedPWM = {'u', nil, true, nil},
    IdentifySpeedLevel = {'y', nil, true, nil},
    PartNumber = {'s', nil, true, nil},
    FrontMaxSpeed = {'u', nil, true, nil},
    RearMaxSpeed = {'u', nil, true, nil},
    IsTwins = {'b', nil, true, nil}
}, {}, {})
return Fan
