-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local Component = {}

local Mdb = require 'mc.mdb'

---@class Component: Table
---@field FruId integer
---@field Index integer
---@field Type integer
---@field Name string
---@field Presence integer
---@field Health integer
---@field PowerState integer
Component.Component = Mdb.register_interface('bmc.kepler.Systems.Component', {
    FruId = {'y', nil, true, nil},
    Index = {'y', nil, true, nil},
    Type = {'y', nil, true, nil},
    Name = {'s', nil, false, nil},
    Presence = {'y', nil, true, nil},
    Health = {'y', nil, false, nil},
    PowerState = {'y', nil, true, nil}
}, {}, {})
return Component
