-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class Scm3Msg.GetEfuseStateRsp
---@field EfuseState integer
local TGetEfuseStateRsp = {}
TGetEfuseStateRsp.__index = TGetEfuseStateRsp
TGetEfuseStateRsp.group = {}

local function TGetEfuseStateRsp_from_obj(obj)
    return setmetatable(obj, TGetEfuseStateRsp)
end

function TGetEfuseStateRsp.new(EfuseState)
    return TGetEfuseStateRsp_from_obj({EfuseState = EfuseState})
end
---@param obj Scm3Msg.GetEfuseStateRsp
function TGetEfuseStateRsp:init_from_obj(obj)
    self.EfuseState = obj.EfuseState
end

function TGetEfuseStateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetEfuseStateRsp.group)
end

TGetEfuseStateRsp.from_obj = TGetEfuseStateRsp_from_obj

TGetEfuseStateRsp.proto_property = {'EfuseState'}

TGetEfuseStateRsp.default = {0}

TGetEfuseStateRsp.struct = {{name = 'EfuseState', is_array = false, struct = nil}}

function TGetEfuseStateRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'EfuseState', self.EfuseState, 'uint8', false, errs)

    TGetEfuseStateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetEfuseStateRsp.proto_property, errs)
    return self
end

function TGetEfuseStateRsp:unpack(_)
    return self.EfuseState
end

msg.GetEfuseStateRsp = TGetEfuseStateRsp

---@class Scm3Msg.GetEfuseTypeRsp
---@field EfuseType integer
local TGetEfuseTypeRsp = {}
TGetEfuseTypeRsp.__index = TGetEfuseTypeRsp
TGetEfuseTypeRsp.group = {}

local function TGetEfuseTypeRsp_from_obj(obj)
    return setmetatable(obj, TGetEfuseTypeRsp)
end

function TGetEfuseTypeRsp.new(EfuseType)
    return TGetEfuseTypeRsp_from_obj({EfuseType = EfuseType})
end
---@param obj Scm3Msg.GetEfuseTypeRsp
function TGetEfuseTypeRsp:init_from_obj(obj)
    self.EfuseType = obj.EfuseType
end

function TGetEfuseTypeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetEfuseTypeRsp.group)
end

TGetEfuseTypeRsp.from_obj = TGetEfuseTypeRsp_from_obj

TGetEfuseTypeRsp.proto_property = {'EfuseType'}

TGetEfuseTypeRsp.default = {0}

TGetEfuseTypeRsp.struct = {{name = 'EfuseType', is_array = false, struct = nil}}

function TGetEfuseTypeRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'EfuseType', self.EfuseType, 'uint8', false, errs)

    TGetEfuseTypeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetEfuseTypeRsp.proto_property, errs)
    return self
end

function TGetEfuseTypeRsp:unpack(_)
    return self.EfuseType
end

msg.GetEfuseTypeRsp = TGetEfuseTypeRsp

---@class Scm3Msg.VerifyPartnerH2pInfoRsp
---@field VerifyResult integer
local TVerifyPartnerH2pInfoRsp = {}
TVerifyPartnerH2pInfoRsp.__index = TVerifyPartnerH2pInfoRsp
TVerifyPartnerH2pInfoRsp.group = {}

local function TVerifyPartnerH2pInfoRsp_from_obj(obj)
    return setmetatable(obj, TVerifyPartnerH2pInfoRsp)
end

function TVerifyPartnerH2pInfoRsp.new(VerifyResult)
    return TVerifyPartnerH2pInfoRsp_from_obj({VerifyResult = VerifyResult})
end
---@param obj Scm3Msg.VerifyPartnerH2pInfoRsp
function TVerifyPartnerH2pInfoRsp:init_from_obj(obj)
    self.VerifyResult = obj.VerifyResult
end

function TVerifyPartnerH2pInfoRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVerifyPartnerH2pInfoRsp.group)
end

TVerifyPartnerH2pInfoRsp.from_obj = TVerifyPartnerH2pInfoRsp_from_obj

TVerifyPartnerH2pInfoRsp.proto_property = {'VerifyResult'}

TVerifyPartnerH2pInfoRsp.default = {0}

TVerifyPartnerH2pInfoRsp.struct = {{name = 'VerifyResult', is_array = false, struct = nil}}

function TVerifyPartnerH2pInfoRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'VerifyResult', self.VerifyResult, 'uint8', false, errs)

    TVerifyPartnerH2pInfoRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVerifyPartnerH2pInfoRsp.proto_property, errs)
    return self
end

function TVerifyPartnerH2pInfoRsp:unpack(_)
    return self.VerifyResult
end

msg.VerifyPartnerH2pInfoRsp = TVerifyPartnerH2pInfoRsp

local Scm3Msg = {}

local Mdb = require 'mc.mdb'

---@class Scm3Msg: Table
Scm3Msg.Scm3Msg = Mdb.register_interface('bmc.kepler.Soc.Scm3Msg', {}, {
    VerifyPartnerH2pInfo = {'a{ss}', 'y', nil, msg.VerifyPartnerH2pInfoRsp},
    GetEfuseType = {'a{ss}', 'y', nil, msg.GetEfuseTypeRsp},
    GetEfuseState = {'a{ss}', 'y', nil, msg.GetEfuseStateRsp}
}, {})
return Scm3Msg
