-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class KeyMouse.DisconnectRsp
local TDisconnectRsp = {}
TDisconnectRsp.__index = TDisconnectRsp
TDisconnectRsp.group = {}

local function TDisconnectRsp_from_obj(obj)
    return setmetatable(obj, TDisconnectRsp)
end

function TDisconnectRsp.new()
    return TDisconnectRsp_from_obj({})
end
---@param obj KeyMouse.DisconnectRsp
function TDisconnectRsp:init_from_obj(obj)

end

function TDisconnectRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDisconnectRsp.group)
end

TDisconnectRsp.from_obj = TDisconnectRsp_from_obj

TDisconnectRsp.proto_property = {}

TDisconnectRsp.default = {}

TDisconnectRsp.struct = {}

function TDisconnectRsp:validate(prefix, errs)
    prefix = prefix or ''

    TDisconnectRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDisconnectRsp.proto_property, errs)
    return self
end

function TDisconnectRsp:unpack(_)
end

msg.DisconnectRsp = TDisconnectRsp

---@class KeyMouse.DisconnectReq
local TDisconnectReq = {}
TDisconnectReq.__index = TDisconnectReq
TDisconnectReq.group = {}

local function TDisconnectReq_from_obj(obj)
    return setmetatable(obj, TDisconnectReq)
end

function TDisconnectReq.new()
    return TDisconnectReq_from_obj({})
end
---@param obj KeyMouse.DisconnectReq
function TDisconnectReq:init_from_obj(obj)

end

function TDisconnectReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDisconnectReq.group)
end

TDisconnectReq.from_obj = TDisconnectReq_from_obj

TDisconnectReq.proto_property = {}

TDisconnectReq.default = {}

TDisconnectReq.struct = {}

function TDisconnectReq:validate(prefix, errs)
    prefix = prefix or ''

    TDisconnectReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDisconnectReq.proto_property, errs)
    return self
end

function TDisconnectReq:unpack(_)
end

msg.DisconnectReq = TDisconnectReq

---@class KeyMouse.ResetRsp
---@field KeyUsbId integer
---@field KeyFuncId integer
---@field MouseUsbId integer
---@field MouseFuncId integer
local TResetRsp = {}
TResetRsp.__index = TResetRsp
TResetRsp.group = {}

local function TResetRsp_from_obj(obj)
    return setmetatable(obj, TResetRsp)
end

function TResetRsp.new(KeyUsbId, KeyFuncId, MouseUsbId, MouseFuncId)
    return TResetRsp_from_obj({
        KeyUsbId = KeyUsbId,
        KeyFuncId = KeyFuncId,
        MouseUsbId = MouseUsbId,
        MouseFuncId = MouseFuncId
    })
end
---@param obj KeyMouse.ResetRsp
function TResetRsp:init_from_obj(obj)
    self.KeyUsbId = obj.KeyUsbId
    self.KeyFuncId = obj.KeyFuncId
    self.MouseUsbId = obj.MouseUsbId
    self.MouseFuncId = obj.MouseFuncId
end

function TResetRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetRsp.group)
end

TResetRsp.from_obj = TResetRsp_from_obj

TResetRsp.proto_property = {'KeyUsbId', 'KeyFuncId', 'MouseUsbId', 'MouseFuncId'}

TResetRsp.default = {0, 0, 0, 0}

TResetRsp.struct = {
    {name = 'KeyUsbId', is_array = false, struct = nil},
    {name = 'KeyFuncId', is_array = false, struct = nil},
    {name = 'MouseUsbId', is_array = false, struct = nil},
    {name = 'MouseFuncId', is_array = false, struct = nil}
}

function TResetRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'KeyUsbId', self.KeyUsbId, 'uint32', false, errs)
    validate.Required(prefix .. 'KeyFuncId', self.KeyFuncId, 'uint32', false, errs)
    validate.Required(prefix .. 'MouseUsbId', self.MouseUsbId, 'uint32', false, errs)
    validate.Required(prefix .. 'MouseFuncId', self.MouseFuncId, 'uint32', false, errs)

    TResetRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetRsp.proto_property, errs)
    return self
end

function TResetRsp:unpack(_)
    return self.KeyUsbId, self.KeyFuncId, self.MouseUsbId, self.MouseFuncId
end

msg.ResetRsp = TResetRsp

---@class KeyMouse.ResetReq
local TResetReq = {}
TResetReq.__index = TResetReq
TResetReq.group = {}

local function TResetReq_from_obj(obj)
    return setmetatable(obj, TResetReq)
end

function TResetReq.new()
    return TResetReq_from_obj({})
end
---@param obj KeyMouse.ResetReq
function TResetReq:init_from_obj(obj)

end

function TResetReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetReq.group)
end

TResetReq.from_obj = TResetReq_from_obj

TResetReq.proto_property = {}

TResetReq.default = {}

TResetReq.struct = {}

function TResetReq:validate(prefix, errs)
    prefix = prefix or ''

    TResetReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetReq.proto_property, errs)
    return self
end

function TResetReq:unpack(_)
end

msg.ResetReq = TResetReq

---@class KeyMouse.ConnectRsp
---@field KeyUsbId integer
---@field KeyFuncId integer
---@field MouseUsbId integer
---@field MouseFuncId integer
local TConnectRsp = {}
TConnectRsp.__index = TConnectRsp
TConnectRsp.group = {}

local function TConnectRsp_from_obj(obj)
    return setmetatable(obj, TConnectRsp)
end

function TConnectRsp.new(KeyUsbId, KeyFuncId, MouseUsbId, MouseFuncId)
    return TConnectRsp_from_obj({
        KeyUsbId = KeyUsbId,
        KeyFuncId = KeyFuncId,
        MouseUsbId = MouseUsbId,
        MouseFuncId = MouseFuncId
    })
end
---@param obj KeyMouse.ConnectRsp
function TConnectRsp:init_from_obj(obj)
    self.KeyUsbId = obj.KeyUsbId
    self.KeyFuncId = obj.KeyFuncId
    self.MouseUsbId = obj.MouseUsbId
    self.MouseFuncId = obj.MouseFuncId
end

function TConnectRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConnectRsp.group)
end

TConnectRsp.from_obj = TConnectRsp_from_obj

TConnectRsp.proto_property = {'KeyUsbId', 'KeyFuncId', 'MouseUsbId', 'MouseFuncId'}

TConnectRsp.default = {0, 0, 0, 0}

TConnectRsp.struct = {
    {name = 'KeyUsbId', is_array = false, struct = nil},
    {name = 'KeyFuncId', is_array = false, struct = nil},
    {name = 'MouseUsbId', is_array = false, struct = nil},
    {name = 'MouseFuncId', is_array = false, struct = nil}
}

function TConnectRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'KeyUsbId', self.KeyUsbId, 'uint32', false, errs)
    validate.Required(prefix .. 'KeyFuncId', self.KeyFuncId, 'uint32', false, errs)
    validate.Required(prefix .. 'MouseUsbId', self.MouseUsbId, 'uint32', false, errs)
    validate.Required(prefix .. 'MouseFuncId', self.MouseFuncId, 'uint32', false, errs)

    TConnectRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConnectRsp.proto_property, errs)
    return self
end

function TConnectRsp:unpack(_)
    return self.KeyUsbId, self.KeyFuncId, self.MouseUsbId, self.MouseFuncId
end

msg.ConnectRsp = TConnectRsp

---@class KeyMouse.ConnectReq
local TConnectReq = {}
TConnectReq.__index = TConnectReq
TConnectReq.group = {}

local function TConnectReq_from_obj(obj)
    return setmetatable(obj, TConnectReq)
end

function TConnectReq.new()
    return TConnectReq_from_obj({})
end
---@param obj KeyMouse.ConnectReq
function TConnectReq:init_from_obj(obj)

end

function TConnectReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConnectReq.group)
end

TConnectReq.from_obj = TConnectReq_from_obj

TConnectReq.proto_property = {}

TConnectReq.default = {}

TConnectReq.struct = {}

function TConnectReq:validate(prefix, errs)
    prefix = prefix or ''

    TConnectReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConnectReq.proto_property, errs)
    return self
end

function TConnectReq:unpack(_)
end

msg.ConnectReq = TConnectReq

local KeyMouse = {}

local Mdb = require 'mc.mdb'

---@class KeyMouse: Table
---@field ConnectState integer
---@field MouseMode integer
KeyMouse.KeyMouse = Mdb.register_interface('bmc.kepler.Managers.UsbDevice.KeyMouse', {
    ConnectState = {'u', nil, true, nil},
    MouseMode = {'u', nil, false, nil}
}, {
    Connect = {'a{ss}', 'uuuu', msg.ConnectReq, msg.ConnectRsp},
    Reset = {'a{ss}', 'uuuu', msg.ResetReq, msg.ResetRsp},
    Disconnect = {'a{ss}', '', msg.DisconnectReq, msg.DisconnectRsp}
}, {})
return KeyMouse
