-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class Cdrom.DisconnectRsp
local TDisconnectRsp = {}
TDisconnectRsp.__index = TDisconnectRsp
TDisconnectRsp.group = {}

local function TDisconnectRsp_from_obj(obj)
    return setmetatable(obj, TDisconnectRsp)
end

function TDisconnectRsp.new()
    return TDisconnectRsp_from_obj({})
end
---@param obj Cdrom.DisconnectRsp
function TDisconnectRsp:init_from_obj(obj)

end

function TDisconnectRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDisconnectRsp.group)
end

TDisconnectRsp.from_obj = TDisconnectRsp_from_obj

TDisconnectRsp.proto_property = {}

TDisconnectRsp.default = {}

TDisconnectRsp.struct = {}

function TDisconnectRsp:validate(prefix, errs)
    prefix = prefix or ''

    TDisconnectRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDisconnectRsp.proto_property, errs)
    return self
end

function TDisconnectRsp:unpack(_)
end

msg.DisconnectRsp = TDisconnectRsp

---@class Cdrom.DisconnectReq
local TDisconnectReq = {}
TDisconnectReq.__index = TDisconnectReq
TDisconnectReq.group = {}

local function TDisconnectReq_from_obj(obj)
    return setmetatable(obj, TDisconnectReq)
end

function TDisconnectReq.new()
    return TDisconnectReq_from_obj({})
end
---@param obj Cdrom.DisconnectReq
function TDisconnectReq:init_from_obj(obj)

end

function TDisconnectReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDisconnectReq.group)
end

TDisconnectReq.from_obj = TDisconnectReq_from_obj

TDisconnectReq.proto_property = {}

TDisconnectReq.default = {}

TDisconnectReq.struct = {}

function TDisconnectReq:validate(prefix, errs)
    prefix = prefix or ''

    TDisconnectReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDisconnectReq.proto_property, errs)
    return self
end

function TDisconnectReq:unpack(_)
end

msg.DisconnectReq = TDisconnectReq

---@class Cdrom.ConnectRsp
---@field UsbId integer
---@field FuncId integer
local TConnectRsp = {}
TConnectRsp.__index = TConnectRsp
TConnectRsp.group = {}

local function TConnectRsp_from_obj(obj)
    return setmetatable(obj, TConnectRsp)
end

function TConnectRsp.new(UsbId, FuncId)
    return TConnectRsp_from_obj({UsbId = UsbId, FuncId = FuncId})
end
---@param obj Cdrom.ConnectRsp
function TConnectRsp:init_from_obj(obj)
    self.UsbId = obj.UsbId
    self.FuncId = obj.FuncId
end

function TConnectRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConnectRsp.group)
end

TConnectRsp.from_obj = TConnectRsp_from_obj

TConnectRsp.proto_property = {'UsbId', 'FuncId'}

TConnectRsp.default = {0, 0}

TConnectRsp.struct = {
    {name = 'UsbId', is_array = false, struct = nil},
    {name = 'FuncId', is_array = false, struct = nil}
}

function TConnectRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'UsbId', self.UsbId, 'uint32', false, errs)
    validate.Required(prefix .. 'FuncId', self.FuncId, 'uint32', false, errs)

    TConnectRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConnectRsp.proto_property, errs)
    return self
end

function TConnectRsp:unpack(_)
    return self.UsbId, self.FuncId
end

msg.ConnectRsp = TConnectRsp

---@class Cdrom.ConnectReq
local TConnectReq = {}
TConnectReq.__index = TConnectReq
TConnectReq.group = {}

local function TConnectReq_from_obj(obj)
    return setmetatable(obj, TConnectReq)
end

function TConnectReq.new()
    return TConnectReq_from_obj({})
end
---@param obj Cdrom.ConnectReq
function TConnectReq:init_from_obj(obj)

end

function TConnectReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConnectReq.group)
end

TConnectReq.from_obj = TConnectReq_from_obj

TConnectReq.proto_property = {}

TConnectReq.default = {}

TConnectReq.struct = {}

function TConnectReq:validate(prefix, errs)
    prefix = prefix or ''

    TConnectReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConnectReq.proto_property, errs)
    return self
end

function TConnectReq:unpack(_)
end

msg.ConnectReq = TConnectReq

local Cdrom = {}

local Mdb = require 'mc.mdb'

---@class Cdrom: Table
---@field ConnectState integer
Cdrom.Cdrom = Mdb.register_interface('bmc.kepler.Managers.UsbDevice.Cdrom',
    {ConnectState = {'u', nil, true, nil}}, {
        Connect = {'a{ss}', 'uu', msg.ConnectReq, msg.ConnectRsp},
        Disconnect = {'a{ss}', '', msg.DisconnectReq, msg.DisconnectRsp}
    }, {})
return Cdrom
