-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class UartCircularLog.DumpReq
---@field UartId integer
---@field Direction integer
---@field Length integer
---@field FileName string
local TDumpReq = {}
TDumpReq.__index = TDumpReq
TDumpReq.group = {}

local function TDumpReq_from_obj(obj)
    return setmetatable(obj, TDumpReq)
end

function TDumpReq.new(UartId, Direction, Length, FileName)
    return TDumpReq_from_obj({
        UartId = UartId,
        Direction = Direction,
        Length = Length,
        FileName = FileName
    })
end
---@param obj UartCircularLog.DumpReq
function TDumpReq:init_from_obj(obj)
    self.UartId = obj.UartId
    self.Direction = obj.Direction
    self.Length = obj.Length
    self.FileName = obj.FileName
end

function TDumpReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDumpReq.group)
end

TDumpReq.from_obj = TDumpReq_from_obj

TDumpReq.proto_property = {'UartId', 'Direction', 'Length', 'FileName'}

TDumpReq.default = {0, 0, 0, ''}

TDumpReq.struct = {
    {name = 'UartId', is_array = false, struct = nil},
    {name = 'Direction', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil},
    {name = 'FileName', is_array = false, struct = nil}
}

function TDumpReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'UartId', self.UartId, 'uint32', false, errs)
    validate.Required(prefix .. 'Direction', self.Direction, 'uint32', false, errs)
    validate.Required(prefix .. 'Length', self.Length, 'uint32', false, errs)
    validate.Required(prefix .. 'FileName', self.FileName, 'string', false, errs)

    TDumpReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDumpReq.proto_property, errs)
    return self
end

function TDumpReq:unpack(_)
    return self.UartId, self.Direction, self.Length, self.FileName
end

msg.DumpReq = TDumpReq

---@class UartCircularLog.GetPositionRsp
---@field Ah integer
---@field PosBase integer
---@field PosOffset integer
local TGetPositionRsp = {}
TGetPositionRsp.__index = TGetPositionRsp
TGetPositionRsp.group = {}

local function TGetPositionRsp_from_obj(obj)
    return setmetatable(obj, TGetPositionRsp)
end

function TGetPositionRsp.new(Ah, PosBase, PosOffset)
    return TGetPositionRsp_from_obj({Ah = Ah, PosBase = PosBase, PosOffset = PosOffset})
end
---@param obj UartCircularLog.GetPositionRsp
function TGetPositionRsp:init_from_obj(obj)
    self.Ah = obj.Ah
    self.PosBase = obj.PosBase
    self.PosOffset = obj.PosOffset
end

function TGetPositionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPositionRsp.group)
end

TGetPositionRsp.from_obj = TGetPositionRsp_from_obj

TGetPositionRsp.proto_property = {'Ah', 'PosBase', 'PosOffset'}

TGetPositionRsp.default = {0, 0, 0}

TGetPositionRsp.struct = {
    {name = 'Ah', is_array = false, struct = nil},
    {name = 'PosBase', is_array = false, struct = nil},
    {name = 'PosOffset', is_array = false, struct = nil}
}

function TGetPositionRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Ah', self.Ah, 'uint32', false, errs)
    validate.Required(prefix .. 'PosBase', self.PosBase, 'uint32', false, errs)
    validate.Required(prefix .. 'PosOffset', self.PosOffset, 'uint32', false, errs)

    TGetPositionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPositionRsp.proto_property, errs)
    return self
end

function TGetPositionRsp:unpack(_)
    return self.Ah, self.PosBase, self.PosOffset
end

msg.GetPositionRsp = TGetPositionRsp

---@class UartCircularLog.GetPositionReq
---@field UartId integer
local TGetPositionReq = {}
TGetPositionReq.__index = TGetPositionReq
TGetPositionReq.group = {}

local function TGetPositionReq_from_obj(obj)
    return setmetatable(obj, TGetPositionReq)
end

function TGetPositionReq.new(UartId)
    return TGetPositionReq_from_obj({UartId = UartId})
end
---@param obj UartCircularLog.GetPositionReq
function TGetPositionReq:init_from_obj(obj)
    self.UartId = obj.UartId
end

function TGetPositionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPositionReq.group)
end

TGetPositionReq.from_obj = TGetPositionReq_from_obj

TGetPositionReq.proto_property = {'UartId'}

TGetPositionReq.default = {0}

TGetPositionReq.struct = {{name = 'UartId', is_array = false, struct = nil}}

function TGetPositionReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'UartId', self.UartId, 'uint32', false, errs)

    TGetPositionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPositionReq.proto_property, errs)
    return self
end

function TGetPositionReq:unpack(_)
    return self.UartId
end

msg.GetPositionReq = TGetPositionReq

---@class UartCircularLog.SetLogSizeReq
---@field UartId integer
---@field Ah integer
---@field RxBase integer
---@field TxBase integer
---@field RxSize integer
---@field TxSize integer
local TSetLogSizeReq = {}
TSetLogSizeReq.__index = TSetLogSizeReq
TSetLogSizeReq.group = {}

local function TSetLogSizeReq_from_obj(obj)
    return setmetatable(obj, TSetLogSizeReq)
end

function TSetLogSizeReq.new(UartId, Ah, RxBase, TxBase, RxSize, TxSize)
    return TSetLogSizeReq_from_obj({
        UartId = UartId,
        Ah = Ah,
        RxBase = RxBase,
        TxBase = TxBase,
        RxSize = RxSize,
        TxSize = TxSize
    })
end
---@param obj UartCircularLog.SetLogSizeReq
function TSetLogSizeReq:init_from_obj(obj)
    self.UartId = obj.UartId
    self.Ah = obj.Ah
    self.RxBase = obj.RxBase
    self.TxBase = obj.TxBase
    self.RxSize = obj.RxSize
    self.TxSize = obj.TxSize
end

function TSetLogSizeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetLogSizeReq.group)
end

TSetLogSizeReq.from_obj = TSetLogSizeReq_from_obj

TSetLogSizeReq.proto_property = {'UartId', 'Ah', 'RxBase', 'TxBase', 'RxSize', 'TxSize'}

TSetLogSizeReq.default = {0, 0, 0, 0, 0, 0}

TSetLogSizeReq.struct = {
    {name = 'UartId', is_array = false, struct = nil},
    {name = 'Ah', is_array = false, struct = nil},
    {name = 'RxBase', is_array = false, struct = nil},
    {name = 'TxBase', is_array = false, struct = nil},
    {name = 'RxSize', is_array = false, struct = nil},
    {name = 'TxSize', is_array = false, struct = nil}
}

function TSetLogSizeReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'UartId', self.UartId, 'uint32', false, errs)
    validate.Required(prefix .. 'Ah', self.Ah, 'uint32', false, errs)
    validate.Required(prefix .. 'RxBase', self.RxBase, 'uint32', false, errs)
    validate.Required(prefix .. 'TxBase', self.TxBase, 'uint32', false, errs)
    validate.Required(prefix .. 'RxSize', self.RxSize, 'uint32', false, errs)
    validate.Required(prefix .. 'TxSize', self.TxSize, 'uint32', false, errs)

    TSetLogSizeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetLogSizeReq.proto_property, errs)
    return self
end

function TSetLogSizeReq:unpack(_)
    return self.UartId, self.Ah, self.RxBase, self.TxBase, self.RxSize, self.TxSize
end

msg.SetLogSizeReq = TSetLogSizeReq

---@class UartCircularLog.EnableReq
---@field UartId integer
---@field Enable integer
local TEnableReq = {}
TEnableReq.__index = TEnableReq
TEnableReq.group = {}

local function TEnableReq_from_obj(obj)
    return setmetatable(obj, TEnableReq)
end

function TEnableReq.new(UartId, Enable)
    return TEnableReq_from_obj({UartId = UartId, Enable = Enable})
end
---@param obj UartCircularLog.EnableReq
function TEnableReq:init_from_obj(obj)
    self.UartId = obj.UartId
    self.Enable = obj.Enable
end

function TEnableReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnableReq.group)
end

TEnableReq.from_obj = TEnableReq_from_obj

TEnableReq.proto_property = {'UartId', 'Enable'}

TEnableReq.default = {0, 0}

TEnableReq.struct = {
    {name = 'UartId', is_array = false, struct = nil},
    {name = 'Enable', is_array = false, struct = nil}
}

function TEnableReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'UartId', self.UartId, 'uint32', false, errs)
    validate.Required(prefix .. 'Enable', self.Enable, 'uint32', false, errs)

    TEnableReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnableReq.proto_property, errs)
    return self
end

function TEnableReq:unpack(_)
    return self.UartId, self.Enable
end

msg.EnableReq = TEnableReq

local UartCircularLog = {}

local Mdb = require 'mc.mdb'

---@class UartCircularLog: Table
UartCircularLog.UartCircularLog = Mdb.register_interface('bmc.kepler.Managers.UartCircularLog', {},
    {
        Enable = {'a{ss}uu', '', msg.EnableReq, nil},
        SetLogSize = {'a{ss}uuuuuu', '', msg.SetLogSizeReq, nil},
        GetPosition = {'a{ss}u', 'uuu', msg.GetPositionReq, msg.GetPositionRsp},
        Dump = {'a{ss}uuus', '', msg.DumpReq, nil}
    }, {})
return UartCircularLog
