-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local Ntp = {}

local Mdb = require 'mc.mdb'

---@class Ntp: Table
---@field Enabled boolean
---@field AddressMode string
---@field PreferredServer string
---@field AlternateServer string
---@field ExtraServer string
---@field MinPollingInterval string
---@field MaxPollingInterval string
---@field AuthEnabled boolean
Ntp.Ntp = Mdb.register_interface('bmc.kepler.Managers.Ntp', {
    Enabled = {'b', nil, false, nil},
    AddressMode = {'s', nil, false, nil},
    PreferredServer = {'s', nil, false, nil},
    AlternateServer = {'s', nil, false, nil},
    ExtraServer = {'s', nil, false, nil},
    MinPollingInterval = {'s', nil, false, nil},
    MaxPollingInterval = {'s', nil, false, nil},
    AuthEnabled = {'b', nil, false, nil}
}, {}, {})
return Ntp
