-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class LogServices.DumpRsp
---@field TaskId integer
local TDumpRsp = {}
TDumpRsp.__index = TDumpRsp
TDumpRsp.group = {}

local function TDumpRsp_from_obj(obj)
    return setmetatable(obj, TDumpRsp)
end

function TDumpRsp.new(TaskId)
    return TDumpRsp_from_obj({TaskId = TaskId})
end
---@param obj LogServices.DumpRsp
function TDumpRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TDumpRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDumpRsp.group)
end

TDumpRsp.from_obj = TDumpRsp_from_obj

TDumpRsp.proto_property = {'TaskId'}

TDumpRsp.default = {0}

TDumpRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TDumpRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs)

    if self.TaskId ~= nil then
    end

    TDumpRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDumpRsp.proto_property, errs)
    return self
end

function TDumpRsp:unpack(_)
    return self.TaskId
end

msg.DumpRsp = TDumpRsp

---@class LogServices.DumpReq
---@field DomainUser integer
---@field FilePath string
local TDumpReq = {}
TDumpReq.__index = TDumpReq
TDumpReq.group = {}

local function TDumpReq_from_obj(obj)
    return setmetatable(obj, TDumpReq)
end

function TDumpReq.new(DomainUser, FilePath)
    return TDumpReq_from_obj({DomainUser = DomainUser, FilePath = FilePath})
end
---@param obj LogServices.DumpReq
function TDumpReq:init_from_obj(obj)
    self.DomainUser = obj.DomainUser
    self.FilePath = obj.FilePath
end

function TDumpReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDumpReq.group)
end

TDumpReq.from_obj = TDumpReq_from_obj

TDumpReq.proto_property = {'DomainUser', 'FilePath'}

TDumpReq.default = {0, ''}

TDumpReq.struct = {
    {name = 'DomainUser', is_array = false, struct = nil},
    {name = 'FilePath', is_array = false, struct = nil}
}

function TDumpReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Optional(prefix .. 'DomainUser', self.DomainUser, 'uint8', false, errs)
    validate.Optional(prefix .. 'FilePath', self.FilePath, 'string', false, errs)

    if self.DomainUser ~= nil then
    end
    if self.FilePath ~= nil then
    end

    TDumpReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDumpReq.proto_property, errs)
    return self
end

function TDumpReq:unpack(_)
    return self.DomainUser, self.FilePath
end

msg.DumpReq = TDumpReq

local LogServices = {}

local Mdb = require 'mc.mdb'

---@class LogServices: Table
LogServices.LogServices = Mdb.register_interface('bmc.kepler.Managers.LogServices', {}, {
    Dump = {'a{ss}ys', 'u', msg.DumpReq, msg.DumpRsp}
}, {})
return LogServices
