-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class defs.LogInfo
---@field Key string
---@field Value string
local TLogInfo = {}
TLogInfo.__index = TLogInfo
TLogInfo.group = {}

local function TLogInfo_from_obj(obj)
    return setmetatable(obj, TLogInfo)
end

function TLogInfo.new(Key, Value)
    return TLogInfo_from_obj({Key = Key, Value = Value})
end
---@param obj defs.LogInfo
function TLogInfo:init_from_obj(obj)
    self.Key = obj.Key
    self.Value = obj.Value
end

function TLogInfo:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLogInfo.group)
end

TLogInfo.from_obj = TLogInfo_from_obj

TLogInfo.proto_property = {'Key', 'Value'}

TLogInfo.default = {'', ''}

TLogInfo.struct = {
    {name = 'Key', is_array = false, struct = nil}, {name = 'Value', is_array = false, struct = nil}
}

function TLogInfo:validate(prefix, errs)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Key', self.Key, 'string', false, errs)
    validate.Optional(prefix .. 'Value', self.Value, 'string', false, errs)

    if self.Key ~= nil then
    end
    if self.Value ~= nil then
    end

    TLogInfo:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLogInfo.proto_property, errs)
    return self
end

function TLogInfo:unpack(_)
    return self.Key, self.Value
end

defs.LogInfo = TLogInfo

---@class defs.Items
---@field Params defs.LogInfo[]
local TItems = {}
TItems.__index = TItems
TItems.group = {}

local function TItems_from_obj(obj)
    obj.Params = utils.from_obj(defs.LogInfo, obj.Params, true)
    return setmetatable(obj, TItems)
end

function TItems.new(Params)
    return TItems_from_obj({Params = Params})
end
---@param obj defs.Items
function TItems:init_from_obj(obj)
    self.Params = obj.Params
end

function TItems:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TItems.group)
end

TItems.from_obj = TItems_from_obj

TItems.proto_property = {'Params'}

TItems.default = {{}}

TItems.struct = {{name = 'Params', is_array = true, struct = defs.LogInfo.struct}}

function TItems:validate(prefix, errs)
    prefix = prefix or ''

    validate.OptionalArray(prefix .. 'Params', self.Params, 'defs.LogInfo', false, errs)

    if self.Params ~= nil then
    end

    TItems:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TItems.proto_property, errs)
    return self
end

function TItems:unpack(raw)
    return utils.unpack(raw, self.Params, true)
end

defs.Items = TItems

---@class LogService.ExportLogRsp
---@field TaskId integer
local TExportLogRsp = {}
TExportLogRsp.__index = TExportLogRsp
TExportLogRsp.group = {}

local function TExportLogRsp_from_obj(obj)
    return setmetatable(obj, TExportLogRsp)
end

function TExportLogRsp.new(TaskId)
    return TExportLogRsp_from_obj({TaskId = TaskId})
end
---@param obj LogService.ExportLogRsp
function TExportLogRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TExportLogRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportLogRsp.group)
end

TExportLogRsp.from_obj = TExportLogRsp_from_obj

TExportLogRsp.proto_property = {'TaskId'}

TExportLogRsp.default = {0}

TExportLogRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TExportLogRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs)

    if self.TaskId ~= nil then
    end

    TExportLogRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportLogRsp.proto_property, errs)
    return self
end

function TExportLogRsp:unpack(_)
    return self.TaskId
end

msg.ExportLogRsp = TExportLogRsp

---@class LogService.ExportLogReq
---@field FilePath string
local TExportLogReq = {}
TExportLogReq.__index = TExportLogReq
TExportLogReq.group = {}

local function TExportLogReq_from_obj(obj)
    return setmetatable(obj, TExportLogReq)
end

function TExportLogReq.new(FilePath)
    return TExportLogReq_from_obj({FilePath = FilePath})
end
---@param obj LogService.ExportLogReq
function TExportLogReq:init_from_obj(obj)
    self.FilePath = obj.FilePath
end

function TExportLogReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportLogReq.group)
end

TExportLogReq.from_obj = TExportLogReq_from_obj

TExportLogReq.proto_property = {'FilePath'}

TExportLogReq.default = {''}

TExportLogReq.struct = {{name = 'FilePath', is_array = false, struct = nil}}

function TExportLogReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FilePath', self.FilePath, 'string', false, errs)

    if self.FilePath ~= nil then
    end

    TExportLogReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportLogReq.proto_property, errs)
    return self
end

function TExportLogReq:unpack(_)
    return self.FilePath
end

msg.ExportLogReq = TExportLogReq

---@class LogService.GetItemsRsp
---@field Count integer
---@field Log defs.Items[]
local TGetItemsRsp = {}
TGetItemsRsp.__index = TGetItemsRsp
TGetItemsRsp.group = {}

local function TGetItemsRsp_from_obj(obj)
    obj.Log = utils.from_obj(defs.Items, obj.Log, true)
    return setmetatable(obj, TGetItemsRsp)
end

function TGetItemsRsp.new(Count, Log)
    return TGetItemsRsp_from_obj({Count = Count, Log = Log})
end
---@param obj LogService.GetItemsRsp
function TGetItemsRsp:init_from_obj(obj)
    self.Count = obj.Count
    self.Log = obj.Log
end

function TGetItemsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetItemsRsp.group)
end

TGetItemsRsp.from_obj = TGetItemsRsp_from_obj

TGetItemsRsp.proto_property = {'Count', 'Log'}

TGetItemsRsp.default = {0, {}}

TGetItemsRsp.struct = {
    {name = 'Count', is_array = false, struct = nil},
    {name = 'Log', is_array = true, struct = defs.Items.struct}
}

function TGetItemsRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Count', self.Count, 'uint32', false, errs)
    validate.OptionalArray(prefix .. 'Log', self.Log, 'defs.Items', false, errs)

    if self.Count ~= nil then
    end
    if self.Log ~= nil then
    end

    TGetItemsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetItemsRsp.proto_property, errs)
    return self
end

function TGetItemsRsp:unpack(raw)
    return self.Count, utils.unpack(raw, self.Log, true)
end

msg.GetItemsRsp = TGetItemsRsp

---@class LogService.GetItemsReq
---@field Skip integer
---@field Top integer
local TGetItemsReq = {}
TGetItemsReq.__index = TGetItemsReq
TGetItemsReq.group = {}

local function TGetItemsReq_from_obj(obj)
    return setmetatable(obj, TGetItemsReq)
end

function TGetItemsReq.new(Skip, Top)
    return TGetItemsReq_from_obj({Skip = Skip, Top = Top})
end
---@param obj LogService.GetItemsReq
function TGetItemsReq:init_from_obj(obj)
    self.Skip = obj.Skip
    self.Top = obj.Top
end

function TGetItemsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetItemsReq.group)
end

TGetItemsReq.from_obj = TGetItemsReq_from_obj

TGetItemsReq.proto_property = {'Skip', 'Top'}

TGetItemsReq.default = {0, 0}

TGetItemsReq.struct = {
    {name = 'Skip', is_array = false, struct = nil}, {name = 'Top', is_array = false, struct = nil}
}

function TGetItemsReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Skip', self.Skip, 'uint16', false, errs)
    validate.Optional(prefix .. 'Top', self.Top, 'uint16', false, errs)

    if self.Skip ~= nil then
    end
    if self.Top ~= nil then
    end

    TGetItemsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetItemsReq.proto_property, errs)
    return self
end

function TGetItemsReq:unpack(_)
    return self.Skip, self.Top
end

msg.GetItemsReq = TGetItemsReq

local LogService = {}

local Mdb = require 'mc.mdb'

---@class LogService: Table
---@field Name string
---@field OverWritePolicy string
---@field ServiceEnabled boolean
LogService.LogService = Mdb.register_interface('bmc.kepler.Managers.LogService', {
    Name = {'s', nil, true, nil},
    OverWritePolicy = {'s', nil, true, 'WrapsWhenFull'},
    ServiceEnabled = {'b', nil, true, True}
}, {
    GetItems = {'a{ss}qq', 'ua(a(ss))', msg.GetItemsReq, msg.GetItemsRsp},
    ExportLog = {'a{ss}s', 'u', msg.ExportLogReq, msg.ExportLogRsp}
}, {})
return LogService
