-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class Ipv4.SetIpMaskGatewayRsp
---@field IpAddr string
local TSetIpMaskGatewayRsp = {}
TSetIpMaskGatewayRsp.__index = TSetIpMaskGatewayRsp
TSetIpMaskGatewayRsp.group = {}

local function TSetIpMaskGatewayRsp_from_obj(obj)
    return setmetatable(obj, TSetIpMaskGatewayRsp)
end

function TSetIpMaskGatewayRsp.new(IpAddr)
    return TSetIpMaskGatewayRsp_from_obj({IpAddr = IpAddr})
end
---@param obj Ipv4.SetIpMaskGatewayRsp
function TSetIpMaskGatewayRsp:init_from_obj(obj)
    self.IpAddr = obj.IpAddr
end

function TSetIpMaskGatewayRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetIpMaskGatewayRsp.group)
end

TSetIpMaskGatewayRsp.from_obj = TSetIpMaskGatewayRsp_from_obj

TSetIpMaskGatewayRsp.proto_property = {'IpAddr'}

TSetIpMaskGatewayRsp.default = {''}

TSetIpMaskGatewayRsp.struct = {{name = 'IpAddr', is_array = false, struct = nil}}

function TSetIpMaskGatewayRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'IpAddr', self.IpAddr, 'string', false, errs)

    TSetIpMaskGatewayRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetIpMaskGatewayRsp.proto_property, errs)
    return self
end

function TSetIpMaskGatewayRsp:unpack(_)
    return self.IpAddr
end

msg.SetIpMaskGatewayRsp = TSetIpMaskGatewayRsp

---@class Ipv4.SetIpMaskGatewayReq
---@field IpAddr string
---@field SubnetMask string
---@field DefaultGateway string
local TSetIpMaskGatewayReq = {}
TSetIpMaskGatewayReq.__index = TSetIpMaskGatewayReq
TSetIpMaskGatewayReq.group = {}

local function TSetIpMaskGatewayReq_from_obj(obj)
    return setmetatable(obj, TSetIpMaskGatewayReq)
end

function TSetIpMaskGatewayReq.new(IpAddr, SubnetMask, DefaultGateway)
    return TSetIpMaskGatewayReq_from_obj({
        IpAddr = IpAddr,
        SubnetMask = SubnetMask,
        DefaultGateway = DefaultGateway
    })
end
---@param obj Ipv4.SetIpMaskGatewayReq
function TSetIpMaskGatewayReq:init_from_obj(obj)
    self.IpAddr = obj.IpAddr
    self.SubnetMask = obj.SubnetMask
    self.DefaultGateway = obj.DefaultGateway
end

function TSetIpMaskGatewayReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetIpMaskGatewayReq.group)
end

TSetIpMaskGatewayReq.from_obj = TSetIpMaskGatewayReq_from_obj

TSetIpMaskGatewayReq.proto_property = {'IpAddr', 'SubnetMask', 'DefaultGateway'}

TSetIpMaskGatewayReq.default = {'', '', ''}

TSetIpMaskGatewayReq.struct = {
    {name = 'IpAddr', is_array = false, struct = nil},
    {name = 'SubnetMask', is_array = false, struct = nil},
    {name = 'DefaultGateway', is_array = false, struct = nil}
}

function TSetIpMaskGatewayReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'IpAddr', self.IpAddr, 'string', false, errs)
    validate.Required(prefix .. 'SubnetMask', self.SubnetMask, 'string', false, errs)
    validate.Required(prefix .. 'DefaultGateway', self.DefaultGateway, 'string', false, errs)

    TSetIpMaskGatewayReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetIpMaskGatewayReq.proto_property, errs)
    return self
end

function TSetIpMaskGatewayReq:unpack(_)
    return self.IpAddr, self.SubnetMask, self.DefaultGateway
end

msg.SetIpMaskGatewayReq = TSetIpMaskGatewayReq

local Ipv4 = {}

local Mdb = require 'mc.mdb'

---@class Ipv4: Table
---@field IpMode string
---@field IpAddr string
---@field BackupIpAddr string
---@field SubnetMask string
---@field BackupSubnetMask string
---@field DefaultGateway string
Ipv4.Ipv4 = Mdb.register_interface('bmc.kepler.Managers.EthernetInterfaces.Ipv4', {
    IpMode = {'s', nil, false, nil},
    IpAddr = {'s', nil, true, nil},
    BackupIpAddr = {'s', nil, false, nil},
    SubnetMask = {'s', nil, true, nil},
    BackupSubnetMask = {'s', nil, false, nil},
    DefaultGateway = {'s', nil, true, nil}
}, {SetIpMaskGateway = {'a{ss}sss', 's', msg.SetIpMaskGatewayReq, msg.SetIpMaskGatewayRsp}}, {})
return Ipv4
