-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local EthernetInterface = {}

local Mdb = require 'mc.mdb'

---@class IDNS: Table
---@field PrimaryNameServer string
---@field BackupNameServer string
---@field TertiaryNameServer string
---@field DHCPv4UseDNSServers boolean
---@field DHCPv6UseDNSServers boolean
EthernetInterface.IDNS = Mdb.register_interface('bmc.kepler.Managers.EthernetInterface.DNS', {
    PrimaryNameServer = {'s', nil, false, nil},
    BackupNameServer = {'s', nil, false, nil},
    TertiaryNameServer = {'s', nil, false, nil},
    DHCPv4UseDNSServers = {'b', nil, false, nil},
    DHCPv6UseDNSServers = {'b', nil, false, nil}
}, {}, {})

return EthernetInterface
