-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class defs.SturctArg
---@field SubArg1 string
---@field SubArg2 string
local TSturctArg = {}
TSturctArg.__index = TSturctArg
TSturctArg.group = {}

local function TSturctArg_from_obj(obj)
    return setmetatable(obj, TSturctArg)
end

function TSturctArg.new(SubArg1, SubArg2)
    return TSturctArg_from_obj({SubArg1 = SubArg1, SubArg2 = SubArg2})
end
---@param obj defs.SturctArg
function TSturctArg:init_from_obj(obj)
    self.SubArg1 = obj.SubArg1
    self.SubArg2 = obj.SubArg2
end

function TSturctArg:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSturctArg.group)
end

TSturctArg.from_obj = TSturctArg_from_obj

TSturctArg.proto_property = {'SubArg1', 'SubArg2'}

TSturctArg.default = {'', ''}

TSturctArg.struct = {
    {name = 'SubArg1', is_array = false, struct = nil},
    {name = 'SubArg2', is_array = false, struct = nil}
}

function TSturctArg:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SubArg1', self.SubArg1, 'string', false, errs)
    validate.Required(prefix .. 'SubArg2', self.SubArg2, 'string', false, errs)

    TSturctArg:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSturctArg.proto_property, errs)
    return self
end

function TSturctArg:unpack(_)
    return self.SubArg1, self.SubArg2
end

defs.SturctArg = TSturctArg

---@class InterfaceBar.MethodBarRsp
---@field Result integer
local TMethodBarRsp = {}
TMethodBarRsp.__index = TMethodBarRsp
TMethodBarRsp.group = {}

local function TMethodBarRsp_from_obj(obj)
    return setmetatable(obj, TMethodBarRsp)
end

function TMethodBarRsp.new(Result)
    return TMethodBarRsp_from_obj({Result = Result})
end
---@param obj InterfaceBar.MethodBarRsp
function TMethodBarRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TMethodBarRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMethodBarRsp.group)
end

TMethodBarRsp.from_obj = TMethodBarRsp_from_obj

TMethodBarRsp.proto_property = {'Result'}

TMethodBarRsp.default = {0}

TMethodBarRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TMethodBarRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Result', self.Result, 'uint32', false, errs)

    TMethodBarRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMethodBarRsp.proto_property, errs)
    return self
end

function TMethodBarRsp:unpack(_)
    return self.Result
end

msg.MethodBarRsp = TMethodBarRsp

---@class InterfaceBar.MethodBarReq
---@field StructArg defs.SturctArg
---@field ArrayArg integer[]
---@field ArrayStruct defs.SturctArg[]
local TMethodBarReq = {}
TMethodBarReq.__index = TMethodBarReq
TMethodBarReq.group = {}

local function TMethodBarReq_from_obj(obj)
    obj.StructArg = utils.from_obj(defs.SturctArg, obj.StructArg)
    obj.ArrayStruct = utils.from_obj(defs.SturctArg, obj.ArrayStruct, true)
    return setmetatable(obj, TMethodBarReq)
end

function TMethodBarReq.new(StructArg, ArrayArg, ArrayStruct)
    return TMethodBarReq_from_obj({
        StructArg = StructArg,
        ArrayArg = ArrayArg,
        ArrayStruct = ArrayStruct
    })
end
---@param obj InterfaceBar.MethodBarReq
function TMethodBarReq:init_from_obj(obj)
    self.StructArg = obj.StructArg
    self.ArrayArg = obj.ArrayArg
    self.ArrayStruct = obj.ArrayStruct
end

function TMethodBarReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMethodBarReq.group)
end

TMethodBarReq.from_obj = TMethodBarReq_from_obj

TMethodBarReq.proto_property = {'StructArg', 'ArrayArg', 'ArrayStruct'}

TMethodBarReq.default = {defs.SturctArg.default, {}, {}}

TMethodBarReq.struct = {
    {name = 'StructArg', is_array = false, struct = defs.SturctArg.struct},
    {name = 'ArrayArg', is_array = true, struct = nil},
    {name = 'ArrayStruct', is_array = true, struct = defs.SturctArg.struct}
}

function TMethodBarReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'StructArg', self.StructArg, 'defs.SturctArg', false, errs)
    validate.RequiredArray(prefix .. 'ArrayArg', self.ArrayArg, 'uint32', false, errs)
    validate.RequiredArray(prefix .. 'ArrayStruct', self.ArrayStruct, 'defs.SturctArg', false, errs)

    TMethodBarReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMethodBarReq.proto_property, errs)
    return self
end

function TMethodBarReq:unpack(raw)
    return utils.unpack(raw, self.StructArg), self.ArrayArg,
        utils.unpack(raw, self.ArrayStruct, true)
end

msg.MethodBarReq = TMethodBarReq

local InterfaceBar = {}

local Mdb = require 'mc.mdb'

---@class InterfaceBar: Table
---@field Id integer
---@field Name string
---@field Presence boolean
---@field Frudata integer[]
---@field priority integer
InterfaceBar.InterfaceBar = Mdb.register_interface('bmc.kepler.Example.InterfaceBar', {
    Id = {'u', nil, true, 1},
    Name = {'s', nil, true, nil},
    Presence = {'b', nil, false, True},
    Frudata = {'ay', nil, false, nil},
    priority = {'y', nil, true, nil}
}, {MethodBar = {'a{ss}(ss)aua(ss)', 'u', msg.MethodBarReq, msg.MethodBarRsp}}, {Notify = 'uu'})
return InterfaceBar
