-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class Snmp.SetCommunityRsp
local TSetCommunityRsp = {}
TSetCommunityRsp.__index = TSetCommunityRsp
TSetCommunityRsp.group = {}

local function TSetCommunityRsp_from_obj(obj)
    return setmetatable(obj, TSetCommunityRsp)
end

function TSetCommunityRsp.new()
    return TSetCommunityRsp_from_obj({})
end
---@param obj Snmp.SetCommunityRsp
function TSetCommunityRsp:init_from_obj(obj)

end

function TSetCommunityRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCommunityRsp.group)
end

TSetCommunityRsp.from_obj = TSetCommunityRsp_from_obj

TSetCommunityRsp.proto_property = {}

TSetCommunityRsp.default = {}

TSetCommunityRsp.struct = {}

function TSetCommunityRsp:validate(prefix, errs)
    prefix = prefix or ''

    TSetCommunityRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCommunityRsp.proto_property, errs)
    return self
end

function TSetCommunityRsp:unpack(_)
end

msg.SetCommunityRsp = TSetCommunityRsp

---@class Snmp.SetCommunityReq
---@field Community string
local TSetCommunityReq = {}
TSetCommunityReq.__index = TSetCommunityReq
TSetCommunityReq.group = {}

local function TSetCommunityReq_from_obj(obj)
    return setmetatable(obj, TSetCommunityReq)
end

function TSetCommunityReq.new(Community)
    return TSetCommunityReq_from_obj({Community = Community})
end
---@param obj Snmp.SetCommunityReq
function TSetCommunityReq:init_from_obj(obj)
    self.Community = obj.Community
end

function TSetCommunityReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetCommunityReq.group)
end

TSetCommunityReq.from_obj = TSetCommunityReq_from_obj

TSetCommunityReq.proto_property = {'Community'}

TSetCommunityReq.default = {''}

TSetCommunityReq.struct = {{name = 'Community', is_array = false, struct = nil}}

function TSetCommunityReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Community', self.Community, 'string', false, errs)

    TSetCommunityReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetCommunityReq.proto_property, errs)
    return self
end

function TSetCommunityReq:unpack(_)
    return self.Community
end

msg.SetCommunityReq = TSetCommunityReq

local Snmp = {}

local Mdb = require 'mc.mdb'

---@class Snmp: Table
---@field Enabled boolean
---@field Version string
---@field LowestSeverity string
---@field SNMPv3User string
---@field ServerIdentity string
Snmp.Snmp = Mdb.register_interface('bmc.kepler.EventService.Subscriptions.Snmp', {
    Enabled = {'b', nil, false, True},
    Version = {'s', nil, false, 'SNMPv1'},
    LowestSeverity = {'s', nil, false, 'Normal'},
    SNMPv3User = {'s', nil, false, 'Administrator'},
    ServerIdentity = {'s', nil, false, 'BoardSN'}
}, {SetCommunity = {'a{ss}s', '', msg.SetCommunityReq, msg.SetCommunityRsp}}, {})
return Snmp
