-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'

local msg = {}
local defs = {}

---@class Sender.SetPasswordRsp
local TSetPasswordRsp = {}
TSetPasswordRsp.__index = TSetPasswordRsp
TSetPasswordRsp.group = {}

local function TSetPasswordRsp_from_obj(obj)
    return setmetatable(obj, TSetPasswordRsp)
end

function TSetPasswordRsp.new()
    return TSetPasswordRsp_from_obj({})
end
---@param obj Sender.SetPasswordRsp
function TSetPasswordRsp:init_from_obj(obj)

end

function TSetPasswordRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPasswordRsp.group)
end

TSetPasswordRsp.from_obj = TSetPasswordRsp_from_obj

TSetPasswordRsp.proto_property = {}

TSetPasswordRsp.default = {}

TSetPasswordRsp.struct = {}

function TSetPasswordRsp:validate(prefix, errs)
    prefix = prefix or ''

    TSetPasswordRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPasswordRsp.proto_property, errs)
    return self
end

function TSetPasswordRsp:unpack(_)
end

msg.SetPasswordRsp = TSetPasswordRsp

---@class Sender.SetPasswordReq
---@field Password string
local TSetPasswordReq = {}
TSetPasswordReq.__index = TSetPasswordReq
TSetPasswordReq.group = {}

local function TSetPasswordReq_from_obj(obj)
    return setmetatable(obj, TSetPasswordReq)
end

function TSetPasswordReq.new(Password)
    return TSetPasswordReq_from_obj({Password = Password})
end
---@param obj Sender.SetPasswordReq
function TSetPasswordReq:init_from_obj(obj)
    self.Password = obj.Password
end

function TSetPasswordReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPasswordReq.group)
end

TSetPasswordReq.from_obj = TSetPasswordReq_from_obj

TSetPasswordReq.proto_property = {'Password'}

TSetPasswordReq.default = {''}

TSetPasswordReq.struct = {{name = 'Password', is_array = false, struct = nil}}

function TSetPasswordReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Password', self.Password, 'string', false, errs)

    TSetPasswordReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPasswordReq.proto_property, errs)
    return self
end

function TSetPasswordReq:unpack(_)
    return self.Password
end

msg.SetPasswordReq = TSetPasswordReq

local Sender = {}

local Mdb = require 'mc.mdb'

---@class Sender: Table
---@field Username string
---@field FromAddress string
Sender.Sender = Mdb.register_interface('bmc.kepler.EventService.Subscriptions.Smtp.Sender', {
    Username = {'s', nil, false, nil},
    FromAddress = {'s', nil, false, nil}
}, {SetPassword = {'a{ss}s', '', msg.SetPasswordReq, msg.SetPasswordRsp}}, {})
return Sender
