-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'
local create_enum_type = require 'mc.enum'

local msg = {}
local defs = {}

---@class defs.LoginInterfaceType: Enum
local ELoginInterfaceType = create_enum_type('LoginInterfaceType')
ELoginInterfaceType.default = ELoginInterfaceType.new(2147483647)
ELoginInterfaceType.struct = nil
ELoginInterfaceType.Invalid = ELoginInterfaceType.new(0)
ELoginInterfaceType.Web = ELoginInterfaceType.new(1)
ELoginInterfaceType.SNMP = ELoginInterfaceType.new(2)
ELoginInterfaceType.IPMI = ELoginInterfaceType.new(4)
ELoginInterfaceType.SSH = ELoginInterfaceType.new(8)
ELoginInterfaceType.SFTP = ELoginInterfaceType.new(16)
ELoginInterfaceType.Local = ELoginInterfaceType.new(64)
ELoginInterfaceType.Redfish = ELoginInterfaceType.new(128)

defs.LoginInterfaceType = ELoginInterfaceType

---@class ManagerAccounts.GetIdByUserNameRsp
---@field AccountId integer
local TGetIdByUserNameRsp = {}
TGetIdByUserNameRsp.__index = TGetIdByUserNameRsp
TGetIdByUserNameRsp.group = {}

local function TGetIdByUserNameRsp_from_obj(obj)
    return setmetatable(obj, TGetIdByUserNameRsp)
end

function TGetIdByUserNameRsp.new(AccountId)
    return TGetIdByUserNameRsp_from_obj({AccountId = AccountId})
end
---@param obj ManagerAccounts.GetIdByUserNameRsp
function TGetIdByUserNameRsp:init_from_obj(obj)
    self.AccountId = obj.AccountId
end

function TGetIdByUserNameRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetIdByUserNameRsp.group)
end

TGetIdByUserNameRsp.from_obj = TGetIdByUserNameRsp_from_obj

TGetIdByUserNameRsp.proto_property = {'AccountId'}

TGetIdByUserNameRsp.default = {0}

TGetIdByUserNameRsp.struct = {{name = 'AccountId', is_array = false, struct = nil}}

function TGetIdByUserNameRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'AccountId', self.AccountId, 'int8', false, errs)

    TGetIdByUserNameRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetIdByUserNameRsp.proto_property, errs)
    return self
end

function TGetIdByUserNameRsp:unpack(_)
    return self.AccountId
end

msg.GetIdByUserNameRsp = TGetIdByUserNameRsp

---@class ManagerAccounts.GetIdByUserNameReq
---@field UserName string
local TGetIdByUserNameReq = {}
TGetIdByUserNameReq.__index = TGetIdByUserNameReq
TGetIdByUserNameReq.group = {}

local function TGetIdByUserNameReq_from_obj(obj)
    return setmetatable(obj, TGetIdByUserNameReq)
end

function TGetIdByUserNameReq.new(UserName)
    return TGetIdByUserNameReq_from_obj({UserName = UserName})
end
---@param obj ManagerAccounts.GetIdByUserNameReq
function TGetIdByUserNameReq:init_from_obj(obj)
    self.UserName = obj.UserName
end

function TGetIdByUserNameReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetIdByUserNameReq.group)
end

TGetIdByUserNameReq.from_obj = TGetIdByUserNameReq_from_obj

TGetIdByUserNameReq.proto_property = {'UserName'}

TGetIdByUserNameReq.default = {''}

TGetIdByUserNameReq.struct = {{name = 'UserName', is_array = false, struct = nil}}

function TGetIdByUserNameReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'UserName', self.UserName, 'string', false, errs)

    validate.lens(prefix .. 'UserName', self.UserName, 1, 32, errs)

    TGetIdByUserNameReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetIdByUserNameReq.proto_property, errs)
    return self
end

function TGetIdByUserNameReq:unpack(_)
    return self.UserName
end

msg.GetIdByUserNameReq = TGetIdByUserNameReq

---@class ManagerAccounts.NewRsp
local TNewRsp = {}
TNewRsp.__index = TNewRsp
TNewRsp.group = {}

local function TNewRsp_from_obj(obj)
    return setmetatable(obj, TNewRsp)
end

function TNewRsp.new()
    return TNewRsp_from_obj({})
end
---@param obj ManagerAccounts.NewRsp
function TNewRsp:init_from_obj(obj)

end

function TNewRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNewRsp.group)
end

TNewRsp.from_obj = TNewRsp_from_obj

TNewRsp.proto_property = {}

TNewRsp.default = {}

TNewRsp.struct = {}

function TNewRsp:validate(prefix, errs)
    prefix = prefix or ''

    TNewRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNewRsp.proto_property, errs)
    return self
end

function TNewRsp:unpack(_)
end

msg.NewRsp = TNewRsp

---@class ManagerAccounts.NewReq
---@field AccountId integer
---@field UserName string
---@field Password integer[]
---@field RoleId integer
---@field LoginInterface defs.LoginInterfaceType[]
local TNewReq = {}
TNewReq.__index = TNewReq
TNewReq.group = {}

local function TNewReq_from_obj(obj)
    obj.LoginInterface = utils.from_obj(defs.LoginInterfaceType, obj.LoginInterface, true)
    return setmetatable(obj, TNewReq)
end

function TNewReq.new(AccountId, UserName, Password, RoleId, LoginInterface)
    return TNewReq_from_obj({
        AccountId = AccountId,
        UserName = UserName,
        Password = Password,
        RoleId = RoleId,
        LoginInterface = LoginInterface
    })
end
---@param obj ManagerAccounts.NewReq
function TNewReq:init_from_obj(obj)
    self.AccountId = obj.AccountId
    self.UserName = obj.UserName
    self.Password = obj.Password
    self.RoleId = obj.RoleId
    self.LoginInterface = obj.LoginInterface
end

function TNewReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TNewReq.group)
end

TNewReq.from_obj = TNewReq_from_obj

TNewReq.proto_property = {'AccountId', 'UserName', 'Password', 'RoleId', 'LoginInterface'}

TNewReq.default = {0, '', {}, 0, {}}

TNewReq.struct = {
    {name = 'AccountId', is_array = false, struct = nil},
    {name = 'UserName', is_array = false, struct = nil},
    {name = 'Password', is_array = true, struct = nil},
    {name = 'RoleId', is_array = false, struct = nil},
    {name = 'LoginInterface', is_array = true, struct = defs.LoginInterfaceType.struct}
}

function TNewReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'AccountId', self.AccountId, 'uint8', false, errs)
    validate.Required(prefix .. 'UserName', self.UserName, 'string', false, errs)
    validate.RequiredArray(prefix .. 'Password', self.Password, 'uint8', false, errs)
    validate.Required(prefix .. 'RoleId', self.RoleId, 'uint8', false, errs)
    validate.RequiredArray(prefix .. 'LoginInterface', self.LoginInterface,
        'defs.LoginInterfaceType', false, errs)

    validate.ranges(prefix .. 'AccountId', self.AccountId, 2, 17, errs)
    validate.lens(prefix .. 'UserName', self.UserName, 1, 32, errs)
    validate.lens(prefix .. 'Password', self.Password, 1, 32, errs)

    TNewReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TNewReq.proto_property, errs)
    return self
end

function TNewReq:unpack(raw)
    local LoginInterface = utils.unpack_enum(raw, utils.from_obj(defs.LoginInterfaceType,
        self.LoginInterface, true), true)
    return self.AccountId, self.UserName, self.Password, self.RoleId, LoginInterface
end

msg.NewReq = TNewReq

local ManagerAccounts = {}

local Mdb = require 'mc.mdb'

---@class ManagerAccounts: Table
ManagerAccounts.ManagerAccounts = Mdb.register_interface(
    'bmc.kepler.AccountService.ManagerAccounts', {}, {
        New = {'a{ss}ysayyai', '', msg.NewReq, msg.NewRsp},
        GetIdByUserName = {'a{ss}s', 'y', msg.GetIdByUserNameReq, msg.GetIdByUserNameRsp}
    }, {})
return ManagerAccounts
