-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'
local create_enum_type = require 'mc.enum'

local msg = {}
local defs = {}

---@class defs.EnumLoginRuleIds: Enum
local EEnumLoginRuleIds = create_enum_type('EnumLoginRuleIds')
EEnumLoginRuleIds.default = EEnumLoginRuleIds.new(2147483647)
EEnumLoginRuleIds.struct = nil
EEnumLoginRuleIds.Rule_Invalid = EEnumLoginRuleIds.new(0)
EEnumLoginRuleIds.Rule1 = EEnumLoginRuleIds.new(1)
EEnumLoginRuleIds.Rule2 = EEnumLoginRuleIds.new(2)
EEnumLoginRuleIds.Rule3 = EEnumLoginRuleIds.new(4)

defs.EnumLoginRuleIds = EEnumLoginRuleIds

---@class defs.EnumLoginInterface: Enum
local EEnumLoginInterface = create_enum_type('EnumLoginInterface')
EEnumLoginInterface.default = EEnumLoginInterface.new(2147483647)
EEnumLoginInterface.struct = nil
EEnumLoginInterface.Invalid = EEnumLoginInterface.new(0)
EEnumLoginInterface.Web = EEnumLoginInterface.new(1)
EEnumLoginInterface.SNMP = EEnumLoginInterface.new(2)
EEnumLoginInterface.IPMI = EEnumLoginInterface.new(4)
EEnumLoginInterface.SSH = EEnumLoginInterface.new(8)
EEnumLoginInterface.SFTP = EEnumLoginInterface.new(16)
EEnumLoginInterface.Local = EEnumLoginInterface.new(64)
EEnumLoginInterface.Redfish = EEnumLoginInterface.new(128)

defs.EnumLoginInterface = EEnumLoginInterface

---@class defs.EnumAccountType: Enum
local EEnumAccountType = create_enum_type('EnumAccountType')
EEnumAccountType.default = EEnumAccountType.new(2147483647)
EEnumAccountType.struct = nil
EEnumAccountType.Local = EEnumAccountType.new(0)
EEnumAccountType.LDAP = EEnumAccountType.new(1)
EEnumAccountType.Kerberos = EEnumAccountType.new(2)
EEnumAccountType.VNC = EEnumAccountType.new(3)
EEnumAccountType.KVM = EEnumAccountType.new(4)
EEnumAccountType.KerberosSSO = EEnumAccountType.new(5)
EEnumAccountType.IPMI_INNER = EEnumAccountType.new(6)

defs.EnumAccountType = EEnumAccountType

---@class defs.RoleType: Enum
local ERoleType = create_enum_type('RoleType')
ERoleType.default = ERoleType.new(2147483647)
ERoleType.struct = nil
ERoleType.NoAccess = ERoleType.new(0)
ERoleType.CommonUser = ERoleType.new(2)
ERoleType.Operator = ERoleType.new(3)
ERoleType.Administrator = ERoleType.new(4)
ERoleType.CustomRole1 = ERoleType.new(5)
ERoleType.CustomRole2 = ERoleType.new(6)
ERoleType.CustomRole3 = ERoleType.new(7)
ERoleType.CustomRole4 = ERoleType.new(8)

defs.RoleType = ERoleType

---@class defs.EnumLoginPolicy: Enum
local EEnumLoginPolicy = create_enum_type('EnumLoginPolicy')
EEnumLoginPolicy.default = EEnumLoginPolicy.new(2147483647)
EEnumLoginPolicy.struct = nil
EEnumLoginPolicy.LP_Null = EEnumLoginPolicy.new(0)
EEnumLoginPolicy.LP_PromptPasswordReset = EEnumLoginPolicy.new(1)
EEnumLoginPolicy.LP_ForcePasswordReset = EEnumLoginPolicy.new(2)

defs.EnumLoginPolicy = EEnumLoginPolicy

---@class ManagerAccount.DeleteSSHPublicKeyRsp
local TDeleteSSHPublicKeyRsp = {}
TDeleteSSHPublicKeyRsp.__index = TDeleteSSHPublicKeyRsp
TDeleteSSHPublicKeyRsp.group = {}

local function TDeleteSSHPublicKeyRsp_from_obj(obj)
    return setmetatable(obj, TDeleteSSHPublicKeyRsp)
end

function TDeleteSSHPublicKeyRsp.new()
    return TDeleteSSHPublicKeyRsp_from_obj({})
end
---@param obj ManagerAccount.DeleteSSHPublicKeyRsp
function TDeleteSSHPublicKeyRsp:init_from_obj(obj)

end

function TDeleteSSHPublicKeyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteSSHPublicKeyRsp.group)
end

TDeleteSSHPublicKeyRsp.from_obj = TDeleteSSHPublicKeyRsp_from_obj

TDeleteSSHPublicKeyRsp.proto_property = {}

TDeleteSSHPublicKeyRsp.default = {}

TDeleteSSHPublicKeyRsp.struct = {}

function TDeleteSSHPublicKeyRsp:validate(prefix, errs)
    prefix = prefix or ''

    TDeleteSSHPublicKeyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteSSHPublicKeyRsp.proto_property, errs)
    return self
end

function TDeleteSSHPublicKeyRsp:unpack(_)
end

msg.DeleteSSHPublicKeyRsp = TDeleteSSHPublicKeyRsp

---@class ManagerAccount.DeleteSSHPublicKeyReq
local TDeleteSSHPublicKeyReq = {}
TDeleteSSHPublicKeyReq.__index = TDeleteSSHPublicKeyReq
TDeleteSSHPublicKeyReq.group = {}

local function TDeleteSSHPublicKeyReq_from_obj(obj)
    return setmetatable(obj, TDeleteSSHPublicKeyReq)
end

function TDeleteSSHPublicKeyReq.new()
    return TDeleteSSHPublicKeyReq_from_obj({})
end
---@param obj ManagerAccount.DeleteSSHPublicKeyReq
function TDeleteSSHPublicKeyReq:init_from_obj(obj)

end

function TDeleteSSHPublicKeyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteSSHPublicKeyReq.group)
end

TDeleteSSHPublicKeyReq.from_obj = TDeleteSSHPublicKeyReq_from_obj

TDeleteSSHPublicKeyReq.proto_property = {}

TDeleteSSHPublicKeyReq.default = {}

TDeleteSSHPublicKeyReq.struct = {}

function TDeleteSSHPublicKeyReq:validate(prefix, errs)
    prefix = prefix or ''

    TDeleteSSHPublicKeyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteSSHPublicKeyReq.proto_property, errs)
    return self
end

function TDeleteSSHPublicKeyReq:unpack(_)
end

msg.DeleteSSHPublicKeyReq = TDeleteSSHPublicKeyReq

---@class ManagerAccount.ImportSSHPublicKeyRsp
local TImportSSHPublicKeyRsp = {}
TImportSSHPublicKeyRsp.__index = TImportSSHPublicKeyRsp
TImportSSHPublicKeyRsp.group = {}

local function TImportSSHPublicKeyRsp_from_obj(obj)
    return setmetatable(obj, TImportSSHPublicKeyRsp)
end

function TImportSSHPublicKeyRsp.new()
    return TImportSSHPublicKeyRsp_from_obj({})
end
---@param obj ManagerAccount.ImportSSHPublicKeyRsp
function TImportSSHPublicKeyRsp:init_from_obj(obj)

end

function TImportSSHPublicKeyRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportSSHPublicKeyRsp.group)
end

TImportSSHPublicKeyRsp.from_obj = TImportSSHPublicKeyRsp_from_obj

TImportSSHPublicKeyRsp.proto_property = {}

TImportSSHPublicKeyRsp.default = {}

TImportSSHPublicKeyRsp.struct = {}

function TImportSSHPublicKeyRsp:validate(prefix, errs)
    prefix = prefix or ''

    TImportSSHPublicKeyRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportSSHPublicKeyRsp.proto_property, errs)
    return self
end

function TImportSSHPublicKeyRsp:unpack(_)
end

msg.ImportSSHPublicKeyRsp = TImportSSHPublicKeyRsp

---@class ManagerAccount.ImportSSHPublicKeyReq
---@field Path string
local TImportSSHPublicKeyReq = {}
TImportSSHPublicKeyReq.__index = TImportSSHPublicKeyReq
TImportSSHPublicKeyReq.group = {}

local function TImportSSHPublicKeyReq_from_obj(obj)
    return setmetatable(obj, TImportSSHPublicKeyReq)
end

function TImportSSHPublicKeyReq.new(Path)
    return TImportSSHPublicKeyReq_from_obj({Path = Path})
end
---@param obj ManagerAccount.ImportSSHPublicKeyReq
function TImportSSHPublicKeyReq:init_from_obj(obj)
    self.Path = obj.Path
end

function TImportSSHPublicKeyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportSSHPublicKeyReq.group)
end

TImportSSHPublicKeyReq.from_obj = TImportSSHPublicKeyReq_from_obj

TImportSSHPublicKeyReq.proto_property = {'Path'}

TImportSSHPublicKeyReq.default = {''}

TImportSSHPublicKeyReq.struct = {{name = 'Path', is_array = false, struct = nil}}

function TImportSSHPublicKeyReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'Path', self.Path, 'string', false, errs)

    validate.lens(prefix .. 'Path', self.Path, 1, 256, errs)

    TImportSSHPublicKeyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportSSHPublicKeyReq.proto_property, errs)
    return self
end

function TImportSSHPublicKeyReq:unpack(_)
    return self.Path
end

msg.ImportSSHPublicKeyReq = TImportSSHPublicKeyReq

---@class ManagerAccount.ChangeSnmpPwdRsp
local TChangeSnmpPwdRsp = {}
TChangeSnmpPwdRsp.__index = TChangeSnmpPwdRsp
TChangeSnmpPwdRsp.group = {}

local function TChangeSnmpPwdRsp_from_obj(obj)
    return setmetatable(obj, TChangeSnmpPwdRsp)
end

function TChangeSnmpPwdRsp.new()
    return TChangeSnmpPwdRsp_from_obj({})
end
---@param obj ManagerAccount.ChangeSnmpPwdRsp
function TChangeSnmpPwdRsp:init_from_obj(obj)

end

function TChangeSnmpPwdRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChangeSnmpPwdRsp.group)
end

TChangeSnmpPwdRsp.from_obj = TChangeSnmpPwdRsp_from_obj

TChangeSnmpPwdRsp.proto_property = {}

TChangeSnmpPwdRsp.default = {}

TChangeSnmpPwdRsp.struct = {}

function TChangeSnmpPwdRsp:validate(prefix, errs)
    prefix = prefix or ''

    TChangeSnmpPwdRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChangeSnmpPwdRsp.proto_property, errs)
    return self
end

function TChangeSnmpPwdRsp:unpack(_)
end

msg.ChangeSnmpPwdRsp = TChangeSnmpPwdRsp

---@class ManagerAccount.ChangeSnmpPwdReq
---@field Password integer[]
local TChangeSnmpPwdReq = {}
TChangeSnmpPwdReq.__index = TChangeSnmpPwdReq
TChangeSnmpPwdReq.group = {}

local function TChangeSnmpPwdReq_from_obj(obj)
    return setmetatable(obj, TChangeSnmpPwdReq)
end

function TChangeSnmpPwdReq.new(Password)
    return TChangeSnmpPwdReq_from_obj({Password = Password})
end
---@param obj ManagerAccount.ChangeSnmpPwdReq
function TChangeSnmpPwdReq:init_from_obj(obj)
    self.Password = obj.Password
end

function TChangeSnmpPwdReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChangeSnmpPwdReq.group)
end

TChangeSnmpPwdReq.from_obj = TChangeSnmpPwdReq_from_obj

TChangeSnmpPwdReq.proto_property = {'Password'}

TChangeSnmpPwdReq.default = {{}}

TChangeSnmpPwdReq.struct = {{name = 'Password', is_array = true, struct = nil}}

function TChangeSnmpPwdReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.RequiredArray(prefix .. 'Password', self.Password, 'uint8', false, errs)

    validate.lens(prefix .. 'Password', self.Password, 1, 32, errs)

    TChangeSnmpPwdReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChangeSnmpPwdReq.proto_property, errs)
    return self
end

function TChangeSnmpPwdReq:unpack(_)
    return self.Password
end

msg.ChangeSnmpPwdReq = TChangeSnmpPwdReq

---@class ManagerAccount.ChangePwdRsp
local TChangePwdRsp = {}
TChangePwdRsp.__index = TChangePwdRsp
TChangePwdRsp.group = {}

local function TChangePwdRsp_from_obj(obj)
    return setmetatable(obj, TChangePwdRsp)
end

function TChangePwdRsp.new()
    return TChangePwdRsp_from_obj({})
end
---@param obj ManagerAccount.ChangePwdRsp
function TChangePwdRsp:init_from_obj(obj)

end

function TChangePwdRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChangePwdRsp.group)
end

TChangePwdRsp.from_obj = TChangePwdRsp_from_obj

TChangePwdRsp.proto_property = {}

TChangePwdRsp.default = {}

TChangePwdRsp.struct = {}

function TChangePwdRsp:validate(prefix, errs)
    prefix = prefix or ''

    TChangePwdRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChangePwdRsp.proto_property, errs)
    return self
end

function TChangePwdRsp:unpack(_)
end

msg.ChangePwdRsp = TChangePwdRsp

---@class ManagerAccount.ChangePwdReq
---@field Password integer[]
local TChangePwdReq = {}
TChangePwdReq.__index = TChangePwdReq
TChangePwdReq.group = {}

local function TChangePwdReq_from_obj(obj)
    return setmetatable(obj, TChangePwdReq)
end

function TChangePwdReq.new(Password)
    return TChangePwdReq_from_obj({Password = Password})
end
---@param obj ManagerAccount.ChangePwdReq
function TChangePwdReq:init_from_obj(obj)
    self.Password = obj.Password
end

function TChangePwdReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChangePwdReq.group)
end

TChangePwdReq.from_obj = TChangePwdReq_from_obj

TChangePwdReq.proto_property = {'Password'}

TChangePwdReq.default = {{}}

TChangePwdReq.struct = {{name = 'Password', is_array = true, struct = nil}}

function TChangePwdReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.RequiredArray(prefix .. 'Password', self.Password, 'uint8', false, errs)

    validate.lens(prefix .. 'Password', self.Password, 1, 32, errs)

    TChangePwdReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChangePwdReq.proto_property, errs)
    return self
end

function TChangePwdReq:unpack(_)
    return self.Password
end

msg.ChangePwdReq = TChangePwdReq

---@class ManagerAccount.DeleteRsp
local TDeleteRsp = {}
TDeleteRsp.__index = TDeleteRsp
TDeleteRsp.group = {}

local function TDeleteRsp_from_obj(obj)
    return setmetatable(obj, TDeleteRsp)
end

function TDeleteRsp.new()
    return TDeleteRsp_from_obj({})
end
---@param obj ManagerAccount.DeleteRsp
function TDeleteRsp:init_from_obj(obj)

end

function TDeleteRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteRsp.group)
end

TDeleteRsp.from_obj = TDeleteRsp_from_obj

TDeleteRsp.proto_property = {}

TDeleteRsp.default = {}

TDeleteRsp.struct = {}

function TDeleteRsp:validate(prefix, errs)
    prefix = prefix or ''

    TDeleteRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteRsp.proto_property, errs)
    return self
end

function TDeleteRsp:unpack(_)
end

msg.DeleteRsp = TDeleteRsp

---@class ManagerAccount.DeleteReq
local TDeleteReq = {}
TDeleteReq.__index = TDeleteReq
TDeleteReq.group = {}

local function TDeleteReq_from_obj(obj)
    return setmetatable(obj, TDeleteReq)
end

function TDeleteReq.new()
    return TDeleteReq_from_obj({})
end
---@param obj ManagerAccount.DeleteReq
function TDeleteReq:init_from_obj(obj)

end

function TDeleteReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDeleteReq.group)
end

TDeleteReq.from_obj = TDeleteReq_from_obj

TDeleteReq.proto_property = {}

TDeleteReq.default = {}

TDeleteReq.struct = {}

function TDeleteReq:validate(prefix, errs)
    prefix = prefix or ''

    TDeleteReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDeleteReq.proto_property, errs)
    return self
end

function TDeleteReq:unpack(_)
end

msg.DeleteReq = TDeleteReq

local ManagerAccount = {}

local Mdb = require 'mc.mdb'

---@class ManagerAccount: Table
---@field AccountExpiration string
---@field Certificates integer
---@field Enabled boolean
---@field Id integer
---@field Locked boolean
---@field UserName string
---@field PasswordChangeRequired boolean
---@field PasswordExpiration integer
---@field RoleId integer
---@field SshPublicKeyHash string
---@field AccountType string
---@field LoginRuleIds string[]
---@field LastLoginTime integer
---@field LastLoginIP string
---@field LastLoginInterface string
---@field FirstLoginPolicy integer
---@field LoginInterface string[]
ManagerAccount.ManagerAccount = Mdb.register_interface('bmc.kepler.AccountService.ManagerAccount',
    {
        AccountExpiration = {'s', nil, true, nil},
        Certificates = {'q', nil, true, nil},
        Enabled = {'b', nil, false, nil},
        Id = {'y', nil, true, nil},
        Locked = {'b', nil, true, nil},
        UserName = {'s', nil, false, nil},
        PasswordChangeRequired = {'b', nil, false, True},
        PasswordExpiration = {'u', nil, true, nil},
        RoleId = {'y', nil, false, nil},
        SshPublicKeyHash = {'s', nil, true, nil},
        AccountType = {'s', nil, true, nil},
        LoginRuleIds = {'as', nil, false, nil},
        LastLoginTime = {'u', nil, true, nil},
        LastLoginIP = {'s', nil, true, nil},
        LastLoginInterface = {'s', nil, true, nil},
        FirstLoginPolicy = {'y', nil, false, 2},
        LoginInterface = {'as', nil, false, nil}
    }, {
        Delete = {'a{ss}', '', msg.DeleteReq, msg.DeleteRsp},
        ChangePwd = {'a{ss}ay', '', msg.ChangePwdReq, msg.ChangePwdRsp},
        ChangeSnmpPwd = {'a{ss}ay', '', msg.ChangeSnmpPwdReq, msg.ChangeSnmpPwdRsp},
        ImportSSHPublicKey = {'a{ss}s', '', msg.ImportSSHPublicKeyReq, msg.ImportSSHPublicKeyRsp},
        DeleteSSHPublicKey = {'a{ss}', '', msg.DeleteSSHPublicKeyReq, msg.DeleteSSHPublicKeyRsp}
    }, {})
return ManagerAccount
