-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local validate = require 'mc.validate'
local utils = require 'mc.utils'
local create_enum_type = require 'mc.enum'

local msg = {}
local defs = {}

---@class defs.SessionLogoutType: Enum
local ESessionLogoutType = create_enum_type('SessionLogoutType')
ESessionLogoutType.default = ESessionLogoutType.new(2147483647)
ESessionLogoutType.struct = nil
ESessionLogoutType.SessionLogout = ESessionLogoutType.new(0)
ESessionLogoutType.SessionTimeout = ESessionLogoutType.new(1)
ESessionLogoutType.SessionKickout = ESessionLogoutType.new(2)
ESessionLogoutType.SessionRelogin = ESessionLogoutType.new(3)
ESessionLogoutType.AccountConfigChange = ESessionLogoutType.new(4)
ESessionLogoutType.BMCConfigChange = ESessionLogoutType.new(5)

defs.SessionLogoutType = ESessionLogoutType

---@class defs.RmcpAuthAlgo: Enum
local ERmcpAuthAlgo = create_enum_type('RmcpAuthAlgo')
ERmcpAuthAlgo.default = ERmcpAuthAlgo.new(2147483647)
ERmcpAuthAlgo.struct = nil
ERmcpAuthAlgo.None = ERmcpAuthAlgo.new(0)
ERmcpAuthAlgo.HmacSha1 = ERmcpAuthAlgo.new(1)
ERmcpAuthAlgo.HmacMd5 = ERmcpAuthAlgo.new(2)
ERmcpAuthAlgo.HmacSha2 = ERmcpAuthAlgo.new(3)

defs.RmcpAuthAlgo = ERmcpAuthAlgo

---@class defs.AuthType: Enum
local EAuthType = create_enum_type('AuthType')
EAuthType.default = EAuthType.new(2147483647)
EAuthType.struct = nil
EAuthType.Local = EAuthType.new(0)
EAuthType.ldap_auto_match = EAuthType.new(1)
EAuthType.ldap_server1 = EAuthType.new(2)
EAuthType.ldap_server2 = EAuthType.new(3)
EAuthType.ldap_server3 = EAuthType.new(4)
EAuthType.ldap_server4 = EAuthType.new(5)
EAuthType.ldap_server5 = EAuthType.new(6)
EAuthType.ldap_server6 = EAuthType.new(7)
EAuthType.ldap_kerberos_sso = EAuthType.new(12)
EAuthType.kerberos_server = EAuthType.new(13)
EAuthType.sso_local = EAuthType.new(14)
EAuthType.sso_ldap = EAuthType.new(15)
EAuthType.auto_match = EAuthType.new(255)

defs.AuthType = EAuthType

---@class Authentication.AuthenticateRsp
---@field UserId integer
local TAuthenticateRsp = {}
TAuthenticateRsp.__index = TAuthenticateRsp
TAuthenticateRsp.group = {}

local function TAuthenticateRsp_from_obj(obj)
    return setmetatable(obj, TAuthenticateRsp)
end

function TAuthenticateRsp.new(UserId)
    return TAuthenticateRsp_from_obj({UserId = UserId})
end
---@param obj Authentication.AuthenticateRsp
function TAuthenticateRsp:init_from_obj(obj)
    self.UserId = obj.UserId
end

function TAuthenticateRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAuthenticateRsp.group)
end

TAuthenticateRsp.from_obj = TAuthenticateRsp_from_obj

TAuthenticateRsp.proto_property = {'UserId'}

TAuthenticateRsp.default = {0}

TAuthenticateRsp.struct = {{name = 'UserId', is_array = false, struct = nil}}

function TAuthenticateRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'UserId', self.UserId, 'int32', false, errs)

    TAuthenticateRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAuthenticateRsp.proto_property, errs)
    return self
end

function TAuthenticateRsp:unpack(_)
    return self.UserId
end

msg.AuthenticateRsp = TAuthenticateRsp

---@class Authentication.AuthenticateReq
---@field UserName string
---@field Password integer[]
local TAuthenticateReq = {}
TAuthenticateReq.__index = TAuthenticateReq
TAuthenticateReq.group = {}

local function TAuthenticateReq_from_obj(obj)
    return setmetatable(obj, TAuthenticateReq)
end

function TAuthenticateReq.new(UserName, Password)
    return TAuthenticateReq_from_obj({UserName = UserName, Password = Password})
end
---@param obj Authentication.AuthenticateReq
function TAuthenticateReq:init_from_obj(obj)
    self.UserName = obj.UserName
    self.Password = obj.Password
end

function TAuthenticateReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAuthenticateReq.group)
end

TAuthenticateReq.from_obj = TAuthenticateReq_from_obj

TAuthenticateReq.proto_property = {'UserName', 'Password'}

TAuthenticateReq.default = {'', {}}

TAuthenticateReq.struct = {
    {name = 'UserName', is_array = false, struct = nil},
    {name = 'Password', is_array = true, struct = nil}
}

function TAuthenticateReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'UserName', self.UserName, 'string', false, errs)
    validate.RequiredArray(prefix .. 'Password', self.Password, 'uint8', false, errs)

    validate.lens(prefix .. 'UserName', self.UserName, 1, 32, errs)
    validate.lens(prefix .. 'Password', self.Password, 1, 20, errs)

    TAuthenticateReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAuthenticateReq.proto_property, errs)
    return self
end

function TAuthenticateReq:unpack(_)
    return self.UserName, self.Password
end

msg.AuthenticateReq = TAuthenticateReq

local Authentication = {}

local Mdb = require 'mc.mdb'

---@class Authentication: Table
Authentication.Authentication = Mdb.register_interface('bmc.kepler.AccountService.Authentication',
    {}, {Authenticate = {'a{ss}say', 'i', msg.AuthenticateReq, msg.AuthenticateRsp}}, {})
return Authentication
