-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local singleton = require 'mc.singleton'
local function_get_version = require 'external_interface.function_get_version'

local handler = {}
handler.__index = handler

function handler.new(bus)
    return setmetatable({bus = bus}, handler)
end

function handler:get_all_version(...)
    return function_get_version.get_all_version(...)
end

function handler:get_version_by_type(...)
    return function_get_version.get_version_by_type(...)
end

return singleton(handler)