-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local SystemControl = {}

---@class SystemControl.GracefulResetRsp
---@field OutData integer
local TGracefulResetRsp = {}
TGracefulResetRsp.__index = TGracefulResetRsp
TGracefulResetRsp.group = {}

local function TGracefulResetRsp_from_obj(obj)
    return setmetatable(obj, TGracefulResetRsp)
end

function TGracefulResetRsp.new(OutData)
    return TGracefulResetRsp_from_obj({OutData = OutData})
end
---@param obj SystemControl.GracefulResetRsp
function TGracefulResetRsp:init_from_obj(obj)
    self.OutData = obj.OutData
end

function TGracefulResetRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGracefulResetRsp.group)
end

TGracefulResetRsp.from_obj = TGracefulResetRsp_from_obj

TGracefulResetRsp.proto_property = {'OutData'}

TGracefulResetRsp.default = {0}

TGracefulResetRsp.struct = {{name = 'OutData', is_array = false, struct = nil}}

function TGracefulResetRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OutData', self.OutData, 'int32', false, errs, need_convert)

    TGracefulResetRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGracefulResetRsp.proto_property, errs, need_convert)
    return self
end

function TGracefulResetRsp:unpack(_)
    return self.OutData
end

SystemControl.GracefulResetRsp = TGracefulResetRsp

---@class SystemControl.GracefulResetReq
---@field ResetType integer
local TGracefulResetReq = {}
TGracefulResetReq.__index = TGracefulResetReq
TGracefulResetReq.group = {}

local function TGracefulResetReq_from_obj(obj)
    return setmetatable(obj, TGracefulResetReq)
end

function TGracefulResetReq.new(ResetType)
    return TGracefulResetReq_from_obj({ResetType = ResetType})
end
---@param obj SystemControl.GracefulResetReq
function TGracefulResetReq:init_from_obj(obj)
    self.ResetType = obj.ResetType
end

function TGracefulResetReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGracefulResetReq.group)
end

TGracefulResetReq.from_obj = TGracefulResetReq_from_obj

TGracefulResetReq.proto_property = {'ResetType'}

TGracefulResetReq.default = {0}

TGracefulResetReq.struct = {{name = 'ResetType', is_array = false, struct = nil}}

function TGracefulResetReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ResetType', self.ResetType, 'uint8', false, errs, need_convert)

    TGracefulResetReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGracefulResetReq.proto_property, errs, need_convert)
    return self
end

function TGracefulResetReq:unpack(_)
    return self.ResetType
end

SystemControl.GracefulResetReq = TGracefulResetReq

---@class SystemControl.ForceResetRsp
local TForceResetRsp = {}
TForceResetRsp.__index = TForceResetRsp
TForceResetRsp.group = {}

local function TForceResetRsp_from_obj(obj)
    return setmetatable(obj, TForceResetRsp)
end

function TForceResetRsp.new()
    return TForceResetRsp_from_obj({})
end
---@param obj SystemControl.ForceResetRsp
function TForceResetRsp:init_from_obj(obj)

end

function TForceResetRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TForceResetRsp.group)
end

TForceResetRsp.from_obj = TForceResetRsp_from_obj

TForceResetRsp.proto_property = {}

TForceResetRsp.default = {}

TForceResetRsp.struct = {}

function TForceResetRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TForceResetRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TForceResetRsp.proto_property, errs, need_convert)
    return self
end

function TForceResetRsp:unpack(_)
end

SystemControl.ForceResetRsp = TForceResetRsp

---@class SystemControl.ForceResetReq
---@field ResetType integer
local TForceResetReq = {}
TForceResetReq.__index = TForceResetReq
TForceResetReq.group = {}

local function TForceResetReq_from_obj(obj)
    return setmetatable(obj, TForceResetReq)
end

function TForceResetReq.new(ResetType)
    return TForceResetReq_from_obj({ResetType = ResetType})
end
---@param obj SystemControl.ForceResetReq
function TForceResetReq:init_from_obj(obj)
    self.ResetType = obj.ResetType
end

function TForceResetReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TForceResetReq.group)
end

TForceResetReq.from_obj = TForceResetReq_from_obj

TForceResetReq.proto_property = {'ResetType'}

TForceResetReq.default = {0}

TForceResetReq.struct = {{name = 'ResetType', is_array = false, struct = nil}}

function TForceResetReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ResetType', self.ResetType, 'uint8', false, errs, need_convert)

    TForceResetReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TForceResetReq.proto_property, errs, need_convert)
    return self
end

function TForceResetReq:unpack(_)
    return self.ResetType
end

SystemControl.ForceResetReq = TForceResetReq

SystemControl.interface = mdb.register_interface('bmc.kepler.SystemControl', {}, {
    ForceReset = {'a{ss}y', '', TForceResetReq, TForceResetRsp},
    GracefulReset = {'a{ss}y', 'i', TGracefulResetReq, TGracefulResetRsp}
}, {})

return SystemControl
