-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local GPUTool = {}

---@class GPUTool.ImportRsp
---@field Result boolean
local TImportRsp = {}
TImportRsp.__index = TImportRsp
TImportRsp.group = {}

local function TImportRsp_from_obj(obj)
    return setmetatable(obj, TImportRsp)
end

function TImportRsp.new(Result)
    return TImportRsp_from_obj({Result = Result})
end
---@param obj GPUTool.ImportRsp
function TImportRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TImportRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportRsp.group)
end

TImportRsp.from_obj = TImportRsp_from_obj

TImportRsp.proto_property = {'Result'}

TImportRsp.default = {false}

TImportRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TImportRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'bool', false, errs, need_convert)

    TImportRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportRsp.proto_property, errs, need_convert)
    return self
end

function TImportRsp:unpack(_)
    return self.Result
end

GPUTool.ImportRsp = TImportRsp

---@class GPUTool.ImportReq
---@field Path string
---@field Resolution string
---@field BBP integer
local TImportReq = {}
TImportReq.__index = TImportReq
TImportReq.group = {}

local function TImportReq_from_obj(obj)
    return setmetatable(obj, TImportReq)
end

function TImportReq.new(Path, Resolution, BBP)
    return TImportReq_from_obj({Path = Path, Resolution = Resolution, BBP = BBP})
end
---@param obj GPUTool.ImportReq
function TImportReq:init_from_obj(obj)
    self.Path = obj.Path
    self.Resolution = obj.Resolution
    self.BBP = obj.BBP
end

function TImportReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportReq.group)
end

TImportReq.from_obj = TImportReq_from_obj

TImportReq.proto_property = {'Path', 'Resolution', 'BBP'}

TImportReq.default = {'', '', 0}

TImportReq.struct = {
    {name = 'Path', is_array = false, struct = nil}, {name = 'Resolution', is_array = false, struct = nil},
    {name = 'BBP', is_array = false, struct = nil}
}

function TImportReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Path', self.Path, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Resolution', self.Resolution, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'BBP', self.BBP, 'uint8', false, errs, need_convert)

    TImportReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportReq.proto_property, errs, need_convert)
    return self
end

function TImportReq:unpack(_)
    return self.Path, self.Resolution, self.BBP
end

GPUTool.ImportReq = TImportReq

GPUTool.interface = mdb.register_interface('bmc.kepler.Managers.SOC.GPUTool', {},
    {Import = {'a{ss}ssy', 'b', TImportReq, TImportRsp}}, {})

return GPUTool
