--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetTestItemCount = {}

---@class ManufactureIpmiCmds.GetTestItemCountReq
---@field Type integer
local TGetTestItemCountReq = {}
TGetTestItemCountReq.__index = TGetTestItemCountReq
TGetTestItemCountReq.group = {}

local function TGetTestItemCountReq_from_obj(obj)
    return setmetatable(obj, TGetTestItemCountReq)
end

function TGetTestItemCountReq.new(Type)
    return TGetTestItemCountReq_from_obj({Type = Type})
end
---@param obj ManufactureIpmiCmds.GetTestItemCountReq
function TGetTestItemCountReq:init_from_obj(obj)
    self.Type = obj.Type
end

function TGetTestItemCountReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetTestItemCountReq.group)
end

TGetTestItemCountReq.from_obj = TGetTestItemCountReq_from_obj

TGetTestItemCountReq.proto_property = {'Type'}

TGetTestItemCountReq.default = {0}

TGetTestItemCountReq.struct = {{name = 'Type', is_array = false, struct = nil}}

function TGetTestItemCountReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'uint8', false, errs, need_convert)

    TGetTestItemCountReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetTestItemCountReq.proto_property, errs, need_convert)
    return self
end

function TGetTestItemCountReq:unpack(_)
    return self.Type
end

GetTestItemCount.GetTestItemCountReq = TGetTestItemCountReq

---@class ManufactureIpmiCmds.GetTestItemCountRsp
---@field CompletionCode integer
---@field Count integer
local TGetTestItemCountRsp = {}
TGetTestItemCountRsp.__index = TGetTestItemCountRsp
TGetTestItemCountRsp.group = {}

local function TGetTestItemCountRsp_from_obj(obj)
    return setmetatable(obj, TGetTestItemCountRsp)
end

function TGetTestItemCountRsp.new(CompletionCode, Count)
    return TGetTestItemCountRsp_from_obj({CompletionCode = CompletionCode, Count = Count})
end
---@param obj ManufactureIpmiCmds.GetTestItemCountRsp
function TGetTestItemCountRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Count = obj.Count
end

function TGetTestItemCountRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetTestItemCountRsp.group)
end

TGetTestItemCountRsp.from_obj = TGetTestItemCountRsp_from_obj

TGetTestItemCountRsp.proto_property = {'CompletionCode', 'Count'}

TGetTestItemCountRsp.default = {0, 0}

TGetTestItemCountRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Count', is_array = false, struct = nil}
}

function TGetTestItemCountRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Count', self.Count, 'uint8', false, errs, need_convert)

    TGetTestItemCountRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetTestItemCountRsp.proto_property, errs, need_convert)
    return self
end

function TGetTestItemCountRsp:unpack(_)
    return self.CompletionCode, self.Count
end

GetTestItemCount.GetTestItemCountRsp = TGetTestItemCountRsp

return GetTestItemCount
