# manifest

openUBMC产品集成配置仓

## dockerfile使用介绍

在本仓中提供dockerfile文件，该文件包含了构建openUBMC环境镜像的所有指令。

1、开发者需前往[openUBMC社区软件应用中心](https://openubmc.cn/easysoftware/bmcsdk)下载bmcsdk，并将下载的bmcsdk文件存放在此代码仓目录下。然后，在manifest目录下，执行以下命令可构建一个名称为`openubmc/25.03`的镜像：

```
docker build -t openubmc/25.03 . --build-arg BMC_SDK_PATH=./bmc_sdk.zip
```

参数说明：

`-t` 定义镜像名称

2、构建成功后，可查看镜像是否加载成功：

```
docker images
```


3、创建上述生成的`openubmc/25.03`镜像的Container实例，并将Container实例命名为`openubmc`：
```
docker run -itd --privileged=true --mount type=bind,source=/root/workspace,target=/home/workspace --restart=always --name openubmc openubmc/25.03 conan_server
```

参数说明：

`-itd` 以非交互方式启动容器。

`--privileged=true` 使容器内的root用户真正拥有了root权限，否则容器中的root用户只是一个外部普通用户权限。

`--mount` 将上述在宿主机创建的共组哦文件夹`/root/workspace`与Container中的`/home/workspace`链接作为同步文件夹。

`--restart=always` 系统重启时自动启动容器。

`--name` 定义容器的名称。

4、查看正在运行的容器：

```
docker ps
```

5、进入`openubmc`容器：

```
docker exec -it openubmc /bin/bash
```

执行成功，此时已进入`openubmc`容器。

6、开发者进入容器可以使用自己的openUBMC社区账户的用户名和密码配置conan中心仓，以支持从conan中心仓获取已发布的组件包：

```
conan user <openUBMC社区用户名> -p "<openUBMC社区用户密码>" -r openubmc_dev
```

7、由于openubmc的大部分conan包都使用scm记录源码信息，其中url一般为https链接，如果对应的代码仓是私密的，则需要配置token，否则会导致构建失败。此步骤详细介绍可参考[官方指导说明](https://git-scm.com/book/zh/v2/Git-%E5%B7%A5%E5%85%B7-%E5%87%AD%E8%AF%81%E5%AD%98%E5%82%A8)。在容器中配置git的HTTPS个人令牌进行身份认证：

在个人的git仓中新建访问令牌，设置名称和到期时间，并配置访问令牌的权限范围后新建访问令牌。注意：建议访问令牌权限均设置为只读，防止令牌泄露影响开发者账户安全，新建访问令牌成功后，妥善保存个人访问令牌，gitcode页面关闭后，将不再显示个人令牌。

设置git认证配置：

```
git config --global credential.helper 'store --file ~/.git-credentials'
```

写入个人访问令牌：

```
echo 'https://<gitcode账户>:<个人访问令牌>@gitcode.com' > ~/.git-credentials
```

8、开发者在容器中进行本地开发，还需要在容器中配置git的SSH密钥：

```
git config --global user.name <你的用户名>
git config --global user.email <你的邮箱>
```
生成RSA密钥：
```
ssh-keygen -t rsa -b 2048 -C <你的邮箱>
```
查看 RSA 公钥：

```
cat ~/.ssh/id_rsa.pub
```
将控制台返回的RSA密钥配置到SSH key中。

之后，开发者便可以在容器中克隆git仓库中的代码，并在容器中使用`bingo`命令构建组件包和制品包等操作。

## Qemu启动
通过执行如下命令可以一键式启动Qemu仿真环境，在其中体验openUBMC

```shell
python3 build/works/packet/qemu_shells/vemake_1711.py
```
当出现如下回显时，Qemu环境就正式启动了
```shell
Uncompressing... done, booting...
[    0.000000] Booting Linux on physical CPU 0x0000000000 [0x412fd050]
[    0.000000] Linux version 5.10.0 (oe-user@oe-host) (aarch64-euler-linux-gcc (BiSheng Embedded CPU 302.1.0.B016) 7.3.0, GNU ld (BiSheng Embedded CPU 302.1.0.B016) 2.41) #1 SMP PREEMPT Tue Nov 26 22:03:48 CST 2024
```

当然你也可以通过配置`build/works/packet/qemu_shells/config.json`文件来决定启动Qemu的方式,同时也可以参考`build/works/packet/qemu_shells/schema.json`来获取对应配置详情。