-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local lu = require 'luaunit'

TestC = {}

function TestC:test_require()
    local ok, lsw_drv = pcall(require, 'lsw_drv')
    lu.assertEquals(ok, true)

    local except_C_function_list = {
        "l_getAsicReg",
        "l_setAsicReg",
        "l_port_phyReg_get",
        "l_port_phyReg_set",
        "l_bus_init", 
        "l_chip_init",
        "l_phy_init",
        "l_lsw_vlan_init",
        "l_lsw_single_vlan_init", 
        "l_lsw_port_vlan_init", 
        "l_port_init", 
        "l_lsw_switch_soft_reset",
        "l_get_oem_type_by_unit", 
        "l_get_phy_type", 
        "l_get_port_status", 
        "l_rtl_8367_is_phy_abnormal", 
        "l_lsw_port_isolation_get", 
        "l_lsw_get_switch_port_auto_nego",
        "l_lsw_stp_mstpState_get",
        "l_rtl_8367_routine_port_pkt_cnt",
        "l_cfg_port_iso",
        "l_cfg_port_storm", 
        "l_get_port_enable",
        "l_set_port_enable", 
        "l_get_port_stp_state", 
        "l_set_port_stp_state", 
        "l_get_switch_error_code", 
        "l_get_port_mac_info",
        "l_set_port_mac_addr",
        "l_get_port_l2_addr",
        "l_flush_port_l2_addr"
    }
    
    for _, item in pairs(except_C_function_list) do
        lu.assertEquals(type(lsw_drv[item]), 'function')
    end

    local ok 
    ok , _ = pcall(lsw_drv.l_getAsicReg, '0xff',0,0)
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_setAsicReg, '0xff', 0, 0, 0)
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_port_phyReg_get, '0xff', 0, 0, 0)
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_port_phyReg_set, '0xff', 0, 0, 0, 0)
    lu.assertEquals(ok, true)
    
    ok , _ = pcall(lsw_drv.l_bus_init, 0)
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_chip_init, '0xff', 0, 0)
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_phy_init, '0xff', 0, '0x00', 0)
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_lsw_vlan_init, 0, 0)
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_lsw_single_vlan_init, '0xff', 0, 0, 0, 0)
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_lsw_port_vlan_init, '0xff', 0, 0, 0, 0)
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_port_init, '0xff', 0, 0, 0)
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_cfg_port_iso, '0xff', '0xff', '0xff', 0)
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_cfg_port_storm, '0xff', '0xff', '0xff')
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_lsw_switch_soft_reset, '0xff', '0xff')
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_get_port_status, '0xff', '0xff', 0, 0, '0xff', 0)
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_rtl_8367_is_phy_abnormal, '0xff', 0, 0, '0xff', 0, 0)
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_lsw_port_isolation_get, '0xff', '0xff', 0)
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_lsw_get_switch_port_auto_nego, '0xff', '0xff', 0, 0)
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_lsw_stp_mstpState_get, '0xff', '0xff', 0)
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_rtl_8367_routine_port_pkt_cnt, '0xff', '0xff', 0)
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_get_port_enable, '0xff', '0xff', 0)
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_set_port_enable, '0xff', '0xff', 0, 0)
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_get_port_stp_state, '0xff', '0xff', 0)
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_set_port_stp_state, '0xff', '0xff', 0, 0)
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_get_switch_error_code, '0xff', '0xff', 0)
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_get_port_mac_info, '0xff', '0xff', 0)
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_set_port_mac_addr, '0xff', '0xff', 0, '0xff')
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_get_port_l2_addr, '0xff', '0xff', 0)
    lu.assertEquals(ok, true)

    ok , _ = pcall(lsw_drv.l_flush_port_l2_addr, '0xff', '0xff', 0)
    lu.assertEquals(ok, true)

end

function TestC:test_l_port_phyReg_get()
    local _, lsw_drv = pcall(require, 'lsw_drv')
    print("start test_test_l_port_phyReg_get")
    local ok, _ = pcall(lsw_drv.l_port_phyReg_get, 0, 0, 0 , 0)
    lu.assertEquals(ok, true)
end


function TestC:test_l_lsw_vlan_init()
    local _, lsw_drv = pcall(require, 'lsw_drv')
    print("start test_test_l_lsw_vlan_init")
    local ok, _ = pcall(lsw_drv.l_lsw_vlan_init, 0, 0)
    lu.assertEquals(ok, true)
end

function TestC:test_l_get_phy_type()
    local _, lsw_drv = pcall(require, 'lsw_drv')
    print("start test_test_l_get_phy_type")
    local ok, _ = pcall(lsw_drv.l_get_phy_type, 0)
    lu.assertEquals(ok, true)
end


function TestC:test_l_bus_init()
    local _, lsw_drv = pcall(require, 'lsw_drv')
    print("start test_l_get_oem_type_by_unit first time")
    local ok, _ = pcall(lsw_drv.l_get_oem_type_by_unit, 0)
    lu.assertEquals(ok, true)

    
    print("start test_l_bus_init")
    ok, _ = pcall(lsw_drv.l_bus_init, 0x1)
    lu.assertEquals(ok, true)
    print("start test_l_get_oem_type_by_unit")
    ok, _ = pcall(lsw_drv.l_get_oem_type_by_unit, 0)
    lu.assertEquals(ok, true)
end

