--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetPortLinkStatus = {}

---@class LswIpmiCmds.GetPortLinkStatusReq
---@field FruId integer
---@field PortId integer
local TGetPortLinkStatusReq = {}
TGetPortLinkStatusReq.__index = TGetPortLinkStatusReq
TGetPortLinkStatusReq.group = {}

local function TGetPortLinkStatusReq_from_obj(obj)
    return setmetatable(obj, TGetPortLinkStatusReq)
end

function TGetPortLinkStatusReq.new(FruId, PortId)
    return TGetPortLinkStatusReq_from_obj({FruId = FruId, PortId = PortId})
end
---@param obj LswIpmiCmds.GetPortLinkStatusReq
function TGetPortLinkStatusReq:init_from_obj(obj)
    self.FruId = obj.FruId
    self.PortId = obj.PortId
end

function TGetPortLinkStatusReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPortLinkStatusReq.group)
end

TGetPortLinkStatusReq.from_obj = TGetPortLinkStatusReq_from_obj

TGetPortLinkStatusReq.proto_property = {'FruId', 'PortId'}

TGetPortLinkStatusReq.default = {0, 0}

TGetPortLinkStatusReq.struct = {
    {name = 'FruId', is_array = false, struct = nil}, {name = 'PortId', is_array = false, struct = nil}
}

function TGetPortLinkStatusReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'PortId', self.PortId, 'uint8', false, errs, need_convert)

    TGetPortLinkStatusReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPortLinkStatusReq.proto_property, errs, need_convert)
    return self
end

function TGetPortLinkStatusReq:unpack(_)
    return self.FruId, self.PortId
end

GetPortLinkStatus.GetPortLinkStatusReq = TGetPortLinkStatusReq

---@class LswIpmiCmds.GetPortLinkStatusRsp
---@field CompletionCode integer
---@field LinkStates integer
local TGetPortLinkStatusRsp = {}
TGetPortLinkStatusRsp.__index = TGetPortLinkStatusRsp
TGetPortLinkStatusRsp.group = {}

local function TGetPortLinkStatusRsp_from_obj(obj)
    return setmetatable(obj, TGetPortLinkStatusRsp)
end

function TGetPortLinkStatusRsp.new(CompletionCode, LinkStates)
    return TGetPortLinkStatusRsp_from_obj({CompletionCode = CompletionCode, LinkStates = LinkStates})
end
---@param obj LswIpmiCmds.GetPortLinkStatusRsp
function TGetPortLinkStatusRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.LinkStates = obj.LinkStates
end

function TGetPortLinkStatusRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetPortLinkStatusRsp.group)
end

TGetPortLinkStatusRsp.from_obj = TGetPortLinkStatusRsp_from_obj

TGetPortLinkStatusRsp.proto_property = {'CompletionCode', 'LinkStates'}

TGetPortLinkStatusRsp.default = {0, 0}

TGetPortLinkStatusRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'LinkStates', is_array = false, struct = nil}
}

function TGetPortLinkStatusRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'LinkStates', self.LinkStates, 'uint8', false, errs, need_convert)

    TGetPortLinkStatusRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetPortLinkStatusRsp.proto_property, errs, need_convert)
    return self
end

function TGetPortLinkStatusRsp:unpack(_)
    return self.CompletionCode, self.LinkStates
end

GetPortLinkStatus.GetPortLinkStatusRsp = TGetPortLinkStatusRsp

return GetPortLinkStatus
