-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MLswVlanInfo = {}

---@class MLswVlanInfo.Untaged
---@field Untaged integer
local TUntaged = {}
TUntaged.__index = TUntaged
TUntaged.group = {}

local function TUntaged_from_obj(obj)
    return setmetatable(obj, TUntaged)
end

function TUntaged.new(Untaged)
    return TUntaged_from_obj({Untaged = Untaged})
end
---@param obj MLswVlanInfo.Untaged
function TUntaged:init_from_obj(obj)
    self.Untaged = obj.Untaged
end

function TUntaged:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUntaged.group)
end

TUntaged.from_obj = TUntaged_from_obj

TUntaged.proto_property = {'Untaged'}

TUntaged.default = {0}

TUntaged.struct = {{name = 'Untaged', is_array = false, struct = nil}}

function TUntaged:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Untaged', self.Untaged, 'uint32', false, errs, need_convert)

    TUntaged:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUntaged.proto_property, errs, need_convert)
    return self
end

function TUntaged:unpack(_)
    return self.Untaged
end

MLswVlanInfo.Untaged = TUntaged

---@class MLswVlanInfo.Member
---@field Member integer
local TMember = {}
TMember.__index = TMember
TMember.group = {}

local function TMember_from_obj(obj)
    return setmetatable(obj, TMember)
end

function TMember.new(Member)
    return TMember_from_obj({Member = Member})
end
---@param obj MLswVlanInfo.Member
function TMember:init_from_obj(obj)
    self.Member = obj.Member
end

function TMember:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TMember.group)
end

TMember.from_obj = TMember_from_obj

TMember.proto_property = {'Member'}

TMember.default = {0}

TMember.struct = {{name = 'Member', is_array = false, struct = nil}}

function TMember:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Member', self.Member, 'uint32', false, errs, need_convert)

    TMember:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TMember.proto_property, errs, need_convert)
    return self
end

function TMember:unpack(_)
    return self.Member
end

MLswVlanInfo.Member = TMember

---@class MLswVlanInfo.VlanId
---@field VlanId integer
local TVlanId = {}
TVlanId.__index = TVlanId
TVlanId.group = {}

local function TVlanId_from_obj(obj)
    return setmetatable(obj, TVlanId)
end

function TVlanId.new(VlanId)
    return TVlanId_from_obj({VlanId = VlanId})
end
---@param obj MLswVlanInfo.VlanId
function TVlanId:init_from_obj(obj)
    self.VlanId = obj.VlanId
end

function TVlanId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVlanId.group)
end

TVlanId.from_obj = TVlanId_from_obj

TVlanId.proto_property = {'VlanId'}

TVlanId.default = {0}

TVlanId.struct = {{name = 'VlanId', is_array = false, struct = nil}}

function TVlanId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VlanId', self.VlanId, 'uint32', false, errs, need_convert)

    TVlanId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVlanId.proto_property, errs, need_convert)
    return self
end

function TVlanId:unpack(_)
    return self.VlanId
end

MLswVlanInfo.VlanId = TVlanId

---@class MLswVlanInfo.Unit
---@field Unit integer
local TUnit = {}
TUnit.__index = TUnit
TUnit.group = {}

local function TUnit_from_obj(obj)
    return setmetatable(obj, TUnit)
end

function TUnit.new(Unit)
    return TUnit_from_obj({Unit = Unit})
end
---@param obj MLswVlanInfo.Unit
function TUnit:init_from_obj(obj)
    self.Unit = obj.Unit
end

function TUnit:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUnit.group)
end

TUnit.from_obj = TUnit_from_obj

TUnit.proto_property = {'Unit'}

TUnit.default = {0}

TUnit.struct = {{name = 'Unit', is_array = false, struct = nil}}

function TUnit:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Unit', self.Unit, 'uint32', false, errs, need_convert)

    TUnit:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUnit.proto_property, errs, need_convert)
    return self
end

function TUnit:unpack(_)
    return self.Unit
end

MLswVlanInfo.Unit = TUnit

return MLswVlanInfo
