-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local vos = require 'utils.vos'

local SessionUtils = {}
local SESSION_TOKEN_LEN = 32
function SessionUtils.generate_token()
    local random_string = vos.get_random_array(SESSION_TOKEN_LEN):gsub('.', function(s)
        return string.format('%02x', s:byte())
    end)
    return random_string
end

function SessionUtils.generate_session_id(token)
    return vos.compute_checksum(vos.G_CHECKSUM_SHA256, token):sub(1, 24)
end

return SessionUtils
