-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local class = require 'mc.class'
local singleton = require 'mc.singleton'
local session_collection = require 'session.domain.session_collection'
local enum = require 'class.types.types'
local SessionCollectionKVM = class(session_collection)

function SessionCollectionKVM:ctor()
    self.session_type = enum.SessionType.new(4)
    self.session_type_string = "KVM"
end

function SessionCollectionKVM:init()
    SessionCollectionKVM.super.init(self)
end

function SessionCollectionKVM:set_kvm_key(ctx, kvm_key, session_mode)
    --todo 检验key
    self.key_info = {
        key = kvm_key,
        mode = session_mode,
        created_time = os.time(),
        user_name = ctx.Username
    }
end

function SessionCollectionKVM:get_kvm_key()
    --todo 检验key
    return self.key_info
end

return singleton(SessionCollectionKVM)
